/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

public enum GatewayError {
    EXCEPTION(0),
    DUPLICATE_SESSION(1),
    UNABLE_TO_CONNECT(2),
    UNKNOWN_LIBRARY(3),
    DUPLICATE_LIBRARY_ID(4),
    DUPLICATE_ACCEPTOR(5),
    UNKNOWN_SESSION(6),
    UNABLE_TO_LOGON(7),
    INVALID_CONFIGURATION(8),
    NULL_VAL(65535);

    private final int value;

    private GatewayError(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static GatewayError get(int value) {
        switch (value) {
            case 0: {
                return EXCEPTION;
            }
            case 1: {
                return DUPLICATE_SESSION;
            }
            case 2: {
                return UNABLE_TO_CONNECT;
            }
            case 3: {
                return UNKNOWN_LIBRARY;
            }
            case 4: {
                return DUPLICATE_LIBRARY_ID;
            }
            case 5: {
                return DUPLICATE_ACCEPTOR;
            }
            case 6: {
                return UNKNOWN_SESSION;
            }
            case 7: {
                return UNABLE_TO_LOGON;
            }
            case 8: {
                return INVALID_CONFIGURATION;
            }
        }
        if (65535 == value) {
            return NULL_VAL;
        }
        throw new IllegalArgumentException("Unknown value: " + value);
    }
}

