/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.otf;

import org.agrona.collections.IntHashSet;
import uk.co.real_logic.artio.ValidationError;
import uk.co.real_logic.artio.dictionary.IntDictionary;
import uk.co.real_logic.artio.fields.AsciiFieldFlyweight;
import uk.co.real_logic.artio.otf.MessageControl;
import uk.co.real_logic.artio.otf.OtfMessageAcceptor;
import uk.co.real_logic.artio.util.AsciiBuffer;

public final class OtfValidator
implements OtfMessageAcceptor {
    private static final int UNKNOWN = -1;
    private final IntHashSet fieldsForMessage = new IntHashSet(1024);
    private final AsciiFieldFlyweight stringField = new AsciiFieldFlyweight();
    private final OtfMessageAcceptor delegate;
    private final IntDictionary allFields;
    private final IntDictionary requiredFields;
    private int groupLevel = 0;
    private int messageType;
    private IntHashSet allFieldsForMessageType;

    public OtfValidator(OtfMessageAcceptor delegate, IntDictionary allFields, IntDictionary requiredFields) {
        this.delegate = delegate;
        this.allFields = allFields;
        this.requiredFields = requiredFields;
    }

    @Override
    public MessageControl onNext() {
        this.delegate.onNext();
        this.fieldsForMessage.clear();
        this.messageType = -1;
        this.allFieldsForMessageType = null;
        return MessageControl.CONTINUE;
    }

    @Override
    public MessageControl onComplete() {
        IntHashSet missingFields = this.requiredFields.values(this.messageType).difference(this.fieldsForMessage);
        if (missingFields == null) {
            return this.delegate.onComplete();
        }
        IntHashSet.IntIterator intIterator = missingFields.iterator();
        while (intIterator.hasNext()) {
            int value = (Integer)intIterator.next();
            this.delegate.onError(ValidationError.MISSING_REQUIRED_FIELD, this.messageType, value, this.stringField);
        }
        return MessageControl.CONTINUE;
    }

    @Override
    public MessageControl onField(int tag, AsciiBuffer buffer, int offset, int length) {
        if (this.groupLevel == 0) {
            if (tag == 35) {
                this.messageType = buffer.getMessageType(offset, length);
                this.allFieldsForMessageType = this.allFields.values(this.messageType);
                if (this.allFieldsForMessageType == null) {
                    this.delegate.onError(ValidationError.UNKNOWN_MESSAGE_TYPE, this.messageType, -1, this.stringField);
                    return MessageControl.STOP;
                }
            } else if (!this.allFieldsForMessageType.contains(tag)) {
                this.delegate.onError(ValidationError.UNKNOWN_FIELD, this.messageType, tag, this.stringField);
                return MessageControl.STOP;
            }
        }
        this.fieldsForMessage.add(tag);
        return this.delegate.onField(tag, buffer, offset, length);
    }

    @Override
    public MessageControl onGroupHeader(int tag, int numInGroup) {
        ++this.groupLevel;
        return this.delegate.onGroupHeader(tag, numInGroup);
    }

    @Override
    public MessageControl onGroupBegin(int tag, int numInGroup, int index) {
        return this.delegate.onGroupBegin(tag, numInGroup, index);
    }

    @Override
    public MessageControl onGroupEnd(int tag, int numInGroup, int index) {
        MessageControl control = this.delegate.onGroupEnd(tag, numInGroup, index);
        if (numInGroup == index + 1) {
            --this.groupLevel;
        }
        return control;
    }

    @Override
    public boolean onError(ValidationError error, int messageType, int tagNumber, AsciiFieldFlyweight value) {
        return this.delegate.onError(error, messageType, tagNumber, value);
    }
}

