/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.otf;

import org.agrona.DirectBuffer;
import org.agrona.collections.IntHashSet;
import uk.co.real_logic.artio.ValidationError;
import uk.co.real_logic.artio.dictionary.IntDictionary;
import uk.co.real_logic.artio.fields.AsciiFieldFlyweight;
import uk.co.real_logic.artio.otf.MessageControl;
import uk.co.real_logic.artio.otf.OtfMessageAcceptor;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public final class OtfParser {
    private static final int NO_CHECKSUM = -2;
    private static final int UNKNOWN = -1;
    private final AsciiBuffer string = new MutableAsciiBuffer();
    private final AsciiFieldFlyweight stringField = new AsciiFieldFlyweight();
    private final OtfMessageAcceptor acceptor;
    private final IntDictionary groupToField;
    private int checksum;
    private int checksumOffset;
    private int messageType;
    private int tag;

    public OtfParser(OtfMessageAcceptor acceptor, IntDictionary groupToField) {
        this.acceptor = acceptor;
        this.groupToField = groupToField;
    }

    public void onMessage(DirectBuffer buffer, int offset, int length) {
        this.string.wrap(buffer);
        if (this.acceptor.onNext() == MessageControl.STOP) {
            return;
        }
        this.tag = -1;
        this.messageType = -1;
        this.checksum = -2;
        this.checksumOffset = 0;
        try {
            if (this.parseFields(offset, offset + length, -1, null, 0) < 0) {
                return;
            }
            if (this.validChecksum(offset, this.checksum)) {
                this.acceptor.onComplete();
            } else {
                this.invalidChecksum(this.messageType);
            }
        }
        catch (NumberFormatException ex) {
            this.parseError(this.messageType, this.tag);
        }
    }

    private int parseFields(int offset, int end, int groupTag, IntHashSet groupFields, int numberOfElementsInGroup) {
        int firstFieldInGroup = -1;
        int indexOfGroupElement = 0;
        int position = offset;
        while (position < end) {
            int equalsPosition = this.string.scan(position, end, '=');
            if (!this.validatePosition(equalsPosition, this.acceptor)) {
                return position;
            }
            this.tag = this.string.getNatural(position, equalsPosition);
            int valueOffset = equalsPosition + 1;
            int endOfField = this.string.scan(valueOffset, end, (byte)1);
            if (!this.validatePosition(endOfField, this.acceptor)) {
                return position;
            }
            int valueLength = endOfField - valueOffset;
            IntHashSet newGroupFields = this.groupToField.values(this.tag);
            if (newGroupFields == null) {
                if (this.insideAGroup(groupTag)) {
                    if (this.isEndOfGroup(groupFields)) {
                        this.groupEnd(groupTag, numberOfElementsInGroup, indexOfGroupElement);
                        return position;
                    }
                    if (firstFieldInGroup == -1) {
                        firstFieldInGroup = this.tag;
                    } else if (this.tag == firstFieldInGroup) {
                        if (this.groupEnd(groupTag, numberOfElementsInGroup, indexOfGroupElement) == MessageControl.STOP) {
                            return position;
                        }
                        if (this.groupBegin(groupTag, numberOfElementsInGroup, ++indexOfGroupElement) == MessageControl.STOP) {
                            return position;
                        }
                    }
                }
                MessageControl control = this.acceptor.onField(this.tag, this.string, valueOffset, valueLength);
                this.collectImportantFields(equalsPosition, valueOffset, endOfField, valueLength);
                position = endOfField + 1;
                if (control != MessageControl.STOP) continue;
                return ~position;
            }
            if (this.insideAGroup(groupTag) && this.isEndOfGroup(groupFields)) {
                this.groupEnd(groupTag, numberOfElementsInGroup, indexOfGroupElement);
                return position;
            }
            position = this.parseGroup(this.tag, valueOffset, endOfField, end, newGroupFields);
            if (position >= 0) continue;
            return position;
        }
        return position;
    }

    private int parseGroup(int tag, int valueOffset, int endOfField, int end, IntHashSet groupFields) {
        int numberOfElements = this.string.getNatural(valueOffset, endOfField);
        this.acceptor.onGroupHeader(tag, numberOfElements);
        if (numberOfElements > 0) {
            if (this.groupBegin(tag, numberOfElements, 0) == MessageControl.STOP) {
                return ~endOfField;
            }
            int position = this.parseFields(endOfField + 1, end, tag, groupFields, numberOfElements);
            if (position == end && this.groupEnd(tag, numberOfElements, numberOfElements - 1) == MessageControl.STOP) {
                return ~position;
            }
            return position;
        }
        return endOfField;
    }

    private boolean isEndOfGroup(IntHashSet groupFields) {
        return !groupFields.contains(this.tag);
    }

    private void collectImportantFields(int equalsPosition, int valueOffset, int endOfField, int valueLength) {
        if (this.tag == 10) {
            this.checksum = this.string.getNatural(valueOffset, endOfField);
            this.checksumOffset = equalsPosition - 2;
        } else if (this.tag == 35) {
            this.messageType = this.string.getMessageType(valueOffset, valueLength);
        }
    }

    private boolean insideAGroup(int tag) {
        return tag != -1;
    }

    private MessageControl groupBegin(int tag, int numberOfElements, int index) {
        return this.acceptor.onGroupBegin(tag, numberOfElements, index);
    }

    private MessageControl groupEnd(int tag, int numberOfElements, int index) {
        return this.acceptor.onGroupEnd(tag, numberOfElements, index);
    }

    private boolean parseError(int messageType, int tag) {
        return this.acceptor.onError(ValidationError.PARSE_ERROR, messageType, tag, this.stringField);
    }

    private boolean invalidChecksum(int messageType) {
        return this.acceptor.onError(ValidationError.INVALID_CHECKSUM, messageType, 10, this.stringField);
    }

    private boolean validatePosition(int position, OtfMessageAcceptor acceptor) {
        if (position == -1) {
            acceptor.onError(ValidationError.PARSE_ERROR, this.messageType, this.tag, null);
            return false;
        }
        return true;
    }

    private boolean validChecksum(int offset, int messageChecksum) {
        if (messageChecksum == -2) {
            return false;
        }
        int correctChecksum = this.string.computeChecksum(offset, this.checksumOffset);
        return correctChecksum == messageChecksum;
    }
}

