/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary;

import java.io.File;
import java.io.FileInputStream;
import org.agrona.generation.OutputManager;
import org.agrona.generation.PackageOutputManager;
import uk.co.real_logic.artio.builder.RejectUnknownEnumValue;
import uk.co.real_logic.artio.builder.RejectUnknownField;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.dictionary.DictionaryParser;
import uk.co.real_logic.artio.dictionary.generation.AcceptorGenerator;
import uk.co.real_logic.artio.dictionary.generation.ConstantGenerator;
import uk.co.real_logic.artio.dictionary.generation.DecoderGenerator;
import uk.co.real_logic.artio.dictionary.generation.EncoderGenerator;
import uk.co.real_logic.artio.dictionary.generation.EnumGenerator;
import uk.co.real_logic.artio.dictionary.generation.GenerationUtil;
import uk.co.real_logic.artio.dictionary.generation.PrinterGenerator;
import uk.co.real_logic.artio.dictionary.ir.Dictionary;

public final class CodecGenerationTool {
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            CodecGenerationTool.printUsageAndExit();
        }
        String outputPath = args[0];
        String files = args[1];
        String[] fileNames = files.split(";");
        if (fileNames.length > 2) {
            System.err.print("Two many dictionary files(1 or 2 dictionaries supported)." + files);
            CodecGenerationTool.printUsageAndExit();
        }
        Dictionary dictionary = null;
        for (String fileName : fileNames) {
            File xmlFile = new File(fileName);
            dictionary = CodecGenerationTool.parseDictionary(xmlFile, dictionary);
        }
        PackageOutputManager parentOutput = new PackageOutputManager(outputPath, GenerationUtil.PARENT_PACKAGE);
        PackageOutputManager decoderOutput = new PackageOutputManager(outputPath, GenerationUtil.DECODER_PACKAGE);
        PackageOutputManager encoderOutput = new PackageOutputManager(outputPath, GenerationUtil.ENCODER_PACKAGE);
        EnumGenerator enumGenerator = new EnumGenerator(dictionary, GenerationUtil.PARENT_PACKAGE, (OutputManager)parentOutput);
        ConstantGenerator constantGenerator = new ConstantGenerator(dictionary, GenerationUtil.PARENT_PACKAGE, (OutputManager)parentOutput);
        EncoderGenerator encoderGenerator = new EncoderGenerator(dictionary, GenerationUtil.ENCODER_PACKAGE, GenerationUtil.PARENT_PACKAGE, (OutputManager)encoderOutput, Validation.class, RejectUnknownField.class, RejectUnknownEnumValue.class);
        DecoderGenerator decoderGenerator = new DecoderGenerator(dictionary, 1, GenerationUtil.DECODER_PACKAGE, GenerationUtil.PARENT_PACKAGE, (OutputManager)decoderOutput, Validation.class, RejectUnknownField.class, RejectUnknownEnumValue.class, false);
        PrinterGenerator printerGenerator = new PrinterGenerator(dictionary, GenerationUtil.DECODER_PACKAGE, (OutputManager)decoderOutput);
        AcceptorGenerator acceptorGenerator = new AcceptorGenerator(dictionary, GenerationUtil.DECODER_PACKAGE, (OutputManager)decoderOutput);
        enumGenerator.generate();
        constantGenerator.generate();
        encoderGenerator.generate();
        decoderGenerator.generate();
        printerGenerator.generate();
        acceptorGenerator.generate();
        if (GenerationUtil.FLYWEIGHTS_ENABLED) {
            PackageOutputManager flyweightDecoderOutput = new PackageOutputManager(outputPath, GenerationUtil.DECODER_FLYWEIGHT_PACKAGE);
            DecoderGenerator flyweightDecoderGenerator = new DecoderGenerator(dictionary, 1, GenerationUtil.DECODER_FLYWEIGHT_PACKAGE, GenerationUtil.PARENT_PACKAGE, (OutputManager)flyweightDecoderOutput, Validation.class, RejectUnknownField.class, RejectUnknownEnumValue.class, true);
            flyweightDecoderGenerator.generate();
        }
    }

    private static Dictionary parseDictionary(File xmlFile, Dictionary parentDictionary) throws Exception {
        DictionaryParser parser = new DictionaryParser();
        if (!xmlFile.exists()) {
            System.err.println("xmlFile does not exist: " + xmlFile.getAbsolutePath());
            CodecGenerationTool.printUsageAndExit();
        }
        if (!xmlFile.isFile()) {
            System.out.println("xmlFile isn't a file, are the arguments the correct way around?");
            CodecGenerationTool.printUsageAndExit();
        }
        try (FileInputStream input = new FileInputStream(xmlFile);){
            Dictionary dictionary = parser.parse(input, parentDictionary);
            return dictionary;
        }
    }

    private static void printUsageAndExit() {
        System.err.println("Usage: CodecGenerationTool </path/to/output-directory> <[/path/to/fixt-xml/dictionary;]/path/to/xml/dictionary>");
        System.exit(-1);
    }
}

