/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary.generation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.agrona.LangUtil;
import org.agrona.collections.IntHashSet;
import org.agrona.generation.OutputManager;
import uk.co.real_logic.artio.dictionary.CharArrayMap;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.dictionary.generation.ConstantGenerator;
import uk.co.real_logic.artio.dictionary.generation.GenerationUtil;
import uk.co.real_logic.artio.dictionary.ir.Dictionary;
import uk.co.real_logic.artio.dictionary.ir.Field;

public final class EnumGenerator {
    static final String NULL_VAL_NAME = "NULL_VAL";
    public static final String NULL_VAL_CHAR_AS_STRING = Character.toString('\u0001');
    public static final String NULL_VAL_INT_AS_STRING = Integer.toString(Integer.MIN_VALUE);
    public static final String NULL_VAL_STRING = CodecUtil.ENUM_MISSING_STRING;
    static final String UNKNOWN_NAME = "ARTIO_UNKNOWN";
    public static final String UNKNOWN_CHAR_AS_STRING = Character.toString('\u0002');
    public static final String UNKNOWN_INT_AS_STRING = Integer.toString(Integer.MAX_VALUE);
    public static final String UNKNOWN_STRING = CodecUtil.ENUM_UNKNOWN_STRING;
    private final Dictionary dictionary;
    private final String builderPackage;
    private final OutputManager outputManager;

    public EnumGenerator(Dictionary dictionary, String builderPackage, OutputManager outputManager) {
        this.dictionary = dictionary;
        this.builderPackage = builderPackage;
        this.outputManager = outputManager;
    }

    public void generate() {
        this.dictionary.fields().values().stream().filter(EnumGenerator::hasEnumGenerated).forEach(this::generateEnum);
    }

    public static boolean hasEnumGenerated(Field field) {
        return field.isEnum() && field.type() != Field.Type.BOOLEAN;
    }

    private void generateEnum(Field field) {
        String unknownValue;
        String nullValue;
        String enumName = field.name();
        Field.Type type = field.type();
        List<Field.Value> values = field.values();
        if (this.isCharBased(type)) {
            nullValue = NULL_VAL_CHAR_AS_STRING;
            unknownValue = UNKNOWN_CHAR_AS_STRING;
        } else if (type.isIntBased()) {
            nullValue = NULL_VAL_INT_AS_STRING;
            unknownValue = UNKNOWN_INT_AS_STRING;
        } else if (type.isStringBased()) {
            nullValue = NULL_VAL_STRING;
            unknownValue = UNKNOWN_STRING;
        } else {
            System.err.printf("Unable to generate an enum for type: %s. No sentinel defined for %s\n", new Object[]{enumName, type});
            return;
        }
        ArrayList<Field.Value> valuesWithSentinels = new ArrayList<Field.Value>(values);
        valuesWithSentinels.add(new Field.Value(nullValue, NULL_VAL_NAME));
        valuesWithSentinels.add(new Field.Value(unknownValue, UNKNOWN_NAME));
        this.outputManager.withOutput(enumName, out -> {
            try {
                out.append(GenerationUtil.fileHeader(this.builderPackage));
                out.append(GenerationUtil.importFor(CharArrayMap.class));
                out.append(GenerationUtil.importFor(IntHashSet.class));
                out.append(GenerationUtil.importFor(Map.class));
                out.append(GenerationUtil.importFor(HashMap.class));
                out.append(this.generateEnumDeclaration(enumName));
                out.append(this.generateEnumValues(valuesWithSentinels, type));
                out.append(this.generateEnumBody(enumName, type));
                out.append(this.generateEnumLookupMethod(enumName, values, type));
            }
            catch (IOException e) {
                LangUtil.rethrowUnchecked((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                System.err.printf("Unable to generate an enum for type: %s\n", enumName);
                System.err.println(e.getMessage());
            }
            finally {
                out.append("}\n");
            }
        });
    }

    private boolean isCharBased(Field.Type type) {
        return type == Field.Type.CHAR || type == Field.Type.MULTIPLECHARVALUE;
    }

    private String generateEnumDeclaration(String name) {
        return "public enum " + name + "\n{\n";
    }

    private String generateEnumValues(List<Field.Value> allValues, Field.Type type) {
        return allValues.stream().map(value -> String.format("%s%s(%s)", "    ", value.description(), this.literal((Field.Value)value, type))).collect(Collectors.joining(",\n"));
    }

    private String generateEnumBody(String name, Field.Type type) {
        GenerationUtil.Var representation = this.representation(type);
        return ";\n\n" + representation.field() + GenerationUtil.constructor(name, representation) + representation.getter();
    }

    private String generateEnumLookupMethod(String name, List<Field.Value> allValues, Field.Type type) {
        if (this.hasGeneratedValueOf(type)) {
            return "";
        }
        String optionalCharArrayDecode = this.optionalCharArrayDecode(name, allValues, type);
        String enumValidation = this.enumValidation(allValues, type);
        GenerationUtil.Var representation = this.representation(type);
        String cases = allValues.stream().map(value -> String.format("        case %s: return %s;\n", this.literal((Field.Value)value, type), value.description())).collect(Collectors.joining());
        return String.format("%s%s    public static %s decode(%s)\n    {\n        switch(representation)\n        {\n%s        default:\n            return %s;\n        }\n    }\n", optionalCharArrayDecode, enumValidation, name, representation.methodArgsDeclaration(), cases, UNKNOWN_NAME);
    }

    private String enumValidation(List<Field.Value> allValues, Field.Type type) {
        switch (type) {
            case STRING: {
                return "    public static boolean isValid(final char[] representation, final int length)\n    {\n        return charMap.containsKey(representation, length);\n    }\n";
            }
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: {
                return "    public static boolean isValid(final char[] representation, final int length)\n    {\n        int offset = 0;\n        for (int i = 0; i < length; i++)\n        {\n            if (representation[i] == ' ')\n            {\n                if (! charMap.containsKey(representation, offset, i - offset))\n                    return false;\n                offset = i + 1;\n            }\n        }\n        return charMap.containsKey(representation, offset, length - offset);\n    }\n";
            }
            case MULTIPLECHARVALUE: {
                String multiCharValues = allValues.stream().map(Field.Value::representation).map(repr -> String.format("'%1$s'", repr)).map(repr -> String.format("        intSet.add(%1$s);\n", repr)).collect(Collectors.joining());
                return String.format("    private static final IntHashSet intSet = new IntHashSet(%2$s);\n    %1$s\n\n    public static boolean isValid(final char[] representation, final int length)\n    {\n        for (int i = 0; i < length; i+=2)\n        {\n            if (! intSet.contains(representation[i]))\n                return false;\n        }\n        return true;\n    }\n", GenerationUtil.optionalStaticInit(multiCharValues), ConstantGenerator.sizeHashSet(allValues));
            }
        }
        String primitiveValues = allValues.stream().map(value -> this.literal((Field.Value)value, type)).map(repr -> String.format("        intSet.add(%1$s);\n", repr)).collect(Collectors.joining());
        return String.format("    private static final IntHashSet intSet = new IntHashSet(%2$s);\n    %1$s\n\n    public static boolean isValid(final int representation)\n    {\n        return intSet.contains(representation);\n    }\n", GenerationUtil.optionalStaticInit(primitiveValues), ConstantGenerator.sizeHashSet(allValues));
    }

    private String optionalCharArrayDecode(String typeName, List<Field.Value> allValues, Field.Type type) {
        switch (type) {
            case STRING: 
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: {
                String entries = allValues.stream().map(v -> String.format("        stringMap.put(%s, %s);\n", this.literal((Field.Value)v, type), v.description())).collect(Collectors.joining());
                return String.format("    private static final CharArrayMap<%1$s> charMap;\n    static\n    {\n        final Map<String, %1$s> stringMap = new HashMap<>();\n%2$s        charMap = new CharArrayMap<>(stringMap);\n    }\n\n    public static %1$s decode(final char[] representation, final int length)\n    {\n        final %1$s value = charMap.get(representation, length);\n        if (value == null)\n        {\n            return %3$s;\n        }\n        return value;\n    }\n", typeName, entries, UNKNOWN_NAME);
            }
            case MULTIPLECHARVALUE: {
                return String.format("    public static %1$s decode(String representation)\n    {\n        return decode(representation.charAt(0));\n    }\n\n    public static %1$s decode(final char[] representation, final int length)\n    {\n        return decode(representation[0]);\n    }\n", typeName);
            }
        }
        return "";
    }

    private boolean hasGeneratedValueOf(Field.Type type) {
        switch (type) {
            case CURRENCY: 
            case EXCHANGE: 
            case COUNTRY: 
            case LANGUAGE: 
            case UTCTIMEONLY: 
            case UTCDATEONLY: 
            case MONTHYEAR: {
                return true;
            }
        }
        return false;
    }

    private GenerationUtil.Var representation(Field.Type type) {
        String argTypeValue;
        String typeValue;
        switch (type) {
            case STRING: 
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: 
            case CURRENCY: 
            case EXCHANGE: 
            case COUNTRY: 
            case LANGUAGE: 
            case UTCTIMEONLY: 
            case UTCDATEONLY: 
            case MONTHYEAR: {
                typeValue = "String";
                argTypeValue = "String";
                break;
            }
            case MULTIPLECHARVALUE: 
            case CHAR: {
                typeValue = "char";
                argTypeValue = "int";
                break;
            }
            default: {
                typeValue = "int";
                argTypeValue = "int";
            }
        }
        return new GenerationUtil.Var(typeValue, argTypeValue, "representation");
    }

    private String literal(Field.Value value, Field.Type type) {
        String representation = value.representation();
        switch (type) {
            case INT: 
            case LENGTH: 
            case SEQNUM: 
            case NUMINGROUP: 
            case DAYOFMONTH: {
                Integer.parseInt(representation);
                return representation;
            }
            case STRING: 
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: 
            case CURRENCY: 
            case EXCHANGE: 
            case COUNTRY: 
            case LANGUAGE: 
            case UTCTIMEONLY: 
            case UTCDATEONLY: 
            case MONTHYEAR: {
                return '\"' + representation + '\"';
            }
            case MULTIPLECHARVALUE: 
            case CHAR: {
                if (representation.length() > 1) {
                    throw new IllegalArgumentException(representation + " has a length of 2 and thus won't fit into a char");
                }
                return "'" + representation + "'";
            }
        }
        throw new IllegalArgumentException("Unknown type for creating an enum from: " + (Object)((Object)type) + " for value " + value.description());
    }
}

