/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary.ir;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import uk.co.real_logic.artio.dictionary.ir.Entry;

public abstract class Aggregate {
    private final String name;
    private final List<Entry> entries;

    protected Aggregate(String name) {
        this.name = name;
        this.entries = new ArrayList<Entry>();
    }

    public String name() {
        return this.name;
    }

    public List<Entry> entries() {
        return this.entries;
    }

    public Stream<Entry> entriesWith(Predicate<Entry.Element> predicate) {
        return this.entries.stream().filter(entry -> predicate.test(entry.element()));
    }

    public Stream<Entry> allChildEntries() {
        return this.entries.stream().flatMap(entry -> entry.match((ele, field) -> Stream.of(ele), (ele, group) -> Stream.empty(), (ele, component) -> component.allChildEntries()));
    }

    public Aggregate optionalEntry(Entry.Element element) {
        this.entries().add(Entry.optional(element));
        return this;
    }

    public Aggregate requiredEntry(Entry.Element element) {
        this.entries().add(Entry.required(element));
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name='" + this.name + '\'' + ", entries=" + this.entries + '}';
    }

    public boolean hasField(String msgType) {
        return this.entries().stream().anyMatch(e -> msgType.equals(e.element().name()));
    }

    public boolean containsGroup() {
        return this.entries.stream().anyMatch(entry -> entry.match((ele, field) -> false, (ele, group) -> true, (ele, component) -> component.containsGroup()));
    }
}

