/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary.generation;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class CodecUtil {
    public static final byte[] BODY_LENGTH = "9=0000\u0001".getBytes(StandardCharsets.US_ASCII);
    public static final int MISSING_INT = Integer.MIN_VALUE;
    public static final char MISSING_CHAR = '\u0001';
    public static final long MISSING_LONG = Long.MIN_VALUE;
    public static final char ENUM_MISSING_CHAR = '\u0001';
    public static final int ENUM_MISSING_INT = Integer.MIN_VALUE;
    public static final String ENUM_MISSING_STRING = Character.toString('\u0001');
    public static final char ENUM_UNKNOWN_CHAR = '\u0002';
    public static final int ENUM_UNKNOWN_INT = Integer.MAX_VALUE;
    public static final String ENUM_UNKNOWN_STRING = Character.toString('\u0002');

    private CodecUtil() {
    }

    public static byte[] toBytes(CharSequence value, byte[] oldBuffer) {
        int length = value.length();
        byte[] buffer = oldBuffer.length < length ? new byte[length] : oldBuffer;
        for (int i = 0; i < length; ++i) {
            buffer[i] = (byte)value.charAt(i);
        }
        return buffer;
    }

    public static byte[] toBytes(char[] value, byte[] oldBuffer, int length) {
        return CodecUtil.toBytes(value, oldBuffer, 0, length);
    }

    public static byte[] toBytes(char[] value, byte[] oldBuffer, int offset, int length) {
        byte[] buffer = oldBuffer.length < length ? new byte[length] : oldBuffer;
        for (int i = 0; i < length; ++i) {
            buffer[i] = (byte)value[i + offset];
        }
        return buffer;
    }

    public static byte[] toBytes(char[] value, int length) {
        byte[] buffer = new byte[length];
        for (int i = 0; i < length; ++i) {
            buffer[i] = (byte)value[i];
        }
        return buffer;
    }

    public static byte[] subsequenceBytes(byte[] value, byte[] oldBuffer, int offset, int length) {
        if (oldBuffer.length >= length) {
            System.arraycopy(value, offset, oldBuffer, 0, length);
            return oldBuffer;
        }
        return Arrays.copyOfRange(value, offset, offset + length);
    }

    public static boolean equals(char[] value, char[] expected, int offset, int expectedOffset, int length) {
        if (value.length < length || expected.length < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (value[i + offset] == expected[i + expectedOffset]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(char[] value, char[] expected, int length) {
        return CodecUtil.equals(value, expected, 0, 0, length);
    }

    public static int hashCode(char[] value, int offset, int length) {
        int result = 1;
        for (int i = offset; i < offset + length; ++i) {
            result = 31 * result + value[i];
        }
        return result;
    }
}

