/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.fields;

import java.time.Month;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.fields.CalendricalUtil;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public final class MonthYear {
    private static final int SIZE_OF_YEAR = 4;
    private static final int SIZE_OF_MONTH = 2;
    private static final int SIZE_OF_DAY_OF_MONTH = 2;
    private static final int SIZE_OF_WEEK_OF_MONTH = 1;
    public static final int NONE = -1;
    public static final int SHORT_LENGTH = 6;
    public static final int LONG_LENGTH = 8;
    private final UnsafeBuffer buffer = new UnsafeBuffer(0L, 0);
    private final MutableAsciiBuffer flyweight = new MutableAsciiBuffer((DirectBuffer)this.buffer);
    private int year;
    private Month month = Month.JANUARY;
    private int dayOfMonth = -1;
    private int weekOfMonth = -1;

    public static MonthYear of(int year, Month month) {
        return new MonthYear().year(year).month(month);
    }

    public static MonthYear withDayOfMonth(int year, Month month, int dayOfMonth) {
        return MonthYear.of(year, month).dayOfMonth(dayOfMonth);
    }

    public static MonthYear withWeekOfMonth(int year, Month month, int weekOfMonth) {
        return MonthYear.of(year, month).weekOfMonth(weekOfMonth);
    }

    public int year() {
        return this.year;
    }

    public MonthYear year(int year) {
        this.year = year;
        return this;
    }

    public Month month() {
        return this.month;
    }

    public MonthYear month(Month month) {
        this.month = month;
        return this;
    }

    public int dayOfMonth() {
        return this.dayOfMonth;
    }

    public MonthYear dayOfMonth(int dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
        return this;
    }

    public boolean hasDayOfMonth() {
        return this.dayOfMonth() != -1;
    }

    public int weekOfMonth() {
        return this.weekOfMonth;
    }

    public MonthYear weekOfMonth(int weekOfMonth) {
        this.weekOfMonth = weekOfMonth;
        return this;
    }

    public boolean hasWeekOfMonth() {
        return this.weekOfMonth() != -1;
    }

    public boolean decode(byte[] bytes, int length) {
        this.buffer.wrap(bytes);
        return this.decode(this.flyweight, 0, length);
    }

    public boolean decode(AsciiBuffer buffer, int offset, int length) {
        if (length != 6 && length != 8) {
            return false;
        }
        int endYear = offset + 4;
        int endMonth = endYear + 2;
        int year = buffer.getNatural(offset, endYear);
        int month = buffer.getNatural(endYear, endMonth);
        if (!CalendricalUtil.isValidMonth(month)) {
            return false;
        }
        if (length == 8) {
            if (buffer.getChar(endMonth) == 'w') {
                int startWeek = endMonth + 1;
                int endWeek = startWeek + 1;
                int weekOfMonth = buffer.getNatural(startWeek, endWeek);
                if (!CalendricalUtil.isValidDayOfMonth(weekOfMonth)) {
                    return false;
                }
                this.weekOfMonth(weekOfMonth);
            } else {
                int endDay = endMonth + 2;
                int dayOfMonth = buffer.getNatural(endMonth, endDay);
                if (!CalendricalUtil.isValidDayOfMonth(dayOfMonth)) {
                    return false;
                }
                this.dayOfMonth(dayOfMonth);
            }
        }
        this.year(year);
        this.month(Month.of(month));
        return true;
    }

    public int encode(byte[] bytes) {
        this.buffer.wrap(bytes);
        return this.encode(this.flyweight, 0);
    }

    public int encode(MutableAsciiBuffer buffer, int offset) {
        int endYear = offset + 4;
        int endMonth = endYear + 2;
        buffer.putNatural(offset, 4, this.year());
        buffer.putNatural(endYear, 2, this.month().getValue());
        int dayOfMonth = this.dayOfMonth();
        if (dayOfMonth != -1) {
            buffer.putNatural(endMonth, 2, dayOfMonth);
            return 8;
        }
        int weekOfMonth = this.weekOfMonth();
        if (weekOfMonth != -1) {
            buffer.putChar(endMonth, 'w');
            buffer.putNatural(endMonth + 1, 1, weekOfMonth);
            return 8;
        }
        return 6;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonthYear monthYear = (MonthYear)o;
        return this.year == monthYear.year && this.month == monthYear.month && this.dayOfMonth == monthYear.dayOfMonth && this.weekOfMonth == monthYear.weekOfMonth;
    }

    public int hashCode() {
        int result = this.year;
        result = 31 * result + this.month.hashCode();
        result = 31 * result + this.dayOfMonth;
        result = 31 * result + this.weekOfMonth;
        return result;
    }

    public String toString() {
        if (this.hasDayOfMonth()) {
            return String.format("%04d%02d%02d", this.year(), this.month().getValue(), this.dayOfMonth());
        }
        if (this.hasWeekOfMonth()) {
            return String.format("%04d%02dw%d", this.year(), this.month().getValue(), this.weekOfMonth());
        }
        return String.format("%04d%02d", this.year(), this.month().getValue());
    }
}

