/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary.generation;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.agrona.generation.OutputManager;
import org.agrona.generation.ResourceConsumer;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.dictionary.generation.AggregateType;
import uk.co.real_logic.artio.dictionary.generation.EnumGenerator;
import uk.co.real_logic.artio.dictionary.generation.GenerationUtil;
import uk.co.real_logic.artio.dictionary.generation.Generator;
import uk.co.real_logic.artio.dictionary.ir.Aggregate;
import uk.co.real_logic.artio.dictionary.ir.Component;
import uk.co.real_logic.artio.dictionary.ir.Dictionary;
import uk.co.real_logic.artio.dictionary.ir.Entry;
import uk.co.real_logic.artio.dictionary.ir.Field;
import uk.co.real_logic.artio.dictionary.ir.Group;
import uk.co.real_logic.artio.dictionary.ir.Message;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;
import uk.co.real_logic.sbe.generation.java.JavaUtil;

public class EncoderGenerator
extends Generator {
    private static final String SUFFIX = "        buffer.putSeparator(position);\n        position++;\n%s";
    private static final String TRAILER_ENCODE_PREFIX = "    public static final byte[] HEADER_PREFIX_STRING = \"%s\".getBytes(US_ASCII);\n\n    int realStart;\n\n    public int realStart()\n    {\n        return realStart;\n    }\n\n    public int encode(final MutableAsciiBuffer buffer, final int offset, final int bodyStart)\n    {\n        int position = offset;\n\n";
    private static final String GROUP_ENCODE_PREFIX = "    public int encode(final MutableAsciiBuffer buffer, final int offset, final int remainingElements)\n    {\n        if (remainingElements == 0)\n        {\n            return 0;\n        }\n\n        int position = offset;\n\n";
    private static final String MESSAGE_ENCODE_PREFIX = "    public static int MAX_HEADER_PREFIX_LENGTH = %d;\n    public long encode(final MutableAsciiBuffer buffer, final int offset)\n    {\n        int start = offset + MAX_HEADER_PREFIX_LENGTH;\n\n        int position = start;\n\n        position += header.encode(buffer, position);\n";
    private static final String OTHER_ENCODE_PREFIX = "    public int encode(final MutableAsciiBuffer buffer, final int offset)\n    {\n        int position = offset;\n\n";
    private static final String RESET_NEXT_GROUP = "        if (next != null)        {\n            next.reset();\n        }\n";
    private static final int MAX_BODY_LENGTH_FIELD_LENGTH = String.valueOf(Integer.MAX_VALUE).length();
    public static final String METHOD_DELIMITER = "\n\n";
    private final byte[] buffer = new byte[MutableAsciiBuffer.LONGEST_INT_LENGTH + 1];
    private final MutableAsciiBuffer string = new MutableAsciiBuffer(this.buffer);
    private final int initialArraySize;
    private final String headerPrefixString;
    private final int maxHeaderPrefixLength;

    private static String encoderClassName(String name) {
        return JavaUtil.formatClassName((String)(name + "Encoder"));
    }

    public EncoderGenerator(Dictionary dictionary, int initialArraySize, String builderPackage, String builderCommonPackage, OutputManager outputManager, Class<?> validationClass, Class<?> rejectUnknownClass) {
        super(dictionary, builderPackage, builderCommonPackage, outputManager, validationClass, rejectUnknownClass);
        Component header = dictionary.header();
        this.validateHasField(header, "BeginString");
        this.validateHasField(header, "BodyLength");
        this.initialArraySize = initialArraySize;
        this.headerPrefixString = String.format("8=%s.%d.%d\u00019=", dictionary.specType(), dictionary.majorVersion(), dictionary.minorVersion());
        this.maxHeaderPrefixLength = this.headerPrefixString.length() + MAX_BODY_LENGTH_FIELD_LENGTH;
    }

    private void validateHasField(Component header, String fieldName) {
        if (!header.hasField(fieldName)) {
            throw new IllegalArgumentException("Header does not contain needed field : " + fieldName);
        }
    }

    @Override
    protected void generateAggregateFile(Aggregate aggregate, AggregateType aggregateType) {
        String className = EncoderGenerator.encoderClassName(aggregate.name());
        this.outputManager.withOutput(className, out -> {
            out.append(GenerationUtil.fileHeader(this.builderPackage));
            this.generateImports("Encoder", aggregateType, (Writer)out);
            this.generateAggregateClass(aggregate, aggregateType, className, (Writer)out);
        });
    }

    @Override
    protected Class<?> topType(AggregateType aggregateType) {
        return Encoder.class;
    }

    @Override
    protected String resetGroup(Entry entry) {
        Group group = (Group)entry.element();
        String name = group.name();
        Entry numberField = group.numberField();
        return String.format("    public void %1$s()\n    {\n        if (%2$s != null)\n        {\n            %2$s.reset();\n        }\n        %3$s = 0;\n        has%4$s = false;\n    }\n\n", this.nameOfResetMethod(name), JavaUtil.formatPropertyName((String)name), JavaUtil.formatPropertyName((String)numberField.name()), numberField.name());
    }

    private void generateAggregateClass(Aggregate aggregate, AggregateType type, String className, Writer out) throws IOException {
        boolean isMessage = type == AggregateType.MESSAGE;
        List<String> interfaces = isMessage ? Collections.singletonList(Encoder.class.getSimpleName()) : Collections.emptyList();
        out.append(this.classDeclaration(className, interfaces, type == AggregateType.GROUP));
        out.append(this.constructor(aggregate, this.dictionary));
        if (isMessage) {
            out.append(this.commonCompoundImports("Encoder", false, ""));
        } else if (type == AggregateType.GROUP) {
            Group group = (Group)aggregate;
            out.append(this.nextMethod(group));
        }
        this.precomputedHeaders(out, aggregate.entries());
        this.setters(out, className, aggregate.entries());
        out.append(this.encodeMethod(aggregate.entries(), type));
        out.append(this.completeResetMethod(aggregate, isMessage, type));
        out.append(this.toString(aggregate, isMessage));
        out.append("}\n");
    }

    private String completeResetMethod(Aggregate aggregate, boolean isMessage, AggregateType type) {
        String additionalReset = type == AggregateType.GROUP ? RESET_NEXT_GROUP : "";
        return super.completeResetMethod(isMessage, aggregate.entries(), additionalReset);
    }

    private void generateGroupClass(Group group, Writer out) throws IOException {
        String className = EncoderGenerator.encoderClassName(group.name());
        this.generateAggregateClass(group, AggregateType.GROUP, className, out);
    }

    private String nextMethod(Group group) {
        return String.format("    private %1$s next = null;\n\n    public %1$s next()\n    {\n        if (next == null)\n        {\n            next = new %1$s();\n        }\n        return next;\n    }\n\n", EncoderGenerator.encoderClassName(group.name()));
    }

    private String constructor(Aggregate aggregate, Dictionary dictionary) {
        if (aggregate instanceof Message) {
            Component header = dictionary.header();
            Message message = (Message)aggregate;
            int packedType = message.packedType();
            String fullType = message.fullType();
            String msgType = header.hasField("MsgType") ? String.format("        header.msgType(\"%s\");\n", fullType) : "";
            return String.format("    public int messageType()\n    {\n        return %s;\n    }\n\n    public %sEncoder()\n    {\n%s    }\n\n", packedType, message.name(), msgType);
        }
        return "";
    }

    private void setters(Writer out, String className, List<Entry> entries) throws IOException {
        for (Entry entry : entries) {
            this.setter(className, entry, out);
        }
    }

    private void setter(String className, Entry entry, Writer out) throws IOException {
        if (!this.isBodyLength(entry)) {
            entry.forEach((ResourceConsumer<Field>)((ResourceConsumer)field -> out.append(this.fieldSetter(className, (Field)field))), (ResourceConsumer<Group>)((ResourceConsumer)group -> this.generateGroup(className, (Group)group, out)), (ResourceConsumer<Component>)((ResourceConsumer)component -> this.componentField(EncoderGenerator.encoderClassName(entry.name()), (Component)component, out)));
        }
    }

    private String fieldSetter(String className, Field field) {
        String name = field.name();
        String fieldName = JavaUtil.formatPropertyName((String)name);
        String hasField = String.format("    private boolean has%1$s;\n\n", name) + this.hasGetter(name);
        String hasAssign = String.format("        has%s = true;\n", name);
        String enumSetter = EnumGenerator.hasEnumGenerated(field) && !field.type().isMultiValue() ? this.enumSetter(className, fieldName, field.name()) : "";
        Function<String, String> generateSetter = type -> this.setter(name, (String)type, fieldName, hasField, className, hasAssign, enumSetter);
        switch (field.type()) {
            case STRING: 
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: 
            case MULTIPLECHARVALUE: 
            case CURRENCY: 
            case EXCHANGE: 
            case COUNTRY: 
            case LANGUAGE: {
                return this.generateStringSetter(className, fieldName, name, enumSetter);
            }
            case BOOLEAN: {
                return generateSetter.apply("boolean");
            }
            case CHAR: {
                return generateSetter.apply("char");
            }
            case INT: 
            case LENGTH: 
            case SEQNUM: 
            case NUMINGROUP: 
            case DAYOFMONTH: {
                return generateSetter.apply("int");
            }
            case FLOAT: 
            case PRICE: 
            case PRICEOFFSET: 
            case QTY: 
            case PERCENTAGE: 
            case AMT: {
                return this.decimalFloatSetter(fieldName, hasField, className, hasAssign, enumSetter);
            }
            case DATA: 
            case XMLDATA: {
                return generateSetter.apply("byte[]");
            }
            case UTCTIMESTAMP: 
            case LOCALMKTDATE: 
            case UTCDATEONLY: 
            case UTCTIMEONLY: 
            case MONTHYEAR: 
            case TZTIMEONLY: 
            case TZTIMESTAMP: {
                return this.generateByteArraySetter(className, fieldName, name);
            }
        }
        throw new UnsupportedOperationException("Unknown type: " + (Object)((Object)field.type()));
    }

    private void generateGroup(String className, Group group, Writer out) throws IOException {
        this.generateGroupClass(group, out);
        Entry numberField = group.numberField();
        this.setter(className, numberField, out);
        out.append(String.format("\n    private %1$s %2$s = null;\n\n    public %1$s %2$s(final int numberOfElements)\n    {\n        has%3$s = true;\n        %4$s = numberOfElements;\n        if (%2$s == null)\n        {\n            %2$s = new %1$s();\n        }\n        return %2$s;\n    }\n\n", EncoderGenerator.encoderClassName(group.name()), JavaUtil.formatPropertyName((String)group.name()), numberField.name(), JavaUtil.formatPropertyName((String)numberField.name())));
    }

    private String generateByteArraySetter(String className, String fieldName, String name) {
        return String.format("    private byte[] %1$s = new byte[%3$d];\n\n    private int %1$sOffset = 0;\n\n    private int %1$sLength = 0;\n\n    public %2$s %1$s(final byte[] value, final int length)\n    {\n        %1$s = value;\n        %1$sOffset = 0;\n        %1$sLength = length;\n        return this;\n    }\n\n    public %2$s %1$s(final byte[] value, final int offset, final int length)\n    {\n        %1$s = value;\n        %1$sOffset = offset;\n        %1$sLength = length;\n        return this;\n    }\n\n    public %2$s %1$s(final byte[] value)\n    {\n        return %1$s(value, value.length);\n    }\n\n    public boolean has%4$s()\n    {\n        return %1$sLength > 0;\n    }\n\n    public byte[] %1$s()\n    {\n        return %1$s;\n    }\n\n", fieldName, className, this.initialArraySize, name);
    }

    private String generateStringSetter(String className, String fieldName, String name, String enumSetter) {
        return String.format("%2$s    public %3$s %1$s(final CharSequence value)\n    {\n        %1$s = toBytes(value, %1$s);\n        %1$sOffset = 0;\n        %1$sLength = value.length();\n        return this;\n    }\n\n    public %3$s %1$s(final char[] value)\n    {\n        return %1$s(value, value.length);\n    }\n\n    public %3$s %1$s(final char[] value, final int length)\n    {\n        %1$s = toBytes(value, %1$s, length);\n        %1$sOffset = 0;\n        %1$sLength = length;\n        return this;\n    }\n\n    public %3$s %1$s(final char[] value, final int offset, final int length)\n    {\n        %1$s = toBytes(value, %1$s, offset, length);\n        %1$sOffset = 0;\n        %1$sLength = length;\n        return this;\n    }\n\n%4$s", fieldName, this.generateByteArraySetter(className, fieldName, name), className, enumSetter);
    }

    private String setter(String name, String type, String fieldName, String optionalField, String className, String optionalAssign, String enumSetter) {
        return String.format("    %s %s %s;\n\n%s    public %s %3$s(%2$s value)\n    {\n        %3$s = value;\n%s        return this;\n    }\n\n    public %2$s %3$s()\n    {\n        return %3$s;\n    }\n\n%7$s", this.isBodyLength(name) ? "public" : "private", type, fieldName, optionalField, className, optionalAssign, enumSetter);
    }

    private String decimalFloatSetter(String fieldName, String optionalField, String className, String optionalAssign, String enumSetter) {
        return String.format("    private DecimalFloat %1$s = new DecimalFloat();\n\n%2$s    public %3$s %1$s(DecimalFloat value)\n    {\n        %1$s = value;\n%4$s        return this;\n    }\n\n    public %3$s %1$s(long value, int scale)\n    {\n        %1$s.set(value, scale);\n%4$s        return this;\n    }\n\n    public DecimalFloat %1$s()\n    {\n        return %1$s;\n    }\n\n%5$s", fieldName, optionalField, className, optionalAssign, enumSetter);
    }

    private String enumSetter(String className, String fieldName, String enumType) {
        return String.format("    public %s %2$s(%3$s value)\n    {\n        return %2$s(value.representation());\n    }\n\n", className, fieldName, enumType);
    }

    private String encodeMethod(List<Entry> entries, AggregateType aggregateType) {
        String suffix;
        String prefix;
        boolean hasCommonCompounds = aggregateType == AggregateType.MESSAGE;
        switch (aggregateType) {
            case TRAILER: {
                prefix = String.format(TRAILER_ENCODE_PREFIX, this.headerPrefixString);
                break;
            }
            case GROUP: {
                prefix = GROUP_ENCODE_PREFIX;
                break;
            }
            case MESSAGE: {
                prefix = String.format(MESSAGE_ENCODE_PREFIX, this.maxHeaderPrefixLength);
                break;
            }
            default: {
                prefix = OTHER_ENCODE_PREFIX;
            }
        }
        String body = entries.stream().map(this::encodeEntry).collect(Collectors.joining("\n"));
        if (hasCommonCompounds) {
            suffix = "        position += trailer.encode(buffer, position, start);\n        final int realStart = trailer.realStart;        return Encoder.result(position - realStart, realStart);\n    }\n\n";
        } else {
            suffix = "        return position - offset;\n    }\n\n";
            if (aggregateType == AggregateType.GROUP) {
                suffix = "        if (next != null)\n        {\n            position += next.encode(buffer, position, remainingElements - 1);\n        }\n" + suffix;
            }
        }
        return prefix + body + suffix;
    }

    private String encodeEntry(Entry entry) {
        if (this.isBodyLength(entry) || this.isBeginString(entry)) {
            return "";
        }
        if (this.isCheckSum(entry)) {
            return this.encodeChecksum();
        }
        return entry.matchEntry(this::encodeField, this::encodeGroup, this::encodeComponent);
    }

    private String encodeChecksum() {
        return "        final int bodyLength = position - bodyStart;\n        buffer.putSeparator(bodyStart - 1);\n        final int bodyLengthStart = buffer.putNaturalFromEnd(bodyLength, bodyStart - 1);\n        final int realStart = bodyLengthStart - HEADER_PREFIX_STRING.length;\n        this.realStart = realStart;        buffer.putBytes(realStart, HEADER_PREFIX_STRING);\n" + this.formatTag("checkSum", "") + "        final int checkSum = buffer.computeChecksum(realStart, position - 3);\n        buffer.putNatural(position, 3, checkSum);\n        position += 3;\n        buffer.putSeparator(position);\n        position++;\n";
    }

    private String encodeField(Entry entry) {
        String enablingSuffix;
        boolean needsMissingThrow;
        Entry.Element element = entry.element();
        Field field = (Field)element;
        String name = field.name();
        String fieldName = JavaUtil.formatPropertyName((String)name);
        Field.Type type = field.type();
        boolean mustCheckFlag = this.hasFlag(entry, field);
        boolean mustCheckLength = type.hasLengthField();
        boolean bl = needsMissingThrow = (mustCheckFlag || mustCheckLength) && entry.required() && !"MsgSeqNum".equals(name);
        String enablingPrefix = mustCheckFlag ? String.format("        if (has%s) {\n", name) : (mustCheckLength ? String.format("        if (%sLength > 0) {\n", fieldName) : "");
        String string = enablingSuffix = mustCheckFlag || mustCheckLength ? "        }\n" : "";
        if (needsMissingThrow) {
            enablingSuffix = enablingSuffix + "        else if (" + "CODEC_VALIDATION_ENABLED" + ")\n        {\n            throw new EncodingException(\"Missing Field: " + name + "\");\n        }\n";
        }
        String tag = this.formatTag(fieldName, enablingPrefix);
        switch (type) {
            case INT: 
            case LENGTH: 
            case SEQNUM: 
            case NUMINGROUP: 
            case DAYOFMONTH: {
                return this.putValue(fieldName, tag, "Int", enablingSuffix);
            }
            case FLOAT: 
            case PRICE: 
            case PRICEOFFSET: 
            case QTY: 
            case PERCENTAGE: 
            case AMT: {
                return this.putValue(fieldName, tag, "Float", enablingSuffix);
            }
            case CHAR: {
                return this.putValue(fieldName, tag, "Char", enablingSuffix);
            }
            case BOOLEAN: {
                return this.putValue(fieldName, tag, "Boolean", enablingSuffix);
            }
            case STRING: 
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: 
            case MULTIPLECHARVALUE: 
            case CURRENCY: 
            case EXCHANGE: 
            case COUNTRY: 
            case LANGUAGE: 
            case UTCTIMESTAMP: 
            case LOCALMKTDATE: 
            case UTCDATEONLY: 
            case UTCTIMEONLY: 
            case MONTHYEAR: 
            case TZTIMEONLY: 
            case TZTIMESTAMP: {
                return this.stringPut(fieldName, enablingSuffix, tag);
            }
            case DATA: 
            case XMLDATA: {
                return String.format("%s        buffer.putBytes(position, %s);\n        position += %2$s.length;\n        buffer.putSeparator(position);\n        position++;\n%s", tag, fieldName, enablingSuffix);
            }
        }
        throw new UnsupportedOperationException("Unknown type: " + (Object)((Object)type));
    }

    private String stringPut(String fieldName, String optionalSuffix, String tag) {
        return this.formatEncoder(fieldName, optionalSuffix, tag, "        buffer.putBytes(position, %s, %2$sOffset, %2$sLength);\n        position += %2$sLength;\n");
    }

    private String formatEncoder(String fieldName, String optionalSuffix, String tag, String format) {
        return String.format("%s" + format + SUFFIX, tag, fieldName, optionalSuffix);
    }

    private String encodeGroup(Entry entry) {
        Group group = (Group)entry.element();
        return String.format("%1$s\n        if (%2$s != null)\n        {\n            position += %2$s.encode(buffer, position, %3$s);\n        }\n", this.encodeField(group.numberField()), JavaUtil.formatPropertyName((String)group.name()), JavaUtil.formatPropertyName((String)group.numberField().name()));
    }

    private String encodeComponent(Entry entry) {
        return String.format("            position += %1$s.encode(buffer, position);\n", JavaUtil.formatPropertyName((String)entry.name()));
    }

    private String formatTag(String fieldName, String optionalPrefix) {
        return String.format("%s        buffer.putBytes(position, %sHeader, 0, %2$sHeaderLength);\n        position += %2$sHeaderLength;\n", optionalPrefix, fieldName);
    }

    private String putValue(String fieldName, String tag, String type, String optionalSuffix) {
        return String.format("%s        position += buffer.putAscii%s(position, %s);\n        buffer.putSeparator(position);\n        position++;\n%s", tag, type, fieldName, optionalSuffix);
    }

    private void precomputedHeaders(Writer out, List<Entry> entries) throws IOException {
        for (Entry entry : entries) {
            if (this.isBodyLength(entry)) continue;
            Entry.Element element = entry.element();
            if (element instanceof Field) {
                this.precomputedFieldHeader(out, (Field)element);
                continue;
            }
            if (!(element instanceof Group)) continue;
            Group group = (Group)element;
            this.precomputedFieldHeader(out, (Field)group.numberField().element());
        }
    }

    private void precomputedFieldHeader(Writer out, Field field) throws IOException {
        String name = field.name();
        String fieldName = JavaUtil.formatPropertyName((String)name);
        int length = this.string.putAsciiInt(0, field.number());
        String bytes = IntStream.range(0, length).mapToObj(i -> String.valueOf(this.buffer[i])).collect(Collectors.joining(", ", "", ", (byte) '='"));
        out.append(String.format("    private static final int %sHeaderLength = %d;\n    private static final byte[] %1$sHeader = new byte[] {%s};\n\n", fieldName, length + 1, bytes));
    }

    @Override
    protected String stringToString(String fieldName) {
        return String.format("new String(%s, %1$sOffset, %1$sLength, StandardCharsets.US_ASCII)", fieldName);
    }

    @Override
    protected String componentToString(Component component) {
        String name = component.name();
        return String.format("                String.format(\"  \\\"%1$s\\\":  %%s\\n\", %2$s.toString().replace(\"\\n\", \"\\n  \"))", name, JavaUtil.formatPropertyName((String)name));
    }

    private void componentField(String className, Component element, Writer out) throws IOException {
        out.append(String.format("    private final %1$s %2$s = new %1$s();\n    public %1$s %2$s()\n    {\n        return %2$s;\n    }\n\n", className, JavaUtil.formatPropertyName((String)element.name())));
    }

    @Override
    protected String resetRequiredFloat(String name) {
        return this.resetByFlag(name);
    }

    @Override
    protected String resetRequiredInt(Field field) {
        return this.resetByFlag(field.name());
    }

    @Override
    protected String toStringGroupParameters() {
        return "final int remainingEntries";
    }

    @Override
    protected String toStringGroupSuffix() {
        return "        if (remainingEntries > 1)\n        {\n            entries += \",\\n\" + next.toString(remainingEntries - 1);\n        }\n";
    }

    @Override
    protected boolean hasFlag(Entry entry, Field field) {
        Field.Type type = field.type();
        return !entry.required() && !type.hasLengthField() || type.isFloatBased() || type.isIntBased();
    }

    @Override
    protected String resetTemporalValue(String name) {
        return this.resetLength(name);
    }

    @Override
    protected String resetComponents(List<Entry> entries, StringBuilder methods) {
        return entries.stream().filter(Entry::isComponent).map(this::callComponentReset).collect(Collectors.joining());
    }

    @Override
    protected String resetStringBasedData(String name) {
        return this.resetLength(name);
    }

    @Override
    protected String groupEntryToString(Group element, String name) {
        Entry numberField = element.numberField();
        return String.format("                (%3$s > 0 ? String.format(\"  \\\"%1$s\\\": [\\n  %%s\\n  ]\\n\", %2$s.toString(%3$s).replace(\"\\n\", \"\\n  \")) : \"\")", name, JavaUtil.formatPropertyName((String)name), JavaUtil.formatPropertyName((String)numberField.name()));
    }

    @Override
    protected String optionalReset(Field field, String name) {
        return field.type().hasLengthField() ? this.resetLength(name) : this.resetByFlag(name);
    }

    @Override
    protected boolean toStringChecksHasGetter(Entry entry, Field field) {
        return this.hasFlag(entry, field) || field.type().hasLengthField();
    }
}

