/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.fields;

import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.fields.DecimalFloat;
import uk.co.real_logic.artio.util.PowerOf10;

public class ReadOnlyDecimalFloat
implements Comparable<ReadOnlyDecimalFloat> {
    private static final int SCALE_NAN_VALUE = -128;
    private static final long VALUE_NAN_VALUE = Long.MIN_VALUE;
    private static final double DOUBLE_NAN_VALUE = Double.NaN;
    public static final long VALUE_MAX_VAL = 999999999999999999L;
    private static final long VALUE_MIN_VAL = -999999999999999999L;
    private static final int SCALE_MAX_VAL = 127;
    private static final int SCALE_MIN_VAL = 0;
    public static final ReadOnlyDecimalFloat MIN_VALUE = new ReadOnlyDecimalFloat(-999999999999999999L, 0);
    public static final ReadOnlyDecimalFloat MAX_VALUE = new ReadOnlyDecimalFloat(999999999999999999L, 0);
    public static final ReadOnlyDecimalFloat ZERO = new ReadOnlyDecimalFloat(0L, 0);
    public static final ReadOnlyDecimalFloat NAN;
    public static final ReadOnlyDecimalFloat MISSING_FLOAT;
    protected long value;
    protected int scale;

    private ReadOnlyDecimalFloat() {
    }

    ReadOnlyDecimalFloat(long value, int scale) {
        this.setAndNormalise(value, scale);
    }

    public DecimalFloat mutableCopy() {
        DecimalFloat mutableCopy = new DecimalFloat();
        mutableCopy.value = this.value;
        mutableCopy.scale = this.scale;
        return mutableCopy;
    }

    public boolean isNaNValue() {
        return ReadOnlyDecimalFloat.isNaNValue(this.value, this.scale);
    }

    public double toDouble() {
        if (this.isNaNValue()) {
            return Double.NaN;
        }
        return ReadOnlyDecimalFloat.toDouble(this.value, this.scale);
    }

    public static boolean isNaNValue(long value, int scale) {
        return value == Long.MIN_VALUE && scale == -128;
    }

    public long value() {
        return this.value;
    }

    public int scale() {
        return this.scale;
    }

    public void appendTo(StringBuilder builder) {
        CodecUtil.appendFloat(builder, this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.appendTo(builder);
        return builder.toString();
    }

    @Override
    public final int compareTo(ReadOnlyDecimalFloat other) {
        long otherDecimalPointDivisor;
        long otherValueBeforeDecimalPoint;
        long value = this.value;
        int scale = this.scale;
        long otherValue = other.value;
        int otherScale = other.scale;
        long decimalPointDivisor = PowerOf10.pow10(scale);
        long valueBeforeDecimalPoint = value / decimalPointDivisor;
        int beforeDecimalPointComparison = Long.compare(valueBeforeDecimalPoint, otherValueBeforeDecimalPoint = otherValue / (otherDecimalPointDivisor = PowerOf10.pow10(otherScale)));
        if (beforeDecimalPointComparison != 0) {
            return beforeDecimalPointComparison;
        }
        long valueAfterDecimalPoint = value % decimalPointDivisor;
        long otherValueAfterDecimalPoint = otherValue % otherDecimalPointDivisor;
        if (scale > otherScale) {
            int differenceInScale = scale - otherScale;
            otherValueAfterDecimalPoint *= PowerOf10.pow10(differenceInScale);
        } else {
            int differenceInScale = otherScale - scale;
            valueAfterDecimalPoint *= PowerOf10.pow10(differenceInScale);
        }
        return Long.compare(valueAfterDecimalPoint, otherValueAfterDecimalPoint);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ReadOnlyDecimalFloat.class != o.getClass() && DecimalFloat.class != o.getClass()) {
            return false;
        }
        ReadOnlyDecimalFloat that = (ReadOnlyDecimalFloat)o;
        return this.scale == that.scale && this.value == that.value;
    }

    public final int hashCode() {
        int result = (int)(this.value ^ this.value >>> 32);
        return 31 * result + this.scale;
    }

    protected final void setAndNormalise(long value, int scale) {
        this.value = value;
        this.scale = scale;
        this.normalise();
    }

    private void normalise() {
        int scale;
        long value = this.value;
        if (value == 0L) {
            scale = 0;
        } else if (0 < scale) {
            for (scale = this.scale; value % 10L == 0L && 0 < scale; --scale) {
                value /= 10L;
            }
        } else if (scale < 0) {
            while (!ReadOnlyDecimalFloat.isOutsideLimits(value, -999999999999999999L, 999999999999999999L) && scale < 0) {
                value *= 10L;
                ++scale;
            }
        }
        if (ReadOnlyDecimalFloat.isOutsideLimits(scale, 0L, 127L) || ReadOnlyDecimalFloat.isOutsideLimits(value, -999999999999999999L, 999999999999999999L)) {
            throw new ArithmeticException("Out of range: value: " + this.value + ", scale: " + this.scale);
        }
        this.value = value;
        this.scale = scale;
    }

    private static ReadOnlyDecimalFloat newReadOnlyNanValue() {
        ReadOnlyDecimalFloat nanFloat = new ReadOnlyDecimalFloat();
        nanFloat.value = Long.MIN_VALUE;
        nanFloat.scale = -128;
        return nanFloat;
    }

    private static boolean isOutsideLimits(long value, long lowerBound, long upperBound) {
        return value < lowerBound || upperBound < value;
    }

    private static double toDouble(long value, int scale) {
        int remainingPowersOfTen;
        double divisor = 1.0;
        for (remainingPowersOfTen = scale; remainingPowersOfTen >= 18; remainingPowersOfTen -= 18) {
            divisor *= (double)PowerOf10.POWERS_OF_TEN[18];
        }
        return (double)value / (divisor *= (double)PowerOf10.POWERS_OF_TEN[remainingPowersOfTen]);
    }

    static {
        MISSING_FLOAT = NAN = ReadOnlyDecimalFloat.newReadOnlyNanValue();
    }
}

