/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.storage.messages;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import uk.co.real_logic.artio.storage.messages.FixPContextWrapperDecoder;
import uk.co.real_logic.artio.storage.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.storage.messages.MetaAttribute;

public final class FixPContextWrapperEncoder {
    public static final int BLOCK_LENGTH = 4;
    public static final int TEMPLATE_ID = 32;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 11;
    public static final String SEMANTIC_VERSION = "0.1";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final FixPContextWrapperEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 4;
    }

    public int sbeTemplateId() {
        return 32;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 11;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public FixPContextWrapperEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 4);
        return this;
    }

    public FixPContextWrapperEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(4).templateId(32).schemaId(666).version(11);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int protocolTypeId() {
        return 1;
    }

    public static int protocolTypeSinceVersion() {
        return 0;
    }

    public static int protocolTypeEncodingOffset() {
        return 0;
    }

    public static int protocolTypeEncodingLength() {
        return 2;
    }

    public static String protocolTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int protocolTypeNullValue() {
        return 65535;
    }

    public static int protocolTypeMinValue() {
        return 0;
    }

    public static int protocolTypeMaxValue() {
        return 65534;
    }

    public FixPContextWrapperEncoder protocolType(int value) {
        this.buffer.putShort(this.offset + 0, (short)value, BYTE_ORDER);
        return this;
    }

    public static int contextLengthId() {
        return 2;
    }

    public static int contextLengthSinceVersion() {
        return 0;
    }

    public static int contextLengthEncodingOffset() {
        return 2;
    }

    public static int contextLengthEncodingLength() {
        return 2;
    }

    public static String contextLengthMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int contextLengthNullValue() {
        return 65535;
    }

    public static int contextLengthMinValue() {
        return 0;
    }

    public static int contextLengthMaxValue() {
        return 65534;
    }

    public FixPContextWrapperEncoder contextLength(int value) {
        this.buffer.putShort(this.offset + 2, (short)value, BYTE_ORDER);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        FixPContextWrapperDecoder decoder = new FixPContextWrapperDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset, 4, 11);
        return decoder.appendTo(builder);
    }
}

