/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.storage.messages;

import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import uk.co.real_logic.artio.storage.messages.EngineInformationDecoder;
import uk.co.real_logic.artio.storage.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.storage.messages.MetaAttribute;

public final class EngineInformationEncoder {
    public static final int BLOCK_LENGTH = 8;
    public static final int TEMPLATE_ID = 31;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 11;
    public static final String SEMANTIC_VERSION = "0.1";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final EngineInformationEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 8;
    }

    public int sbeTemplateId() {
        return 31;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 11;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public EngineInformationEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 8);
        return this;
    }

    public EngineInformationEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(8).templateId(31).schemaId(666).version(11);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int heartbeatTimeInMsId() {
        return 1;
    }

    public static int heartbeatTimeInMsSinceVersion() {
        return 0;
    }

    public static int heartbeatTimeInMsEncodingOffset() {
        return 0;
    }

    public static int heartbeatTimeInMsEncodingLength() {
        return 8;
    }

    public static String heartbeatTimeInMsMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long heartbeatTimeInMsNullValue() {
        return Long.MIN_VALUE;
    }

    public static long heartbeatTimeInMsMinValue() {
        return -9223372036854775807L;
    }

    public static long heartbeatTimeInMsMaxValue() {
        return Long.MAX_VALUE;
    }

    public EngineInformationEncoder heartbeatTimeInMs(long value) {
        this.buffer.putLong(this.offset + 0, value, BYTE_ORDER);
        return this;
    }

    public static int runtimeNameId() {
        return 2;
    }

    public static String runtimeNameCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String runtimeNameMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int runtimeNameHeaderLength() {
        return 2;
    }

    public EngineInformationEncoder putRuntimeName(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public EngineInformationEncoder putRuntimeName(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public EngineInformationEncoder runtimeName(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, BYTE_ORDER);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        EngineInformationDecoder decoder = new EngineInformationDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset, 8, 11);
        return decoder.appendTo(builder);
    }
}

