/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.builder;

import uk.co.real_logic.artio.fields.DecimalFloat;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.float_parsing.DecimalFloatOverflowHandler;

public abstract class CommonDecoderImpl {
    public static final int INCORRECT_DATA_FORMAT_FOR_VALUE = 6;
    protected int invalidTagId = -1;
    protected int rejectReason = -1;
    protected AsciiBuffer buffer;
    protected DecimalFloatOverflowHandler decimalFloatOverflowHandler;

    public int invalidTagId() {
        return this.invalidTagId;
    }

    public int rejectReason() {
        return this.rejectReason;
    }

    public int getInt(AsciiBuffer buffer, int startInclusive, int endExclusive, int tag, boolean validation) {
        try {
            return buffer.getInt(startInclusive, endExclusive);
        }
        catch (NumberFormatException e) {
            if (validation) {
                this.invalidTagId = tag;
                this.rejectReason = 6;
            }
            return Integer.MIN_VALUE;
        }
    }

    public long getLong(AsciiBuffer buffer, int startInclusive, int endExclusive, int tag, boolean validation) {
        try {
            return buffer.parseLongAscii(startInclusive, endExclusive - startInclusive);
        }
        catch (NumberFormatException e) {
            if (validation) {
                this.invalidTagId = tag;
                this.rejectReason = 6;
            }
            return Long.MIN_VALUE;
        }
    }

    public DecimalFloat getFloat(AsciiBuffer buffer, DecimalFloat number, int offset, int length, int tag, boolean validation, DecimalFloatOverflowHandler decimalFloatOverflowHandler) {
        try {
            return buffer.getFloat(number, offset, length, tag, decimalFloatOverflowHandler);
        }
        catch (ArithmeticException | NumberFormatException e) {
            if (validation) {
                this.invalidTagId = tag;
                this.rejectReason = 6;
                return number;
            }
            number.set(DecimalFloat.MISSING_FLOAT);
            return number;
        }
    }

    public DecimalFloat getFloat(AsciiBuffer buffer, DecimalFloat number, int offset, int length, int tag, boolean validation) {
        return this.getFloat(buffer, number, offset, length, tag, validation, null);
    }

    public int getIntFlyweight(AsciiBuffer buffer, int offset, int length, int tag, boolean validation) {
        try {
            return buffer.parseIntAscii(offset, length);
        }
        catch (NumberFormatException e) {
            if (validation) {
                throw new NumberFormatException(e.getMessage() + " tag=" + tag);
            }
            return Integer.MIN_VALUE;
        }
    }

    public long getLongFlyweight(AsciiBuffer buffer, int offset, int length, int tag, boolean validation) {
        try {
            return buffer.parseLongAscii(offset, length);
        }
        catch (NumberFormatException e) {
            if (validation) {
                throw new NumberFormatException(e.getMessage() + " tag=" + tag);
            }
            return Long.MIN_VALUE;
        }
    }

    public int groupNoField(AsciiBuffer buffer, int oldValue, boolean hasField, int offset, int length, int tag, boolean validation) {
        if (!hasField || buffer == null) {
            return 0;
        }
        if (oldValue != Integer.MIN_VALUE) {
            return oldValue;
        }
        return this.getIntFlyweight(buffer, offset, length, tag, validation);
    }

    public DecimalFloat getFloatFlyweight(AsciiBuffer buffer, DecimalFloat number, int offset, int length, int tag, boolean codecValidationEnabled, DecimalFloatOverflowHandler decimalFloatOverflowHandler) {
        try {
            return buffer.getFloat(number, offset, length, tag, decimalFloatOverflowHandler);
        }
        catch (NumberFormatException e) {
            if (codecValidationEnabled) {
                throw new NumberFormatException(e.getMessage() + " tag=" + tag);
            }
            number.set(DecimalFloat.MISSING_FLOAT);
            return number;
        }
    }

    public DecimalFloat getFloatFlyweight(AsciiBuffer buffer, DecimalFloat number, int offset, int length, int tag, boolean codecValidationEnabled) {
        return this.getFloatFlyweight(buffer, number, offset, length, tag, codecValidationEnabled, null);
    }
}

