/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.util.float_parsing;

import uk.co.real_logic.artio.fields.DecimalFloat;
import uk.co.real_logic.artio.util.PowerOf10;
import uk.co.real_logic.artio.util.float_parsing.CharReader;

public final class DecimalFloatParser {
    private static final char LOWER_CASE_E = 'e';
    private static final char UPPER_CASE_E = 'E';
    private static final char PLUS = '+';
    private static final char MINUS = '-';
    private static final byte DOT = 46;

    public static <Data> DecimalFloat extract(DecimalFloat number, CharReader<Data> charReader, Data data, int offset, int length) {
        boolean negative;
        int index;
        int workingOffset = offset;
        int end = workingOffset + length;
        for (int index2 = end - 1; charReader.isSpace(data, index2) && index2 > workingOffset; --index2) {
            --end;
        }
        int endOfSignificand = DecimalFloatParser.findEndOfSignificand(charReader, workingOffset, end, data);
        int startOfExponent = endOfSignificand + 1;
        if (DecimalFloatParser.isFloatingPoint(charReader, workingOffset, endOfSignificand, data)) {
            for (index = endOfSignificand - 1; charReader.isZero(data, index) && index > workingOffset; --index) {
                --endOfSignificand;
            }
        }
        for (index = workingOffset; index < endOfSignificand && charReader.isSpace(data, index); ++index) {
            ++workingOffset;
        }
        boolean bl = negative = charReader.charAt(data, workingOffset) == '-';
        if (negative) {
            ++workingOffset;
        }
        for (int index3 = workingOffset; index3 < endOfSignificand && charReader.isZero(data, index3); ++index3) {
            ++workingOffset;
        }
        int workingScale = 0;
        long value = 0L;
        for (int index4 = workingOffset; index4 < endOfSignificand; ++index4) {
            char charValue = charReader.charAt(data, index4);
            if (charValue == '.') {
                workingScale = endOfSignificand - (index4 + 1);
                continue;
            }
            int digit = charReader.getDigit(data, index4, charValue);
            if ((value = value * 10L + (long)digit) >= 0L) continue;
            throw new ArithmeticException("Out of range: when parsing " + String.valueOf(charReader.asString(data, offset, length)));
        }
        int exponent = 0;
        int exponentLength = end - startOfExponent;
        if (exponentLength > 0) {
            exponent = DecimalFloatParser.parseExponent(charReader, data, offset, length, startOfExponent, end);
        } else if (exponentLength == 0) {
            throw new NumberFormatException(charReader.asString(data, offset, length).toString());
        }
        int scale = workingScale - exponent;
        long signedValue = negative ? -1L * value : value;
        return number.set(scale >= 0 ? signedValue : signedValue * PowerOf10.pow10(-scale), Math.max(scale, 0));
    }

    private static <Data> int parseExponent(CharReader<Data> charReader, Data data, int offset, int length, int startOfExponent, int end) {
        int exponent = 0;
        boolean negative = false;
        int position = startOfExponent;
        char firstChar = charReader.charAt(data, position);
        if (firstChar == '-') {
            ++position;
            negative = true;
        } else if (firstChar == '+') {
            ++position;
        }
        while (position < end) {
            char charValue = charReader.charAt(data, position);
            int digit = charReader.getDigit(data, position, charValue);
            ++position;
            if ((exponent = exponent * 10 + digit) <= 1000) continue;
            throw new NumberFormatException(charReader.asString(data, offset, length).toString());
        }
        return negative ? -exponent : exponent;
    }

    private static <Data> int findEndOfSignificand(CharReader<Data> dataExtractor, int offset, int end, Data data) {
        for (int index = end - 1; index > offset; --index) {
            char charValue = dataExtractor.charAt(data, index);
            if (charValue != 'e' && charValue != 'E') continue;
            return index;
        }
        return end;
    }

    private static <Data> boolean isFloatingPoint(CharReader<Data> dataExtractor, int offset, int end, Data data) {
        for (int index = end - 1; index >= offset; --index) {
            if (dataExtractor.charAt(data, index) != '.') continue;
            return true;
        }
        return false;
    }
}

