/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary.generation;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.agrona.AsciiNumberFormatException;
import org.agrona.LangUtil;
import org.agrona.generation.OutputManager;
import org.agrona.generation.ResourceConsumer;
import uk.co.real_logic.artio.builder.CommonDecoderImpl;
import uk.co.real_logic.artio.builder.Decoder;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.decoder.SessionHeaderDecoder;
import uk.co.real_logic.artio.dictionary.Generated;
import uk.co.real_logic.artio.dictionary.generation.AggregateType;
import uk.co.real_logic.artio.dictionary.generation.ConstantGenerator;
import uk.co.real_logic.artio.dictionary.generation.EncoderGenerator;
import uk.co.real_logic.artio.dictionary.generation.EnumGenerator;
import uk.co.real_logic.artio.dictionary.generation.GenerationUtil;
import uk.co.real_logic.artio.dictionary.generation.Generator;
import uk.co.real_logic.artio.dictionary.generation.OptionalSessionFields;
import uk.co.real_logic.artio.dictionary.ir.Aggregate;
import uk.co.real_logic.artio.dictionary.ir.AnyFields;
import uk.co.real_logic.artio.dictionary.ir.Component;
import uk.co.real_logic.artio.dictionary.ir.Dictionary;
import uk.co.real_logic.artio.dictionary.ir.Entry;
import uk.co.real_logic.artio.dictionary.ir.Field;
import uk.co.real_logic.artio.dictionary.ir.Group;
import uk.co.real_logic.artio.dictionary.ir.Message;
import uk.co.real_logic.artio.fields.RejectReason;
import uk.co.real_logic.artio.util.MessageTypeEncoding;
import uk.co.real_logic.sbe.generation.java.JavaUtil;

class DecoderGenerator
extends Generator {
    private static final Set<String> REQUIRED_SESSION_CODECS = new HashSet<String>(Arrays.asList("LogonDecoder", "LogoutDecoder", "RejectDecoder", "TestRequestDecoder", "SequenceResetDecoder", "HeartbeatDecoder", "ResendRequestDecoder", "UserRequestDecoder"));
    public static final String REQUIRED_FIELDS = "REQUIRED_FIELDS";
    private static final String GROUP_FIELDS = "GROUP_FIELDS";
    private static final String ALL_GROUP_FIELDS = "ALL_GROUP_FIELDS";
    private static final String MESSAGE_DECODER = GenerationUtil.importFor(Decoder.class) + GenerationUtil.importFor(Generated.class) + "\n@Generated(\"uk.co.real_logic.artio\")\npublic interface MessageDecoder extends Decoder\n{\n    HeaderDecoder header();\n\n    TrailerDecoder trailer();\n}";
    public static final int INCORRECT_NUMINGROUP_COUNT_FOR_REPEATING_GROUP = RejectReason.INCORRECT_NUMINGROUP_COUNT_FOR_REPEATING_GROUP.representation();
    public static final int INVALID_TAG_NUMBER = RejectReason.INVALID_TAG_NUMBER.representation();
    public static final int REQUIRED_TAG_MISSING = RejectReason.REQUIRED_TAG_MISSING.representation();
    public static final int TAG_NOT_DEFINED_FOR_THIS_MESSAGE_TYPE = RejectReason.TAG_NOT_DEFINED_FOR_THIS_MESSAGE_TYPE.representation();
    public static final int TAG_SPECIFIED_WITHOUT_A_VALUE = RejectReason.TAG_SPECIFIED_WITHOUT_A_VALUE.representation();
    public static final int VALUE_IS_INCORRECT = RejectReason.VALUE_IS_INCORRECT.representation();
    public static final int TAG_APPEARS_MORE_THAN_ONCE = RejectReason.TAG_APPEARS_MORE_THAN_ONCE.representation();
    public static final int TAG_SPECIFIED_OUT_OF_REQUIRED_ORDER = 14;
    private final int initialBufferSize;
    private final String encoderPackage;
    private final boolean wrapEmptyBuffer;

    static String decoderClassName(Aggregate aggregate) {
        return DecoderGenerator.decoderClassName(aggregate.name());
    }

    static String decoderClassName(String name) {
        return name + "Decoder";
    }

    DecoderGenerator(Dictionary dictionary, int initialBufferSize, String thisPackage, String commonPackage, String encoderPackage, OutputManager outputManager, Class<?> validationClass, Class<?> rejectUnknownFieldClass, Class<?> rejectUnknownEnumValueClass, boolean flyweightsEnabled, boolean wrapEmptyBuffer, String codecRejectUnknownEnumValueEnabled, boolean fixTagsInJavadoc) {
        super(dictionary, thisPackage, commonPackage, outputManager, validationClass, rejectUnknownFieldClass, rejectUnknownEnumValueClass, flyweightsEnabled, codecRejectUnknownEnumValueEnabled, fixTagsInJavadoc);
        this.initialBufferSize = initialBufferSize;
        this.encoderPackage = encoderPackage;
        this.wrapEmptyBuffer = wrapEmptyBuffer;
    }

    @Override
    public void generate() {
        this.generateMessageDecoderInterface();
        super.generate();
    }

    private void generateMessageDecoderInterface() {
        this.outputManager.withOutput("MessageDecoder", out -> {
            out.append(GenerationUtil.fileHeader(this.thisPackage));
            out.append(MESSAGE_DECODER);
        });
    }

    @Override
    protected void generateAggregateFile(Aggregate aggregate, AggregateType type) {
        if (type == AggregateType.COMPONENT) {
            this.componentInterface((Component)aggregate);
            return;
        }
        String className = DecoderGenerator.decoderClassName(aggregate);
        this.outputManager.withOutput(className, out -> {
            out.append(GenerationUtil.fileHeader(this.thisPackage));
            if (REQUIRED_SESSION_CODECS.contains(className)) {
                out.append(GenerationUtil.importFor("uk.co.real_logic.artio.decoder.Abstract" + className));
            } else if (type == AggregateType.HEADER) {
                out.append(GenerationUtil.importFor(MessageTypeEncoding.class));
                out.append(GenerationUtil.importFor(SessionHeaderDecoder.class));
            }
            out.append(GenerationUtil.importFor(AsciiNumberFormatException.class));
            out.append(GenerationUtil.importFor(Generated.class));
            this.generateImports((Writer)out, type);
            this.importEncoders(aggregate, (Writer)out);
            this.generateAggregateClass(aggregate, type, className, (Writer)out);
        });
    }

    private void importEncoders(Aggregate aggregate, Writer out) throws IOException {
        String encoderFullClassName = this.encoderPackage + "." + EncoderGenerator.encoderClassName(aggregate.name());
        out.write(GenerationUtil.importFor(encoderFullClassName));
        this.importChildEncoderClasses(aggregate, out, encoderFullClassName);
    }

    private void importChildEncoderClasses(Aggregate aggregate, Writer out, String encoderFullClassName) throws IOException {
        for (Entry entry : aggregate.entries()) {
            if (entry.isComponent()) {
                String componentClassName = this.encoderPackage + "." + EncoderGenerator.encoderClassName(entry.name());
                out.write(GenerationUtil.importFor(componentClassName));
                this.importChildEncoderClasses((Aggregate)((Object)entry.element()), out, componentClassName);
                continue;
            }
            if (!entry.isGroup()) continue;
            String entryClassName = EncoderGenerator.encoderClassName(entry.name());
            out.write(GenerationUtil.importStaticFor(encoderFullClassName, entryClassName));
            this.importChildEncoderClasses((Aggregate)((Object)entry.element()), out, encoderFullClassName + "." + entryClassName);
        }
    }

    private void generateAggregateClass(Aggregate aggregate, AggregateType type, String className, Writer out) throws IOException {
        this.push(aggregate);
        boolean isMessage = type == AggregateType.MESSAGE;
        boolean isGroup = type == AggregateType.GROUP;
        List<String> interfaces = aggregate.componentEntries().map(comp -> DecoderGenerator.decoderClassName((Aggregate)((Object)comp.element()))).collect(Collectors.toList());
        if (isMessage) {
            interfaces.add("MessageDecoder");
            if (REQUIRED_SESSION_CODECS.contains(className)) {
                interfaces.add("Abstract" + className);
            }
        } else if (type == AggregateType.HEADER) {
            interfaces.add(SessionHeaderDecoder.class.getSimpleName());
        }
        out.append(this.classDeclaration(className, interfaces, false, aggregate.isInParent(), isGroup));
        this.generateValidation(out, aggregate, type);
        if (isMessage) {
            Message message = (Message)aggregate;
            if (!message.isInParent() || this.isSharedParent()) {
                out.append(this.messageType(message.fullType(), message.packedType()));
            }
            if (!this.isSharedParent()) {
                List<Field> fields = this.compileAllFieldsFor(message);
                String messageFieldsSet = this.generateFieldDictionary(fields, "messageFields", false);
                out.append(this.commonCompoundImports("Decoder", true, messageFieldsSet));
            }
        }
        this.groupMethods(out, aggregate);
        this.headerMethods(out, aggregate, type);
        this.generateGetters(out, className, aggregate.entries(), aggregate.isInParent());
        out.append(this.decodeMethod(aggregate.entries(), aggregate, type));
        out.append(this.completeResetMethod(isMessage, aggregate.entries(), this.additionalReset(isGroup), aggregate.isInParent()));
        out.append(this.generateAppendTo(aggregate, isMessage));
        out.append(this.generateToEncoder(aggregate));
        out.append("}\n");
        this.pop();
    }

    private String classDeclaration(String className, List<String> interfaces, boolean isStatic, boolean inParent, boolean isGroup) {
        Object extendsClause;
        String interfaceList;
        String string = interfaceList = interfaces.isEmpty() ? "" : " implements " + String.join((CharSequence)", ", interfaces);
        if (inParent) {
            String qualifiedName = className;
            if (isGroup) {
                qualifiedName = this.qualifiedSharedAggregateDecoderNames();
            }
            extendsClause = this.parentDictPackage() + "." + qualifiedName;
        } else {
            extendsClause = "CommonDecoderImpl";
        }
        return String.format("\n@Generated(\"uk.co.real_logic.artio\")\npublic %3$s%4$sclass %1$s extends %5$s%2$s\n{\n", className, interfaceList, isStatic ? "static " : "", this.isSharedParent() ? "abstract " : "", extendsClause);
    }

    private String qualifiedSharedAggregateDecoderNames() {
        return this.qualifiedAggregateStackNames(aggregate -> (aggregate instanceof Group ? "Abstract" : "") + DecoderGenerator.decoderClassName(aggregate.name()));
    }

    private List<Field> compileAllFieldsFor(Message message) {
        Stream<Field> messageBodyFields = this.extractFields(message.entries());
        Stream<Field> headerFields = this.extractFields(this.dictionary.header().entries());
        Stream<Field> trailerFields = this.extractFields(this.dictionary.trailer().entries());
        return Stream.of(headerFields, messageBodyFields, trailerFields).reduce(Stream::concat).orElseGet(Stream::empty).collect(Collectors.toList());
    }

    private void headerMethods(Writer out, Aggregate aggregate, AggregateType type) throws IOException {
        if (type == AggregateType.HEADER && !this.isSharedParent()) {
            out.append("    public HeaderDecoder()\n    {\n        this(new TrailerDecoder());\n    }\n\n");
            this.wrapTrailerInConstructor(out, aggregate);
            this.generatePackedMessageTypeMethod(out);
        }
    }

    private void generatePackedMessageTypeMethod(Writer out) throws IOException {
        if (this.flyweightsEnabled) {
            out.append("    public long messageType()\n    {\n        return buffer.getMessageType(msgTypeOffset, msgTypeLength);\n    }\n\n");
        } else {
            out.append("    public long messageType()\n    {\n        return MessageTypeEncoding.packMessageType(msgType(), msgTypeLength());\n    }\n\n");
        }
    }

    private void groupClass(Group group, Writer out) throws IOException {
        String className = this.groupClassName(group);
        this.generateAggregateClass(group, AggregateType.GROUP, className, out);
    }

    private String groupClassName(Group group) {
        Object className = DecoderGenerator.decoderClassName(group);
        if (this.isSharedParent()) {
            className = "Abstract" + (String)className;
        }
        return className;
    }

    @Override
    protected Class<?> topType(AggregateType aggregateType) {
        return Decoder.class;
    }

    @Override
    protected String resetGroup(Entry entry) {
        Group group = (Group)entry.element();
        String name = group.name();
        String resetMethod = this.nameOfResetMethod(name);
        if (this.isSharedParent()) {
            return String.format("    public abstract void %1$s();\n", resetMethod);
        }
        Entry numberField = group.numberField();
        return String.format("    public void %1$s()\n    {\n        for (final %2$s %6$s : %5$s.iterator())\n        {\n            %6$s.reset();\n            if (%6$s.next() == null)\n            {\n                break;\n            }\n        }\n        %3$s = MISSING_INT;\n        has%4$s = false;\n    }\n\n", resetMethod, DecoderGenerator.decoderClassName(name), JavaUtil.formatPropertyName((String)numberField.name()), numberField.name(), this.iteratorFieldName(group), JavaUtil.formatPropertyName((String)DecoderGenerator.decoderClassName(name)));
    }

    private String iteratorClassName(Group group, boolean ofParent) {
        String prefix = ofParent ? "Abstract" : "";
        return prefix + group.name() + "Iterator";
    }

    private String iteratorFieldName(Group group) {
        return JavaUtil.formatPropertyName((String)this.iteratorClassName(group, false));
    }

    @Override
    protected String resetLength(String name) {
        return String.format("    public void %1$s()\n    {\n        %2$sLength = 0;\n    }\n\n", this.nameOfResetMethod(name), JavaUtil.formatPropertyName((String)name));
    }

    @Override
    protected String resetRequiredFloat(String name) {
        String lengthReset = this.flyweightsEnabled ? "        %1$sLength = 0;\n" : "";
        return String.format("    public void %2$s()\n    {\n" + lengthReset + "        %1$s.reset();\n    }\n\n", JavaUtil.formatPropertyName((String)name), this.nameOfResetMethod(name));
    }

    @Override
    protected String resetRequiredInt(Field field) {
        return this.resetFieldValue(field, "MISSING_INT");
    }

    @Override
    protected String resetRequiredLong(Field field) {
        return this.resetFieldValue(field, "MISSING_LONG");
    }

    private String additionalReset(boolean isGroup) {
        return "        buffer = null;\n        if (CODEC_VALIDATION_ENABLED)\n        {\n            invalidTagId = Decoder.NO_ERROR;\n            rejectReason = Decoder.NO_ERROR;\n            missingRequiredFields.clear();\n" + (isGroup ? "" : "            unknownFields.clear();\n            alreadyVisitedFields.clear();\n") + "        }\n";
    }

    private void generateValidation(Writer out, Aggregate aggregate, AggregateType type) throws IOException {
        if (this.isSharedParent()) {
            out.append("    public final IntHashSet REQUIRED_FIELDS = new IntHashSet();\n\n");
            return;
        }
        List<Field> requiredFields = this.requiredFields(aggregate.entries()).collect(Collectors.toList());
        out.append(this.generateFieldDictionary(requiredFields, REQUIRED_FIELDS, true));
        if (aggregate.containsGroup()) {
            List<Field> groupFields = aggregate.allFieldsIncludingComponents().map(Entry::element).map(element -> (Field)element).collect(Collectors.toList());
            String groupFieldString = this.generateFieldDictionary(groupFields, GROUP_FIELDS, true);
            out.append(groupFieldString);
        }
        String enumValidation = aggregate.allFieldsIncludingComponents().filter(entry -> entry.element().isEnumField()).map(this::generateEnumValidation).collect(Collectors.joining("\n"));
        String groupValidation = aggregate.allGroupsIncludingComponents().map(this::generateGroupValidation).collect(Collectors.joining("\n"));
        boolean isMessage = type == AggregateType.MESSAGE;
        boolean isGroup = type == AggregateType.GROUP;
        String messageValidation = isMessage ? "        if (CODEC_REJECT_UNKNOWN_FIELD_ENABLED && unknownFieldsIterator.hasNext())\n        {\n            invalidTagId = unknownFieldsIterator.nextValue();\n            rejectReason = Constants.ALL_FIELDS.contains(invalidTagId) ? " + TAG_NOT_DEFINED_FOR_THIS_MESSAGE_TYPE + " : " + INVALID_TAG_NUMBER + ";\n            return false;\n        }\n        if (!header.validate())\n        {\n            invalidTagId = header.invalidTagId();\n            rejectReason = header.rejectReason();\n            return false;\n        }\n        else if (!trailer.validate())\n        {\n            invalidTagId = trailer.invalidTagId();\n            rejectReason = trailer.rejectReason();\n            return false;\n        }\n" : "";
        out.append(String.format((isGroup ? this.generateAllGroupFields(aggregate) : "    private final IntHashSet alreadyVisitedFields = new IntHashSet(%5$d);\n\n    private final IntHashSet unknownFields = new IntHashSet(10);\n\n") + "    private final IntHashSet missingRequiredFields = new IntHashSet(%1$d);\n\n    public boolean validate()\n    {\n        if (rejectReason != Decoder.NO_ERROR)\n        {\n            return false;\n        }\n        final IntIterator missingFieldsIterator = missingRequiredFields.iterator();\n" + (isMessage ? "        final IntIterator unknownFieldsIterator = unknownFields.iterator();\n" : "") + "%2$s        if (missingFieldsIterator.hasNext())\n        {\n            invalidTagId = missingFieldsIterator.nextValue();\n            rejectReason = " + REQUIRED_TAG_MISSING + ";\n            return false;\n        }\n%3$s%4$s        return true;\n    }\n\n", ConstantGenerator.sizeHashSet(requiredFields), messageValidation, enumValidation, groupValidation, 2L * aggregate.allFieldsIncludingComponents().count()));
    }

    private String generateAllGroupFields(Aggregate groupAggregate) {
        List<Field> allGroupFields = groupAggregate.fieldEntries().map(entry -> (Field)entry.element()).collect(Collectors.toList());
        return this.generateFieldDictionary(allGroupFields, ALL_GROUP_FIELDS, true);
    }

    private String generateFieldDictionary(Collection<Field> fields, String name, boolean shouldGenerateValidationGating) {
        String addFields = fields.stream().map(field -> DecoderGenerator.addField(field, name, shouldGenerateValidationGating ? "            " : "        ")).collect(Collectors.joining());
        String generatedFieldEntryCode = shouldGenerateValidationGating ? "        if (CODEC_VALIDATION_ENABLED)\n        {\n%s        }\n" : "%s";
        int hashMapSize = ConstantGenerator.sizeHashSet(fields);
        return String.format("    public final IntHashSet %2$s = new IntHashSet(%1$d);\n\n    {\n%3$s    }\n\n", hashMapSize, name, String.format(generatedFieldEntryCode, addFields));
    }

    public static String addField(Field field, String name, String prefix) {
        return String.format("%1$s%2$s.add(Constants.%3$s);\n", prefix, name, GenerationUtil.constantName(field.name()));
    }

    private CharSequence generateEnumValidation(Entry entry) {
        Field field = (Field)entry.element();
        if (!EnumGenerator.hasEnumGenerated(field)) {
            return "";
        }
        String name = entry.name();
        int tagNumber = field.number();
        Field.Type type = field.type();
        String propertyName = JavaUtil.formatPropertyName((String)name);
        boolean isPrimitive = type.isIntBased() || type == Field.Type.CHAR;
        String enumValidation = String.format("        if (" + this.codecRejectUnknownEnumValueEnabled + " && !%1$s.isValid(%2$s%4$s))\n        {\n            invalidTagId = %3$s;\n            rejectReason = " + VALUE_IS_INCORRECT + ";\n            return false;\n        }\n", EnumGenerator.enumName(name), propertyName, tagNumber, isPrimitive ? "()" : "Wrapper");
        String enumValidationMethod = type.isMultiValue() ? String.format("          int %1$sOffset = 0;\n          for (int i = 0; i < %1$sLength; i++)\n          {\n              if (this.%1$s()[i] == ' ')\n              {\n                  %1$sWrapper.wrap(this.%1$s(), %1$sOffset, i - %1$sOffset);\n%2$s                  %1$sOffset = i + 1;\n              }\n          }\n          %1$sWrapper.wrap(this.%1$s(), %1$sOffset, %1$sLength - %1$sOffset);\n%2$s", propertyName, enumValidation) : String.format((isPrimitive ? "" : "        %1$sWrapper.wrap(this.%1$s(), %1$sLength);\n") + "%2$s", propertyName, enumValidation);
        return entry.required() ? enumValidationMethod : String.format("        if (has%1$s)\n        {\n%2$s        }\n", entry.name(), enumValidationMethod);
    }

    private CharSequence generateGroupValidation(Entry entry) {
        Group group = (Group)entry.element();
        Entry numberField = group.numberField();
        String numberFieldName = numberField.name();
        boolean required = entry.required();
        String validationCode = String.format("%3$s        {\n%3$s            int count = 0;\n%3$s            final %4$s iterator = %2$s.iterator();\n%3$s            for (final %1$s group : iterator)\n%3$s            {\n%3$s                count++;%3$s                if (!group.validate())\n%3$s                {\n%3$s                    invalidTagId = group.invalidTagId();\n%3$s                    rejectReason = group.rejectReason();\n%3$s                    return false;\n%3$s                }\n%3$s            }\n%3$s            if (count != iterator.numberFieldValue())\n%3$s            {\n%3$s                invalidTagId = %5$s;\n%3$s                rejectReason = %6$s;\n%3$s                return false;\n%3$s            }\n%3$s        }\n", DecoderGenerator.decoderClassName(group), this.iteratorFieldName(group), required ? "" : "    ", this.iteratorClassName(group, false), numberField.number(), INCORRECT_NUMINGROUP_COUNT_FOR_REPEATING_GROUP);
        if (required) {
            return validationCode;
        }
        return String.format("        if (has%1$s)\n        {\n%2$s        }\n", numberFieldName, validationCode);
    }

    private Stream<Field> requiredFields(List<Entry> entries) {
        return entries.stream().filter(Entry::required).flatMap(this::extractRequiredFields);
    }

    private Stream<Field> extractRequiredFields(Entry entry) {
        return entry.match((e, field) -> Stream.of(field), (e, group) -> Stream.of((Field)group.numberField().element()), (e, component) -> this.requiredFields(component.entries()), (e, anyFields) -> Stream.empty());
    }

    private Stream<Field> extractFields(Entry entry) {
        return entry.match((e, field) -> Stream.of(field), (e, group) -> Stream.concat(Stream.of((Field)group.numberField().element()), group.entries().stream().flatMap(this::extractFields)), (e, component) -> component.entries().stream().flatMap(this::extractFields), (e, anyFields) -> Stream.empty());
    }

    private Stream<Field> extractFields(List<Entry> entries) {
        return entries.stream().flatMap(this::extractFields);
    }

    private void componentInterface(Component component) {
        this.push(component);
        String className = DecoderGenerator.decoderClassName(component);
        this.outputManager.withOutput(className, out -> {
            out.append(GenerationUtil.fileHeader(this.thisPackage));
            List interfaces = component.allComponents().map(comp -> DecoderGenerator.decoderClassName((Aggregate)((Object)comp.element()))).collect(Collectors.toList());
            if (component.isInParent()) {
                interfaces.add(this.parentDictPackage() + "." + className);
            }
            String interfaceExtension = interfaces.isEmpty() ? "" : " extends " + String.join((CharSequence)", ", interfaces);
            out.append(GenerationUtil.importFor(AsciiNumberFormatException.class));
            this.generateImports((Writer)out, AggregateType.COMPONENT);
            this.importEncoders(component, (Writer)out);
            out.append(GenerationUtil.importFor(Generated.class));
            out.append(String.format("\n@Generated(\"uk.co.real_logic.artio\")\npublic interface %1$s %2$s\n{\n\n", className, interfaceExtension));
            for (Entry entry : component.entries()) {
                if (entry.isInParent() && !entry.isGroup()) continue;
                this.componentInterfaceGetter(entry, (Writer)out);
            }
            out.append("\n}\n");
        });
        this.pop();
    }

    private void generateImports(Writer out, AggregateType component) throws IOException {
        this.generateImports("Decoder", component, out, Encoder.class, CommonDecoderImpl.class);
    }

    private void componentInterfaceGetter(Entry entry, Writer out) {
        entry.forEach((ResourceConsumer<Field>)((ResourceConsumer)field -> out.append(this.fieldInterfaceGetter(entry, (Field)field))), (ResourceConsumer<Group>)((ResourceConsumer)group -> this.groupInterfaceGetter((Group)group, out)), (ResourceConsumer<Component>)((ResourceConsumer)component -> {}), (ResourceConsumer<AnyFields>)((ResourceConsumer)anyFields -> {}));
    }

    private void groupInterfaceGetter(Group group, Writer out) throws IOException {
        this.groupClass(group, out);
        this.generateGroupIterator(out, group);
        Entry numberField = group.numberField();
        boolean ofParent = this.isSharedParent();
        out.append(String.format("    public %1$s %2$s();\n", this.iteratorClassName(group, ofParent), this.iteratorFieldName(group)));
        out.append(this.fieldInterfaceGetter(numberField, (Field)numberField.element()));
        out.append(String.format("    public %1$s %2$s();\n", this.groupClassName(group), JavaUtil.formatPropertyName((String)group.name())));
    }

    private void wrappedForEachEntry(Aggregate aggregate, Writer out, ResourceConsumer<Entry> consumer) throws IOException {
        out.append("\n");
        aggregate.entries().forEach(t -> {
            try {
                consumer.accept(t);
            }
            catch (IOException ex) {
                LangUtil.rethrowUnchecked((Throwable)ex);
            }
        });
        out.append("\n");
    }

    private String fieldInterfaceGetter(Entry entry, Field field) {
        String name = field.name();
        String fieldName = JavaUtil.formatPropertyName((String)name);
        Field.Type type = field.type();
        String javadoc = this.generateAccessorJavadoc(field);
        String length = type.isStringBased() ? String.format("    %2$spublic int %1$sLength();\n", fieldName, javadoc) : "";
        String stringAsciiView = type.isStringBased() ? String.format("    %2$spublic AsciiSequenceView %1$s(AsciiSequenceView view);\n", fieldName, javadoc) : "";
        String optional = !entry.required() ? String.format("    %2$spublic boolean has%1$s();\n", name, javadoc) : "";
        String enumDecoder = this.shouldGenerateClassEnumMethods(field) ? String.format("    %3$spublic %1$s %2$sAsEnum();\n", name, fieldName, javadoc) : "";
        return String.format("    %7$spublic %1$s %2$s();\n%3$s%4$s%5$s%6$s", this.javaTypeOf(type), fieldName, optional, length, enumDecoder, stringAsciiView, javadoc);
    }

    private void generateGetter(Entry entry, Writer out, Set<String> missingOptionalFields, boolean aggregateIsInParent) {
        entry.forEach((ResourceConsumer<Field>)((ResourceConsumer)field -> {
            missingOptionalFields.remove(field.name());
            out.append(this.fieldGetter(entry, (Field)field, aggregateIsInParent));
        }), (ResourceConsumer<Group>)((ResourceConsumer)group -> this.groupGetter((Group)group, out, aggregateIsInParent)), (ResourceConsumer<Component>)((ResourceConsumer)component -> {
            boolean componentIsInParent = aggregateIsInParent && entry.isInParent();
            this.componentGetter((Component)component, out, missingOptionalFields, componentIsInParent);
        }), (ResourceConsumer<AnyFields>)((ResourceConsumer)anyFields -> {}));
    }

    private void groupMethods(Writer out, Aggregate aggregate) throws IOException {
        if (aggregate instanceof Group) {
            Group group = (Group)aggregate;
            this.wrapTrailerAndMessageFieldsInGroupConstructor(out, group);
            out.append(String.format("    private %1$s next = null;\n\n    public %1$s next()\n    {\n        return next;\n    }\n\n    private IntHashSet seenFields = new IntHashSet(%2$d);\n\n", this.groupClassName(group), ConstantGenerator.sizeHashSet(group.entries())));
        }
    }

    private void wrapTrailerAndMessageFieldsInGroupConstructor(Writer out, Aggregate aggregate) throws IOException {
        if (this.isSharedParent()) {
            return;
        }
        out.append(String.format("    private final TrailerDecoder trailer;\n    private final IntHashSet %1$s;\n    public %2$s(final TrailerDecoder trailer, final IntHashSet %1$s)\n    {\n        this.trailer = trailer;\n        this.%1$s = %1$s;\n    }\n\n", "messageFields", DecoderGenerator.decoderClassName(aggregate)));
    }

    private void wrapTrailerInConstructor(Writer out, Aggregate aggregate) throws IOException {
        out.append(String.format("    private final TrailerDecoder trailer;\n    public %1$s(final TrailerDecoder trailer)\n    {\n        this.trailer = trailer;\n    }\n\n", DecoderGenerator.decoderClassName(aggregate)));
    }

    private String messageType(String fullType, long packedType) {
        return String.format("    public static final long MESSAGE_TYPE = %1$dL;\n\n    public static final String MESSAGE_TYPE_AS_STRING = \"%2$s\";\n\n    public static final char[] MESSAGE_TYPE_CHARS = MESSAGE_TYPE_AS_STRING.toCharArray();\n\n    public static final byte[] MESSAGE_TYPE_BYTES = MESSAGE_TYPE_AS_STRING.getBytes(US_ASCII);\n\n", packedType, fullType);
    }

    private void generateGetters(Writer out, String className, List<Entry> entries, boolean aggregateIsInParent) throws IOException {
        List<String> optionalFields = OptionalSessionFields.DECODER_OPTIONAL_SESSION_FIELDS.get(className);
        HashSet<String> missingOptionalFields = optionalFields == null ? Collections.emptySet() : new HashSet<String>(optionalFields);
        for (Entry entry : entries) {
            this.generateGetter(entry, out, missingOptionalFields, aggregateIsInParent);
        }
        this.generateMissingOptionalSessionFields(out, missingOptionalFields);
        this.generateOptionalSessionFieldsSupportedMethods(optionalFields, missingOptionalFields, out);
    }

    private void generateMissingOptionalSessionFields(Writer out, Set<String> missingOptionalFields) throws IOException {
        block4: for (String optionalField : missingOptionalFields) {
            String propertyName = JavaUtil.formatPropertyName((String)optionalField);
            Field.Type type = OptionalSessionFields.OPTIONAL_FIELD_TYPES.get(optionalField);
            switch (type) {
                case STRING: {
                    out.append(String.format("    public char[] %1$s()\n    {\n        throw new UnsupportedOperationException();\n    }\n\n    public boolean has%2$s()\n    {\n        throw new UnsupportedOperationException();\n    }\n\n    public int %1$sLength()\n    {\n        throw new UnsupportedOperationException();\n    }\n\n    public String %1$sAsString()\n    {\n        throw new UnsupportedOperationException();\n    }\n\n    public AsciiSequenceView %1$s(final AsciiSequenceView view)\n    {\n        throw new UnsupportedOperationException();\n    }\n\n", propertyName, optionalField));
                    continue block4;
                }
                case INT: {
                    out.append(String.format("    public int %1$s()\n    {\n        throw new UnsupportedOperationException();\n    }\n\n    public boolean has%2$s()\n    {\n        throw new UnsupportedOperationException();\n    }\n\n", propertyName, optionalField));
                    continue block4;
                }
            }
            throw new UnsupportedOperationException("Unknown field type for: '" + optionalField + "'");
        }
    }

    private void componentGetter(Component component, Writer out, Set<String> missingOptionalFields, boolean aggregateIsInParent) throws IOException {
        this.push(component);
        this.wrappedForEachEntry(component, out, (ResourceConsumer<Entry>)((ResourceConsumer)entry -> this.generateGetter((Entry)entry, out, missingOptionalFields, aggregateIsInParent)));
        this.pop();
    }

    private void groupGetter(Group group, Writer out, boolean aggregateIsShared) throws IOException {
        Aggregate currentAggregate = this.currentAggregate();
        boolean inComponent = currentAggregate instanceof Component;
        if (!inComponent) {
            this.groupClass(group, out);
            this.generateGroupIterator(out, group);
        }
        Entry numberField = group.numberField();
        String prefix = group.isInParent() && aggregateIsShared && !inComponent ? "" : this.fieldGetter(numberField, (Field)numberField.element(), aggregateIsShared);
        String groupClassName = this.groupClassName(group);
        if (this.isSharedParent()) {
            out.append(String.format("\n    public abstract %1$s %2$s();\n\n%3$s\n    public abstract %4$s %5$s();\n\n", groupClassName, JavaUtil.formatPropertyName((String)group.name()), prefix, this.iteratorClassName(group, true), this.iteratorFieldName(group)));
        } else {
            out.append(String.format("\n    private %1$s %2$s = null;\n    public %1$s %2$s()\n    {\n        return %2$s;\n    }\n\n%3$s\n    private %4$s %5$s = new %4$s(this);\n    public %4$s %5$s()\n    {\n        return %5$s.iterator();\n    }\n\n", groupClassName, JavaUtil.formatPropertyName((String)group.name()), prefix, this.iteratorClassName(group, false), this.iteratorFieldName(group)));
        }
    }

    private void generateGroupIterator(Writer out, Group group) throws IOException {
        String numberFieldName = group.numberField().name();
        String formattedNumberFieldName = JavaUtil.formatPropertyName((String)numberFieldName);
        String numberFieldReset = group.numberField().required() ? String.format("parent.%1$s()", formattedNumberFieldName) : String.format("parent.has%1$s() ? parent.%2$s() : 0", numberFieldName, formattedNumberFieldName);
        boolean sharedParent = this.isSharedParent();
        String iteratorClassName = this.iteratorClassName(group, sharedParent);
        String groupDecoderName = this.groupClassName(group);
        String parentDecoderName = this.qualifiedSharedAggregateDecoderNames();
        String groupPropertyName = JavaUtil.formatPropertyName((String)group.name());
        if (sharedParent) {
            out.append(String.format("    @Generated(\"uk.co.real_logic.artio\")\n    public abstract class %1$s<T extends %2$s> implements Iterable<T>, java.util.Iterator<T>\n    {\n        private final %3$s parent;\n        private int remainder;\n        private T current;\n\n        public %1$s(final %3$s parent)\n        {\n            this.parent = parent;\n        }\n\n        public boolean hasNext()\n        {\n            return remainder > 0 && current != null;\n        }\n\n        @SuppressWarnings(\"unchecked\")\n        public T next()\n        {\n            remainder--;\n            final T value = current;\n            current = (T)current.next();\n            return value;\n        }\n\n        public int numberFieldValue()\n        {\n            return %4$s;\n        }\n\n        @SuppressWarnings(\"unchecked\")\n        public void reset()\n        {\n            remainder = numberFieldValue();\n            current = (T)parent.%5$s();\n        }\n\n    }\n\n", iteratorClassName, groupDecoderName, parentDecoderName, numberFieldReset, groupPropertyName));
        } else if (group.isInParent()) {
            String parentLocation = this.parentDictPackage() + "." + parentDecoderName + "." + this.iteratorClassName(group, true);
            out.append(String.format("    public class %1$s extends %4$s<%2$s>\n    {\n        public %1$s(final %3$s parent)\n        {\n            super(parent);\n        }\n\n        public %1$s iterator()\n        {\n            reset();\n            return this;\n        }\n\n    }\n\n", iteratorClassName, groupDecoderName, parentDecoderName, parentLocation));
        } else {
            this.generateNormalGroupIterator(out, numberFieldReset, iteratorClassName, groupDecoderName, groupPropertyName);
        }
    }

    private void generateNormalGroupIterator(Writer out, String numberFieldReset, String iteratorClassName, String groupDecoderName, String groupPropertyName) throws IOException {
        String parentDecoderName = DecoderGenerator.decoderClassName(this.currentAggregate());
        out.append(String.format("    @Generated(\"uk.co.real_logic.artio\")\n    public class %1$s implements Iterable<%2$s>, java.util.Iterator<%2$s>\n    {\n        private final %3$s parent;\n        private int remainder;\n        private %2$s current;\n\n        public %1$s(final %3$s parent)\n        {\n            this.parent = parent;\n        }\n\n        public boolean hasNext()\n        {\n            return remainder > 0 && current != null;\n        }\n\n        public %2$s next()\n        {\n            remainder--;\n            final %2$s value = current;\n            current = current.next();\n            return value;\n        }\n\n        public int numberFieldValue()\n        {\n            return %4$s;\n        }\n\n        public void reset()\n        {\n            remainder = numberFieldValue();\n            current = parent.%5$s();\n        }\n\n        public %1$s iterator()\n        {\n            reset();\n            return this;\n        }\n\n    }\n\n", iteratorClassName, groupDecoderName, parentDecoderName, numberFieldReset, groupPropertyName));
    }

    private String fieldGetter(Entry entry, Field field, boolean aggregateIsInParent) {
        String offsetField;
        if (entry.isInParent() && aggregateIsInParent) {
            return "";
        }
        String name = field.name();
        String fieldName = JavaUtil.formatPropertyName((String)name);
        Field.Type type = field.type();
        String optionalCheck = this.optionalCheck(entry);
        String asStringBody = this.generateAsStringBody(entry, name, fieldName);
        String javadoc = this.generateAccessorJavadoc(field);
        String extraStringDecode = type.isStringBased() ? String.format("    %4$spublic String %1$sAsString()\n    {\n        return %3$s;\n    }\n\n    %4$spublic AsciiSequenceView %1$s(final AsciiSequenceView view)\n    {\n%2$s        return view.wrap(buffer, %1$sOffset, %1$sLength);\n    }\n\n", fieldName, this.wrapEmptyBuffer ? this.wrapEmptyBuffer(entry) : optionalCheck, asStringBody, javadoc) : "";
        String lengthBasedFields = type.hasLengthField(this.flyweightsEnabled) ? String.format("    %4$s int %1$sLength;\n\n    %5$spublic int %1$sLength()\n    {\n%2$s        return %1$sLength;\n    }\n\n%3$s", fieldName, optionalCheck, extraStringDecode, this.scope, javadoc) : "";
        String string = offsetField = type.hasOffsetField(this.flyweightsEnabled) ? String.format("    %3$s int %1$sOffset;\n\n%2$s", fieldName, lengthBasedFields, this.scope) : "";
        String enumValueDecoder = String.format(type.isStringBased() ? "%1$s.decode(%2$sWrapper)" : (this.flyweightsEnabled && (type.isIntBased() || type.isFloatBased()) ? "%1$s.decode(this.%2$s())" : "%1$s.decode(%2$s)"), EnumGenerator.enumName(name), fieldName);
        String enumStringBasedWrapperField = String.format("    %2$s final CharArrayWrapper %1$sWrapper = new CharArrayWrapper();\n", fieldName, this.scope);
        String enumDecoder = this.shouldGenerateClassEnumMethods(field) ? String.format("%4$s    %7$spublic %6$s %2$sAsEnum()\n    {\n" + (!entry.required() ? "        if (!has%1$s)\n return %6$s.%5$s;\n" : "") + (type.isStringBased() ? "        %2$sWrapper.wrap(this.%2$s(), %2$sLength);\n" : "") + "        return %3$s;\n    }\n\n", name, fieldName, enumValueDecoder, enumStringBasedWrapperField, "NULL_VAL", EnumGenerator.enumName(name), javadoc) : (field.type().isMultiValue() || field.type() == Field.Type.STRING ? enumStringBasedWrapperField : "");
        String lazyInitialisation = DecoderGenerator.fieldLazyInstantialisation(field, fieldName);
        return String.format("    %10$s %1$s %2$s%3$s;\n\n%4$s    %11$spublic %1$s %2$s()\n    {\n%5$s%9$s        return %2$s;\n    }\n\n%6$s\n%7$s\n%8$s", this.javaTypeOf(type), fieldName, this.fieldInitialisation(type), this.hasField(entry), optionalCheck, this.optionalGetter(entry), offsetField, enumDecoder, this.flyweightsEnabled ? lazyInitialisation : "", this.scope, javadoc);
    }

    private String wrapEmptyBuffer(Entry entry) {
        return entry.required() ? "" : String.format("        if (!has%s)\n        {\n            return view.wrap(buffer, 0, 0);\n        }\n\n", entry.name());
    }

    private String generateAsStringBody(Entry entry, String name, String fieldName) {
        String asStringBody = this.flyweightsEnabled ? String.format(entry.required() ? "buffer != null ? buffer.getStringWithoutLengthAscii(%1$sOffset, %1$sLength) : \"\"" : "has%2$s ? buffer.getStringWithoutLengthAscii(%1$sOffset, %1$sLength) : null", fieldName, name) : String.format(entry.required() ? "new String(%1$s, 0, %1$sLength)" : "has%2$s ? new String(%1$s, 0, %1$sLength) : null", fieldName, name);
        return asStringBody;
    }

    private static String fieldLazyInstantialisation(Field field, String fieldName) {
        int tag = field.number();
        switch (field.type()) {
            case NUMINGROUP: {
                return String.format("%1$s = groupNoField(buffer, %1$s, has%2$s, %1$sOffset, %1$sLength, %3$d, CODEC_VALIDATION_ENABLED);\n", fieldName, field.name(), field.number());
            }
            case INT: 
            case LENGTH: 
            case SEQNUM: 
            case DAYOFMONTH: {
                return DecoderGenerator.lengthBasedFieldLazyInitialization(fieldName, "getIntFlyweight(buffer", ", " + tag + ", CODEC_VALIDATION_ENABLED");
            }
            case LONG: {
                return DecoderGenerator.lengthBasedFieldLazyInitialization(fieldName, "getLongFlyweight(buffer", ", " + tag + ", CODEC_VALIDATION_ENABLED");
            }
            case FLOAT: 
            case PRICE: 
            case PRICEOFFSET: 
            case QTY: 
            case QUANTITY: 
            case PERCENTAGE: 
            case AMT: {
                return DecoderGenerator.lengthBasedFieldLazyInitialization(fieldName, "getFloatFlyweight(buffer, " + fieldName, ", " + tag + ", CODEC_VALIDATION_ENABLED");
            }
            case STRING: 
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: 
            case MULTIPLECHARVALUE: 
            case CURRENCY: 
            case EXCHANGE: 
            case COUNTRY: 
            case LANGUAGE: {
                return DecoderGenerator.lengthBasedFieldLazyInitialization(fieldName, "buffer.getChars(" + fieldName, "");
            }
            case DATA: 
            case XMLDATA: {
                Field associatedLengthField = field.associatedLengthField();
                if (associatedLengthField == null) {
                    throw new IllegalStateException("No associated length field for: " + String.valueOf(field));
                }
                String associatedFieldName = JavaUtil.formatPropertyName((String)associatedLengthField.name());
                return String.format("        if (buffer != null && %2$s > 0)\n        {\n            %1$s = buffer.getBytes(%1$s, %1$sOffset, %2$s);\n        }\n", fieldName, associatedFieldName);
            }
            case UTCTIMESTAMP: 
            case LOCALMKTDATE: 
            case UTCTIMEONLY: 
            case UTCDATEONLY: 
            case TZTIMEONLY: 
            case TZTIMESTAMP: 
            case MONTHYEAR: {
                return DecoderGenerator.lengthBasedFieldLazyInitialization(fieldName, "buffer.getBytes(" + fieldName, "");
            }
        }
        return "";
    }

    private static String lengthBasedFieldLazyInitialization(String fieldName, String decodeMethod, String endArgs) {
        return String.format("        if (buffer != null && %1$sLength > 0)\n        {\n            %1$s = %2$s, %1$sOffset, %1$sLength%3$s);\n        }\n", fieldName, decodeMethod, endArgs);
    }

    private String fieldInitialisation(Field.Type type) {
        switch (type) {
            case STRING: 
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: 
            case MULTIPLECHARVALUE: 
            case CURRENCY: 
            case EXCHANGE: 
            case COUNTRY: 
            case LANGUAGE: {
                return String.format(" = new char[%d]", this.initialBufferSize);
            }
            case FLOAT: 
            case PRICE: 
            case PRICEOFFSET: 
            case QTY: 
            case QUANTITY: 
            case PERCENTAGE: 
            case AMT: {
                return " = DecimalFloat.newNaNValue()";
            }
            case BOOLEAN: {
                return "";
            }
            case CHAR: {
                return " = MISSING_CHAR";
            }
            case INT: 
            case NUMINGROUP: 
            case LENGTH: 
            case SEQNUM: 
            case DAYOFMONTH: {
                return " = MISSING_INT";
            }
            case LONG: {
                return " = MISSING_LONG";
            }
            case DATA: 
            case XMLDATA: {
                return this.initByteArray(this.initialBufferSize);
            }
            case UTCTIMESTAMP: {
                return this.initByteArray(24);
            }
            case LOCALMKTDATE: {
                return this.initByteArray(8);
            }
            case UTCTIMEONLY: {
                return this.initByteArray(12);
            }
            case UTCDATEONLY: {
                return this.initByteArray(8);
            }
            case MONTHYEAR: {
                return this.initByteArray(8);
            }
            case TZTIMEONLY: {
                return this.initByteArray(19);
            }
            case TZTIMESTAMP: {
                return this.initByteArray(31);
            }
        }
        throw new UnsupportedOperationException("Unknown type: " + String.valueOf((Object)type));
    }

    private String initByteArray(int initialBufferSize) {
        return String.format(" = new byte[%d]", initialBufferSize);
    }

    private String optionalGetter(Entry entry) {
        return entry.required() ? "" : this.hasGetter(entry.name());
    }

    private String optionalCheck(Entry entry) {
        return entry.required() ? "" : String.format("        if (!has%s)\n        {\n            throw new IllegalArgumentException(\"No value for optional field: %1$s\");\n        }\n\n", entry.name());
    }

    private String javaTypeOf(Field.Type type) {
        switch (type) {
            case INT: 
            case NUMINGROUP: 
            case LENGTH: 
            case SEQNUM: 
            case DAYOFMONTH: {
                return "int";
            }
            case LONG: {
                return "long";
            }
            case FLOAT: 
            case PRICE: 
            case PRICEOFFSET: 
            case QTY: 
            case QUANTITY: 
            case PERCENTAGE: 
            case AMT: {
                return "DecimalFloat";
            }
            case CHAR: {
                return "char";
            }
            case STRING: 
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: 
            case MULTIPLECHARVALUE: 
            case CURRENCY: 
            case EXCHANGE: 
            case COUNTRY: 
            case LANGUAGE: {
                return "char[]";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case DATA: 
            case XMLDATA: 
            case UTCTIMESTAMP: 
            case LOCALMKTDATE: 
            case UTCTIMEONLY: 
            case UTCDATEONLY: 
            case TZTIMEONLY: 
            case TZTIMESTAMP: 
            case MONTHYEAR: {
                return "byte[]";
            }
        }
        throw new UnsupportedOperationException("Unknown type: " + String.valueOf((Object)type));
    }

    private String decodeMethod(List<Entry> entries, Aggregate aggregate, AggregateType type) {
        if (this.isSharedParent()) {
            return "";
        }
        boolean hasCommonCompounds = type == AggregateType.MESSAGE;
        boolean isGroup = type == AggregateType.GROUP;
        boolean isHeader = type == AggregateType.HEADER;
        String endGroupCheck = this.endGroupCheck(aggregate, isGroup);
        String prefix = this.generateDecodePrefix(aggregate, hasCommonCompounds, isGroup, isHeader, endGroupCheck);
        String body = entries.stream().map(this::decodeEntry).collect(Collectors.joining("\n", "", "\n"));
        String suffix = "            default:\n                if (!CODEC_REJECT_UNKNOWN_FIELD_ENABLED)\n                {\n" + (isGroup ? "                    seenFields.remove(tag);\n" : "                    alreadyVisitedFields.remove(tag);\n") + "                }\n" + (String)(isGroup ? "" : "                else\n                {\n                    if (!" + this.unknownFieldPredicate(type) + ")\n                    {\n                        unknownFields.add(tag);\n                    }\n                }\n") + "                if (CODEC_REJECT_UNKNOWN_FIELD_ENABLED || " + this.unknownFieldPredicate(type) + ")\n                {\n" + this.decodeTrailerOrReturn(hasCommonCompounds, 5) + "                }\n\n            }\n\n            if (position < (endOfField + 1))\n            {\n                position = endOfField + 1;\n            }\n        }\n" + this.decodeTrailerOrReturn(hasCommonCompounds, 2) + "    }\n\n";
        return prefix + body + suffix;
    }

    private String generateDecodePrefix(Aggregate aggregate, boolean hasCommonCompounds, boolean isGroup, boolean isHeader, String endGroupCheck) {
        return "    public int decode(final AsciiBuffer buffer, final int offset, final int length)\n    {\n        // Decode " + aggregate.name() + "\n        int seenFieldCount = 0;\n        if (CODEC_VALIDATION_ENABLED)\n        {\n            missingRequiredFields.copy(REQUIRED_FIELDS);\n" + (isGroup ? "" : "            alreadyVisitedFields.clear();\n") + "        }\n        this.buffer = buffer;\n        final int end = offset + length;\n        int position = offset;\n        int positionIter = position;\n" + (hasCommonCompounds ? "        position += header.decode(buffer, position, length);\n" : "") + (isGroup ? "        seenFields.clear();\n" : "") + "        int tag;\n\n        while (position < end)\n        {\n            final int equalsPosition = buffer.scan(position, end, '=');\n            if (equalsPosition == AsciiBuffer.UNKNOWN_INDEX)\n            {\n               return position;\n            }\n            tag = buffer.getInt(position, equalsPosition);\n" + endGroupCheck + "            final int valueOffset = equalsPosition + 1;\n            int endOfField = buffer.scan(valueOffset, end, START_OF_HEADER);\n            if (endOfField == AsciiBuffer.UNKNOWN_INDEX)\n            {\n                rejectReason = " + VALUE_IS_INCORRECT + ";\n                break;\n            }\n            final int valueLength = endOfField - valueOffset;\n            if (CODEC_VALIDATION_ENABLED)\n            {\n                if (tag <= 0)\n                {\n                    invalidTagId = tag;\n                    rejectReason = " + INVALID_TAG_NUMBER + ";\n                }\n                else if (valueLength == 0)\n                {\n                    invalidTagId = tag;\n                    rejectReason = " + TAG_SPECIFIED_WITHOUT_A_VALUE + ";\n                }\n" + this.headerValidation(isHeader) + (String)(isGroup ? "" : "                if (!alreadyVisitedFields.add(tag))\n                {\n                    invalidTagId = tag;\n                    rejectReason = " + TAG_APPEARS_MORE_THAN_ONCE + ";\n                }\n") + "                missingRequiredFields.remove(tag);\n                seenFieldCount++;\n            }\n\n            switch (tag)\n            {\n";
    }

    private String decodeTrailerOrReturn(boolean hasCommonCompounds, int indent) {
        return (hasCommonCompounds ? this.indent(indent, "position += trailer.decode(buffer, position, end - position);\n") : "") + this.indent(indent, "return position - offset;\n");
    }

    private String unknownFieldPredicate(AggregateType type) {
        switch (type) {
            case TRAILER: {
                return "REQUIRED_FIELDS.contains(tag)";
            }
            case HEADER: {
                return "true";
            }
            case MESSAGE: {
                return "(trailer.REQUIRED_FIELDS.contains(tag))";
            }
        }
        return "(trailer.REQUIRED_FIELDS.contains(tag) || messageFields.contains(tag))";
    }

    private String endGroupCheck(Aggregate aggregate, boolean isGroup) {
        String endGroupCheck = isGroup ? String.format("            if (!seenFields.add(tag))\n            {\n                if (next == null)\n                {\n                    next = new %1$s(trailer, %2$s);\n                }\n                return position - offset;\n            }\n", DecoderGenerator.decoderClassName(aggregate), "messageFields") : "";
        return endGroupCheck;
    }

    private String headerValidation(boolean isHeader) {
        return isHeader ? "                else if (seenFieldCount == 0 && tag != 8)\n                {\n                    invalidTagId = tag;\n                    rejectReason = 14;\n                }\n                else if (seenFieldCount == 1 && tag != 9)\n                {\n                    invalidTagId = tag;\n                    rejectReason = 14;\n                }\n                else if (seenFieldCount == 2 && tag != 35)\n                {\n                    invalidTagId = tag;\n                    rejectReason = 14;\n                }\n" : "";
    }

    private String decodeEntry(Entry entry) {
        return entry.matchEntry(e -> this.decodeField((Entry)e, ""), this::decodeGroup, this::decodeComponent, e -> "");
    }

    private String decodeComponent(Entry entry) {
        Component component = (Component)entry.element();
        return component.entries().stream().map(this::decodeEntry).collect(Collectors.joining("\n", "", "\n"));
    }

    @Override
    protected String componentAppendTo(Component component) {
        return component.entries().stream().map(this::generateEntryAppendTo).collect(Collectors.joining("\n"));
    }

    private String decodeGroup(Entry entry) {
        Group group = (Group)entry.element();
        Entry numberField = group.numberField();
        String groupNumberField = JavaUtil.formatPropertyName((String)numberField.name());
        Object getNumberField = this.flyweightsEnabled ? String.format("this.%1$s = groupNoField(buffer, MISSING_INT, has%2$s, %1$sOffset, %1$sLength, %3$d, CODEC_VALIDATION_ENABLED)", groupNumberField, numberField.name(), numberField.number()) : "this." + groupNumberField;
        String parseGroup = String.format("                if (%1$s == null)\n                {\n                    %1$s = new %2$s(trailer, %5$s);\n                }\n                %2$s %1$sCurrent = %1$s;\n                position = endOfField + 1;\n                final int %3$s = %4$s;\n                for (int i = 0; i < %3$s && position < end; i++)\n                {\n                    if (%1$sCurrent != null)\n                    {\n                        positionIter = %1$sCurrent.decode(buffer, position, end - position);\n                        if (positionIter == 0 && CODEC_VALIDATION_ENABLED)\n                        {\n                                invalidTagId = tag;\n                                rejectReason = " + INCORRECT_NUMINGROUP_COUNT_FOR_REPEATING_GROUP + ";\n                                break;\n                        }\n                        else\n                        {\n                                position += positionIter;\n                        }\n                        %1$sCurrent = %1$sCurrent.next();\n                    }\n                }\n                if (CODEC_VALIDATION_ENABLED)\n                {\n                    final int checkEqualsPosition = buffer.scan(position, end, '=');\n                    if (checkEqualsPosition != AsciiBuffer.UNKNOWN_INDEX)\n                    {\n                        final int checkTag = buffer.getInt(position, checkEqualsPosition);\n                        if (%1$s.ALL_GROUP_FIELDS.contains(checkTag))\n                        {\n                            invalidTagId = tag;\n                            rejectReason = %6$s;\n                            while (%1$sCurrent != null) \n                            {\n                               position += %1$sCurrent.decode(buffer, position, end - position);\n                               %1$sCurrent = %1$sCurrent.next();\n                            }\n                            return position - offset;\n                        }\n                    }\n                }\n", JavaUtil.formatPropertyName((String)group.name()), DecoderGenerator.decoderClassName(group), groupNumberField, getNumberField, "messageFields", INCORRECT_NUMINGROUP_COUNT_FOR_REPEATING_GROUP);
        return this.decodeField(group.numberField(), parseGroup);
    }

    private String decodeField(Entry entry, String suffix) {
        Field field = (Field)entry.element();
        String name = entry.name();
        String fieldName = JavaUtil.formatPropertyName((String)name);
        return String.format("            case Constants.%s:\n%s%s%s%s%s                break;\n", GenerationUtil.constantName(name), this.optionalAssign(entry), this.fieldDecodeMethod(field, fieldName), this.storeOffsetForVariableLengthFields(field.type(), fieldName), this.storeLengthForVariableLengthFields(field.type(), fieldName), suffix);
    }

    private String storeLengthForVariableLengthFields(Field.Type type, String fieldName) {
        return type.hasLengthField(this.flyweightsEnabled) ? String.format("                %sLength = valueLength;\n", fieldName) : "";
    }

    private String storeOffsetForVariableLengthFields(Field.Type type, String fieldName) {
        return type.hasOffsetField(this.flyweightsEnabled) ? String.format("                %sOffset = valueOffset;\n", fieldName) : "";
    }

    private String optionalAssign(Entry entry) {
        return entry.required() ? "" : String.format("                has%s = true;\n", entry.name());
    }

    private String fieldDecodeMethod(Field field, String fieldName) {
        String decodeMethod;
        String prefix = String.format("                %s = ", fieldName);
        switch (field.type()) {
            case INT: 
            case NUMINGROUP: 
            case LENGTH: 
            case SEQNUM: 
            case DAYOFMONTH: {
                if (this.flyweightsEnabled) {
                    return "";
                }
                decodeMethod = String.format("getInt(buffer, valueOffset, endOfField, %d, CODEC_VALIDATION_ENABLED)", field.number());
                break;
            }
            case LONG: {
                if (this.flyweightsEnabled) {
                    return "";
                }
                decodeMethod = String.format("getLong(buffer, valueOffset, endOfField, %d, CODEC_VALIDATION_ENABLED)", field.number());
                break;
            }
            case FLOAT: 
            case PRICE: 
            case PRICEOFFSET: 
            case QTY: 
            case QUANTITY: 
            case PERCENTAGE: 
            case AMT: {
                if (this.flyweightsEnabled) {
                    return "";
                }
                decodeMethod = String.format("getFloat(buffer, %s, valueOffset, valueLength, %d, CODEC_VALIDATION_ENABLED)", fieldName, field.number());
                break;
            }
            case CHAR: {
                decodeMethod = "buffer.getChar(valueOffset)";
                break;
            }
            case STRING: 
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: 
            case MULTIPLECHARVALUE: 
            case CURRENCY: 
            case EXCHANGE: 
            case COUNTRY: 
            case LANGUAGE: {
                if (this.flyweightsEnabled) {
                    return "";
                }
                decodeMethod = String.format("buffer.getChars(%s, valueOffset, valueLength)", fieldName);
                break;
            }
            case BOOLEAN: {
                decodeMethod = "buffer.getBoolean(valueOffset)";
                break;
            }
            case DATA: 
            case XMLDATA: {
                String associatedFieldName = JavaUtil.formatPropertyName((String)field.associatedLengthField().name());
                if (this.flyweightsEnabled) {
                    return String.format("                endOfField = valueOffset + this.%1$s();\n", associatedFieldName);
                }
                return String.format("                %1$s = buffer.getBytes(%1$s, valueOffset, %2$s);\n                endOfField = valueOffset + %2$s;\n", fieldName, associatedFieldName);
            }
            case UTCTIMESTAMP: 
            case LOCALMKTDATE: 
            case UTCTIMEONLY: 
            case UTCDATEONLY: 
            case TZTIMEONLY: 
            case TZTIMESTAMP: 
            case MONTHYEAR: {
                if (this.flyweightsEnabled) {
                    return "";
                }
                decodeMethod = String.format("buffer.getBytes(%s, valueOffset, valueLength)", fieldName);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown type: " + String.valueOf((Object)field.type()) + " in " + fieldName);
            }
        }
        return prefix + decodeMethod + ";\n";
    }

    @Override
    protected String stringAppendTo(String fieldName) {
        return String.format("builder.append(this.%1$s(), 0, %1$sLength())", fieldName);
    }

    @Override
    protected String dataAppendTo(Field field, String fieldName) {
        String lengthName = JavaUtil.formatPropertyName((String)field.associatedLengthField().name());
        if (this.flyweightsEnabled) {
            return String.format("appendData(builder, this.%1$s(), this.%2$s())", fieldName, lengthName);
        }
        return String.format("appendData(builder, %1$s, %2$s)", fieldName, lengthName);
    }

    @Override
    protected String timeAppendTo(String fieldName) {
        if (this.flyweightsEnabled) {
            return String.format("appendData(builder, this.%1$s(), %1$sLength())", fieldName);
        }
        return String.format("appendData(builder, %1$s, %1$sLength)", fieldName);
    }

    @Override
    protected boolean hasFlag(Entry entry, Field field) {
        return !entry.required();
    }

    @Override
    protected String resetTemporalValue(String name) {
        return this.resetStringBasedData(name);
    }

    @Override
    protected String resetComponents(List<Entry> entries, StringBuilder methods) {
        return entries.stream().filter(Entry::isComponent).map(entry -> this.resetEntries(((Component)entry.element()).entries(), methods)).collect(Collectors.joining());
    }

    @Override
    protected String resetStringBasedData(String name) {
        return String.format("    public void %1$s()\n    {\n        %2$sOffset = 0;\n        %2$sLength = 0;\n    }\n\n", this.nameOfResetMethod(name), JavaUtil.formatPropertyName((String)name));
    }

    @Override
    protected String groupEntryAppendTo(Group group, String name) {
        if (this.isSharedParent()) {
            return "";
        }
        String numberField = group.numberField().name();
        return String.format("        if (has%2$s)\n        {\n            indent(builder, level);\n            builder.append(\"\\\"%1$s\\\": [\\n\");\n            %3$s %4$s = this.%4$s;\n            for (int i = 0, size = this.%5$s; i < size; i++)\n            {\n                indent(builder, level);\n                %4$s.appendTo(builder, level + 1);\n                if (%4$s.next() != null)\n                {\n                    builder.append(',');\n                }\n                builder.append('\\n');\n                %4$s = %4$s.next();            }\n            indent(builder, level);\n            builder.append(\"],\\n\");\n        }\n", name, numberField, DecoderGenerator.decoderClassName(name), JavaUtil.formatPropertyName((String)name), JavaUtil.formatPropertyName((String)numberField));
    }

    private String generateToEncoder(Aggregate aggregate) {
        String entriesToEncoder = aggregate.entries().stream().map(this::generateEntryToEncoder).collect(Collectors.joining("\n"));
        String name = aggregate.name();
        Object encoderClassName = EncoderGenerator.encoderClassName(name);
        if (aggregate instanceof Group) {
            encoderClassName = EncoderGenerator.encoderClassName(this.parentAggregate().name()) + "." + (String)encoderClassName;
        }
        return String.format("    public %1$s toEncoder(final Encoder encoder)\n    {\n        return toEncoder((%1$s)encoder);\n    }\n\n    public %1$s toEncoder(final %1$s encoder)\n    {\n        encoder.reset();\n%2$s        return encoder;\n    }\n\n", encoderClassName, entriesToEncoder);
    }

    private String generateEntryToEncoder(Entry entry) {
        return this.generateEntryToEncoder(entry, "encoder");
    }

    private String generateEntryToEncoder(Entry entry, String encoderName) {
        if (this.isBodyLength(entry)) {
            return "";
        }
        Entry.Element element = entry.element();
        String name = entry.name();
        if (element instanceof Field) {
            Field field = (Field)element;
            if (this.appendToChecksHasGetter(entry, field)) {
                return String.format("        if (has%1$s())\n        {\n%2$s\n        }\n", name, this.indentedFieldToEncoder(encoderName, field, "            "));
            }
            return this.indentedFieldToEncoder(encoderName, field, "        ");
        }
        if (element instanceof Group) {
            return this.groupEntryToEncoder((Group)element, name, encoderName);
        }
        if (element instanceof Component) {
            return this.componentToEncoder((Component)element, encoderName);
        }
        return "";
    }

    private String indentedFieldToEncoder(String encoderName, Field field, String replacement) {
        String fieldToEncoder = this.fieldToEncoder(field, encoderName);
        return NEWLINE.matcher(fieldToEncoder).replaceAll(replacement);
    }

    protected String groupEntryToEncoder(Group group, String name, String encoderName) {
        if (this.isSharedParent()) {
            return "";
        }
        String numberField = group.numberField().name();
        return String.format("        if (has%1$s)\n        {\n            final int size = this.%4$s;\n            %2$s %3$s = this.%3$s;\n            %6$s %3$sEncoder = %5$s.%3$s(size);\n            for (int i = 0; i < size; i++)\n            {\n                if (%3$s != null)\n                {\n                    %3$s.toEncoder(%3$sEncoder);\n                    %3$s = %3$s.next();\n                    %3$sEncoder = %3$sEncoder.next();\n                }\n            }\n        }\n", numberField, DecoderGenerator.decoderClassName(name), JavaUtil.formatPropertyName((String)name), JavaUtil.formatPropertyName((String)numberField), encoderName, EncoderGenerator.encoderClassName(name));
    }

    protected String componentToEncoder(Component component, String encoderName) {
        String name = component.name();
        String varName = JavaUtil.formatPropertyName((String)name);
        String prefix = String.format("\n        final %1$s %2$s = %3$s.%2$s();", EncoderGenerator.encoderClassName(name), varName, encoderName);
        return component.entries().stream().map(entry -> this.generateEntryToEncoder((Entry)entry, varName)).collect(Collectors.joining("\n", prefix, "\n"));
    }

    private String fieldToEncoder(Field field, String encoderName) {
        String fieldName = JavaUtil.formatPropertyName((String)field.name());
        switch (field.type()) {
            case STRING: 
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: 
            case MULTIPLECHARVALUE: 
            case CURRENCY: 
            case EXCHANGE: 
            case COUNTRY: 
            case LANGUAGE: {
                return String.format("%2$s.%1$s(this.%1$s(), 0, %1$sLength());", fieldName, encoderName);
            }
            case UTCTIMESTAMP: 
            case LOCALMKTDATE: 
            case UTCTIMEONLY: 
            case UTCDATEONLY: 
            case TZTIMEONLY: 
            case TZTIMESTAMP: 
            case MONTHYEAR: {
                return String.format("%2$s.%1$sAsCopy(this.%1$s(), 0, %1$sLength());", fieldName, encoderName);
            }
            case INT: 
            case LENGTH: 
            case SEQNUM: 
            case DAYOFMONTH: 
            case LONG: 
            case FLOAT: 
            case PRICE: 
            case PRICEOFFSET: 
            case QTY: 
            case QUANTITY: 
            case PERCENTAGE: 
            case AMT: 
            case BOOLEAN: 
            case CHAR: {
                return String.format("%2$s.%1$s(this.%1$s());", fieldName, encoderName);
            }
            case DATA: 
            case XMLDATA: {
                String lengthName = JavaUtil.formatPropertyName((String)field.associatedLengthField().name());
                return String.format("%3$s.%1$sAsCopy(this.%1$s(), 0, %2$s());%n%3$s.%2$s(this.%2$s());", fieldName, lengthName, encoderName);
            }
        }
        return "";
    }

    @Override
    protected String optionalReset(Field field, String name) {
        return this.resetByFlag(name);
    }

    @Override
    protected boolean appendToChecksHasGetter(Entry entry, Field field) {
        return this.hasFlag(entry, field);
    }

    @Override
    protected String anyFieldsAppendTo(AnyFields element) {
        return "";
    }

    @Override
    protected String resetAnyFields(List<Entry> entries, StringBuilder methods) {
        return "";
    }
}

