/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.builder;

import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;

public final class FieldBagEncoder {
    private final MutableDirectBuffer buffer;
    private int position;

    public FieldBagEncoder() {
        this(64);
    }

    FieldBagEncoder(int initialCapacity) {
        this.buffer = new ExpandableArrayBuffer(initialCapacity);
    }

    public void reset() {
        this.position = 0;
    }

    public boolean isEmpty() {
        return this.position == 0;
    }

    public void addIntField(int tag, int value) {
        this.beginField(tag);
        this.position += this.buffer.putIntAscii(this.position, value);
        this.endField();
    }

    public void addLongField(int tag, long value) {
        this.beginField(tag);
        this.position += this.buffer.putLongAscii(this.position, value);
        this.endField();
    }

    public void addAsciiCharField(int tag, char value) {
        this.beginField(tag);
        this.putAsciiChar(value);
        this.endField();
    }

    public void addAsciiStringField(int tag, CharSequence value) {
        this.beginField(tag);
        this.position += this.buffer.putStringWithoutLengthAscii(this.position, value);
        this.endField();
    }

    public int encode(MutableDirectBuffer dstBuffer, int dstOffset) {
        dstBuffer.putBytes(dstOffset, (DirectBuffer)this.buffer, 0, this.position);
        return this.position;
    }

    public void appendTo(StringBuilder builder) {
        CodecUtil.appendBuffer(builder, this.buffer, 0, this.position);
    }

    public void copyTo(FieldBagEncoder dst) {
        dst.position = this.position;
        dst.buffer.putBytes(0, (DirectBuffer)this.buffer, 0, this.position);
    }

    private void beginField(int tag) {
        this.position += this.buffer.putNaturalIntAscii(this.position, tag);
        this.putAsciiChar('=');
    }

    private void endField() {
        this.putAsciiChar('\u0001');
    }

    private void putAsciiChar(char value) {
        this.buffer.putByte(this.position++, (byte)value);
    }
}

