/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.util;

import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.EpochNanoClock;
import uk.co.real_logic.artio.fields.EpochFractionFormat;
import uk.co.real_logic.artio.util.EpochFractionClock;

public final class EpochFractionClocks {
    public static EpochFractionClock millisClock(EpochNanoClock clock) {
        return new MillisBasedClock(clock);
    }

    public static EpochFractionClock create(EpochClock clock, EpochNanoClock nanoClock, EpochFractionFormat format) {
        switch (format) {
            case NANOSECONDS: {
                return new NanoBasedClock(nanoClock);
            }
            case MICROSECONDS: {
                return new MicrosBasedClock(nanoClock);
            }
            case MILLISECONDS: {
                return new MillisBasedClock(nanoClock);
            }
        }
        throw new RuntimeException("Unknown precision: " + format);
    }

    static class MillisBasedClock
    implements EpochFractionClock {
        private final EpochNanoClock clock;

        MillisBasedClock(EpochNanoClock clock) {
            this.clock = clock;
        }

        @Override
        public long epochFractionTime() {
            return this.clock.nanoTime() / 1000000L;
        }

        @Override
        public EpochFractionFormat epochFractionPrecision() {
            return EpochFractionFormat.MILLISECONDS;
        }
    }

    static class NanoBasedClock
    implements EpochFractionClock {
        private final EpochNanoClock epochNanoClock;

        NanoBasedClock(EpochNanoClock epochNanoClock) {
            this.epochNanoClock = epochNanoClock;
        }

        @Override
        public long epochFractionTime() {
            return this.epochNanoClock.nanoTime();
        }

        @Override
        public EpochFractionFormat epochFractionPrecision() {
            return EpochFractionFormat.NANOSECONDS;
        }
    }

    static class MicrosBasedClock
    implements EpochFractionClock {
        private final EpochNanoClock epochNanoClock;

        MicrosBasedClock(EpochNanoClock epochNanoClock) {
            this.epochNanoClock = epochNanoClock;
        }

        @Override
        public long epochFractionTime() {
            return this.epochNanoClock.nanoTime() / 1000L;
        }

        @Override
        public EpochFractionFormat epochFractionPrecision() {
            return EpochFractionFormat.MICROSECONDS;
        }
    }
}

