/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.MetaAttribute;

public final class LibraryTimeoutDecoder {
    public static final int BLOCK_LENGTH = 12;
    public static final int TEMPLATE_ID = 40;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 26;
    public static final String SEMANTIC_VERSION = "0.2";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final LibraryTimeoutDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;
    private final SessionsDecoder sessions = new SessionsDecoder(this);

    public int sbeBlockLength() {
        return 12;
    }

    public int sbeTemplateId() {
        return 40;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 26;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public LibraryTimeoutDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public LibraryTimeoutDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (40 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public LibraryTimeoutDecoder sbeRewind() {
        return this.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int libraryIdId() {
        return 1;
    }

    public static int libraryIdSinceVersion() {
        return 0;
    }

    public static int libraryIdEncodingOffset() {
        return 0;
    }

    public static int libraryIdEncodingLength() {
        return 4;
    }

    public static String libraryIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int libraryIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int libraryIdMinValue() {
        return -2147483647;
    }

    public static int libraryIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int libraryId() {
        return this.buffer.getInt(this.offset + 0, BYTE_ORDER);
    }

    public static int connectCorrelationIdId() {
        return 2;
    }

    public static int connectCorrelationIdSinceVersion() {
        return 0;
    }

    public static int connectCorrelationIdEncodingOffset() {
        return 4;
    }

    public static int connectCorrelationIdEncodingLength() {
        return 8;
    }

    public static String connectCorrelationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long connectCorrelationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long connectCorrelationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long connectCorrelationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long connectCorrelationId() {
        return this.buffer.getLong(this.offset + 4, BYTE_ORDER);
    }

    public static long sessionsDecoderId() {
        return 3L;
    }

    public static int sessionsDecoderSinceVersion() {
        return 26;
    }

    public SessionsDecoder sessions() {
        if (this.parentMessage.actingVersion < 26) {
            this.sessions.count = 0;
            this.sessions.index = 0;
            return this.sessions;
        }
        this.sessions.wrap(this.buffer);
        return this.sessions;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        LibraryTimeoutDecoder decoder = new LibraryTimeoutDecoder();
        decoder.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[LibraryTimeout](sbeTemplateId=");
        builder.append(40);
        builder.append("|sbeSchemaId=");
        builder.append(666);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 26) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(26);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 12) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(12);
        builder.append("):");
        builder.append("libraryId=");
        builder.append(this.libraryId());
        builder.append('|');
        builder.append("connectCorrelationId=");
        builder.append(this.connectCorrelationId());
        builder.append('|');
        builder.append("sessions=[");
        int sessionsOriginalOffset = this.sessions.offset;
        int sessionsOriginalIndex = this.sessions.index;
        SessionsDecoder sessions = this.sessions();
        if (sessions.count() > 0) {
            while (sessions.hasNext()) {
                sessions.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        sessions.offset = sessionsOriginalOffset;
        sessions.index = sessionsOriginalIndex;
        builder.append(']');
        this.limit(originalLimit);
        return builder;
    }

    public LibraryTimeoutDecoder sbeSkip() {
        this.sbeRewind();
        SessionsDecoder sessions = this.sessions();
        if (sessions.count() > 0) {
            while (sessions.hasNext()) {
                sessions.next();
                sessions.sbeSkip();
            }
        }
        return this;
    }

    public static final class SessionsDecoder
    implements Iterable<SessionsDecoder>,
    Iterator<SessionsDecoder> {
        public static final int HEADER_SIZE = 3;
        private final LibraryTimeoutDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        SessionsDecoder(LibraryTimeoutDecoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(DirectBuffer buffer) {
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            this.blockLength = buffer.getShort(limit + 0, BYTE_ORDER) & 0xFFFF;
            this.count = (short)(buffer.getByte(limit + 2) & 0xFF);
        }

        @Override
        public SessionsDecoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 8;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int actingVersion() {
            return this.parentMessage.actingVersion;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<SessionsDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        public static int sessionIdId() {
            return 4;
        }

        public static int sessionIdSinceVersion() {
            return 0;
        }

        public static int sessionIdEncodingOffset() {
            return 0;
        }

        public static int sessionIdEncodingLength() {
            return 8;
        }

        public static String sessionIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long sessionIdNullValue() {
            return Long.MIN_VALUE;
        }

        public static long sessionIdMinValue() {
            return -9223372036854775807L;
        }

        public static long sessionIdMaxValue() {
            return Long.MAX_VALUE;
        }

        public long sessionId() {
            return this.buffer.getLong(this.offset + 0, BYTE_ORDER);
        }

        public StringBuilder appendTo(StringBuilder builder) {
            if (null == this.buffer) {
                return builder;
            }
            builder.append('(');
            builder.append("sessionId=");
            builder.append(this.sessionId());
            builder.append(')');
            return builder;
        }

        public SessionsDecoder sbeSkip() {
            return this;
        }
    }
}

