/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import uk.co.real_logic.artio.messages.LibraryExtendPositionDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.messages.MetaAttribute;

public final class LibraryExtendPositionEncoder {
    public static final int BLOCK_LENGTH = 36;
    public static final int TEMPLATE_ID = 60;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 26;
    public static final String SEMANTIC_VERSION = "0.2";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final LibraryExtendPositionEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 36;
    }

    public int sbeTemplateId() {
        return 60;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 26;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public LibraryExtendPositionEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 36);
        return this;
    }

    public LibraryExtendPositionEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(36).templateId(60).schemaId(666).version(26);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int libraryIdId() {
        return 1;
    }

    public static int libraryIdSinceVersion() {
        return 0;
    }

    public static int libraryIdEncodingOffset() {
        return 0;
    }

    public static int libraryIdEncodingLength() {
        return 4;
    }

    public static String libraryIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int libraryIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int libraryIdMinValue() {
        return -2147483647;
    }

    public static int libraryIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public LibraryExtendPositionEncoder libraryId(int value) {
        this.buffer.putInt(this.offset + 0, value, BYTE_ORDER);
        return this;
    }

    public static int correlationIdId() {
        return 2;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 4;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public LibraryExtendPositionEncoder correlationId(long value) {
        this.buffer.putLong(this.offset + 4, value, BYTE_ORDER);
        return this;
    }

    public static int sessionIdId() {
        return 3;
    }

    public static int sessionIdSinceVersion() {
        return 0;
    }

    public static int sessionIdEncodingOffset() {
        return 12;
    }

    public static int sessionIdEncodingLength() {
        return 4;
    }

    public static String sessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int sessionIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int sessionIdMinValue() {
        return -2147483647;
    }

    public static int sessionIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public LibraryExtendPositionEncoder sessionId(int value) {
        this.buffer.putInt(this.offset + 12, value, BYTE_ORDER);
        return this;
    }

    public static int stopPositionId() {
        return 4;
    }

    public static int stopPositionSinceVersion() {
        return 0;
    }

    public static int stopPositionEncodingOffset() {
        return 16;
    }

    public static int stopPositionEncodingLength() {
        return 8;
    }

    public static String stopPositionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long stopPositionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long stopPositionMinValue() {
        return -9223372036854775807L;
    }

    public static long stopPositionMaxValue() {
        return Long.MAX_VALUE;
    }

    public LibraryExtendPositionEncoder stopPosition(long value) {
        this.buffer.putLong(this.offset + 16, value, BYTE_ORDER);
        return this;
    }

    public static int initialTermIdId() {
        return 5;
    }

    public static int initialTermIdSinceVersion() {
        return 0;
    }

    public static int initialTermIdEncodingOffset() {
        return 24;
    }

    public static int initialTermIdEncodingLength() {
        return 4;
    }

    public static String initialTermIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int initialTermIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int initialTermIdMinValue() {
        return -2147483647;
    }

    public static int initialTermIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public LibraryExtendPositionEncoder initialTermId(int value) {
        this.buffer.putInt(this.offset + 24, value, BYTE_ORDER);
        return this;
    }

    public static int termBufferLengthId() {
        return 6;
    }

    public static int termBufferLengthSinceVersion() {
        return 0;
    }

    public static int termBufferLengthEncodingOffset() {
        return 28;
    }

    public static int termBufferLengthEncodingLength() {
        return 4;
    }

    public static String termBufferLengthMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int termBufferLengthNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int termBufferLengthMinValue() {
        return -2147483647;
    }

    public static int termBufferLengthMaxValue() {
        return Integer.MAX_VALUE;
    }

    public LibraryExtendPositionEncoder termBufferLength(int value) {
        this.buffer.putInt(this.offset + 28, value, BYTE_ORDER);
        return this;
    }

    public static int mtuLengthId() {
        return 7;
    }

    public static int mtuLengthSinceVersion() {
        return 0;
    }

    public static int mtuLengthEncodingOffset() {
        return 32;
    }

    public static int mtuLengthEncodingLength() {
        return 4;
    }

    public static String mtuLengthMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int mtuLengthNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int mtuLengthMinValue() {
        return -2147483647;
    }

    public static int mtuLengthMaxValue() {
        return Integer.MAX_VALUE;
    }

    public LibraryExtendPositionEncoder mtuLength(int value) {
        this.buffer.putInt(this.offset + 32, value, BYTE_ORDER);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        LibraryExtendPositionDecoder decoder = new LibraryExtendPositionDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset, 36, 26);
        return decoder.appendTo(builder);
    }
}

