/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.fixp;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class SimpleOpenFramingHeader {
    public static final int SOFH_MSG_SIZE_LENGTH = 2;
    public static final int SOFH_ENCODING_LENGTH = 2;
    public static final int SOFH_LENGTH = 4;
    public static final int SOFH_MSG_SIZE_OFFSET = 0;
    public static final int SOFH_ENCODING_OFFSET = 2;
    public static final short CME_ENCODING_TYPE = -13570;
    public static final short BINARY_ENTRYPOINT_TYPE = -5296;

    public static void writeILinkSofh(MutableDirectBuffer buffer, int offset, int messageSize) {
        SimpleOpenFramingHeader.writeSofh(buffer, offset, messageSize, (short)-13570);
    }

    public static void writeBinaryEntryPointSofh(MutableDirectBuffer buffer, int offset, int messageSize) {
        SimpleOpenFramingHeader.writeSofh(buffer, offset, messageSize, (short)-5296);
    }

    public static void writeSofh(MutableDirectBuffer buffer, int offset, int messageSize, short encodingType) {
        buffer.putShort(offset + 0, (short)messageSize, ByteOrder.LITTLE_ENDIAN);
        buffer.putShort(offset + 2, encodingType, ByteOrder.LITTLE_ENDIAN);
    }

    public static int readSofhMessageSize(DirectBuffer buffer, int offset) {
        return buffer.getShort(offset + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public static int readSofh(DirectBuffer buffer, int offset, short expectedEncodingType) {
        int messageSize = SimpleOpenFramingHeader.readSofhMessageSize(buffer, offset);
        short encodingType = buffer.getShort(offset + 2, ByteOrder.LITTLE_ENDIAN);
        if (encodingType != expectedEncodingType) {
            throw new IllegalArgumentException("Unsupported Encoding Type: " + encodingType + " should be " + expectedEncodingType);
        }
        return messageSize;
    }
}

