/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary.ir;

import uk.co.real_logic.artio.dictionary.ir.Field;

public enum BaseType {
    INT,
    LONG,
    FLOAT,
    CHAR,
    STRING,
    DATA,
    BOOLEAN,
    TIMESTAMP;


    public static Field.Type to(BaseType type) {
        switch (type) {
            case INT: {
                return Field.Type.INT;
            }
            case LONG: {
                return Field.Type.LONG;
            }
            case FLOAT: {
                return Field.Type.FLOAT;
            }
            case CHAR: {
                return Field.Type.CHAR;
            }
            case STRING: {
                return Field.Type.STRING;
            }
            case DATA: {
                return Field.Type.DATA;
            }
            case BOOLEAN: {
                return Field.Type.BOOLEAN;
            }
            case TIMESTAMP: {
                return Field.Type.UTCTIMESTAMP;
            }
        }
        throw new IllegalArgumentException("Unknown type: " + (Object)((Object)type));
    }

    public static BaseType from(Field.Type type) {
        switch (type) {
            case INT: 
            case LENGTH: 
            case SEQNUM: 
            case NUMINGROUP: 
            case DAYOFMONTH: {
                return INT;
            }
            case LONG: {
                return LONG;
            }
            case FLOAT: 
            case PRICE: 
            case PRICEOFFSET: 
            case QTY: 
            case QUANTITY: 
            case PERCENTAGE: 
            case AMT: {
                return FLOAT;
            }
            case CHAR: {
                return CHAR;
            }
            case MULTIPLECHARVALUE: 
            case STRING: 
            case MULTIPLEVALUESTRING: 
            case MULTIPLESTRINGVALUE: 
            case TENOR: 
            case CURRENCY: 
            case EXCHANGE: 
            case COUNTRY: 
            case LANGUAGE: {
                return STRING;
            }
            case DATA: 
            case XMLDATA: {
                return DATA;
            }
            case BOOLEAN: {
                return BOOLEAN;
            }
            case UTCTIMESTAMP: 
            case UTCTIMEONLY: 
            case UTCDATEONLY: 
            case LOCALMKTDATE: 
            case MONTHYEAR: 
            case TZTIMEONLY: 
            case TZTIMESTAMP: {
                return TIMESTAMP;
            }
        }
        throw new IllegalArgumentException("Unknown type: " + (Object)((Object)type));
    }
}

