/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.util.float_parsing;

import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.float_parsing.CharReader;

public final class AsciiBufferCharReader
implements CharReader<AsciiBuffer> {
    private static final byte SPACE = 32;
    private static final byte ZERO = 48;
    public static final AsciiBufferCharReader INSTANCE = new AsciiBufferCharReader();

    private AsciiBufferCharReader() {
    }

    @Override
    public boolean isSpace(AsciiBuffer data, int index) {
        return data.getByte(index) == 32;
    }

    @Override
    public char charAt(AsciiBuffer data, int index) {
        return (char)data.getByte(index);
    }

    @Override
    public CharSequence asString(AsciiBuffer data, int offset, int length) {
        return data.getAscii(offset, length);
    }

    @Override
    public boolean isZero(AsciiBuffer data, int index) {
        return data.getByte(index) == 48;
    }

    @Override
    public int getDigit(AsciiBuffer data, int index, char charValue) {
        if (charValue < '0' || charValue > '9') {
            throw new NumberFormatException("'" + charValue + "' isn't a valid digit @ " + index);
        }
        return charValue - 48;
    }
}

