/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import uk.co.real_logic.artio.messages.ErrorDecoder;
import uk.co.real_logic.artio.messages.GatewayError;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.messages.MetaAttribute;

public final class ErrorEncoder {
    public static final int BLOCK_LENGTH = 14;
    public static final int TEMPLATE_ID = 13;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 25;
    public static final String SEMANTIC_VERSION = "0.2";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ErrorEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 14;
    }

    public int sbeTemplateId() {
        return 13;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 25;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public ErrorEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 14);
        return this;
    }

    public ErrorEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(14).templateId(13).schemaId(666).version(25);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int errorTypeId() {
        return 1;
    }

    public static int errorTypeSinceVersion() {
        return 0;
    }

    public static int errorTypeEncodingOffset() {
        return 0;
    }

    public static int errorTypeEncodingLength() {
        return 2;
    }

    public static String errorTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public ErrorEncoder errorType(GatewayError value) {
        this.buffer.putShort(this.offset + 0, (short)value.value(), ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int libraryIdId() {
        return 2;
    }

    public static int libraryIdSinceVersion() {
        return 0;
    }

    public static int libraryIdEncodingOffset() {
        return 2;
    }

    public static int libraryIdEncodingLength() {
        return 4;
    }

    public static String libraryIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int libraryIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int libraryIdMinValue() {
        return -2147483647;
    }

    public static int libraryIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public ErrorEncoder libraryId(int value) {
        this.buffer.putInt(this.offset + 2, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int replyToIdId() {
        return 3;
    }

    public static int replyToIdSinceVersion() {
        return 0;
    }

    public static int replyToIdEncodingOffset() {
        return 6;
    }

    public static int replyToIdEncodingLength() {
        return 8;
    }

    public static String replyToIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long replyToIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long replyToIdMinValue() {
        return -9223372036854775807L;
    }

    public static long replyToIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public ErrorEncoder replyToId(long value) {
        this.buffer.putLong(this.offset + 6, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int messageId() {
        return 4;
    }

    public static String messageCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String messageMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int messageHeaderLength() {
        return 2;
    }

    public ErrorEncoder putMessage(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public ErrorEncoder putMessage(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public ErrorEncoder message(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        ErrorDecoder decoder = new ErrorDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.initialOffset, 14, 25);
        return decoder.appendTo(builder);
    }
}

