/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.MetaAttribute;
import uk.co.real_logic.artio.messages.SlowStatus;

public final class AllFixSessionsReplyDecoder {
    public static final int BLOCK_LENGTH = 8;
    public static final int TEMPLATE_ID = 63;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 20;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final AllFixSessionsReplyDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;
    private final SessionsDecoder sessions = new SessionsDecoder(this);

    public int sbeBlockLength() {
        return 8;
    }

    public int sbeTemplateId() {
        return 63;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 20;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public AllFixSessionsReplyDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public AllFixSessionsReplyDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (63 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public AllFixSessionsReplyDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int correlationIdId() {
        return 0;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 0;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long correlationId() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static long sessionsDecoderId() {
        return 7L;
    }

    public static int sessionsDecoderSinceVersion() {
        return 0;
    }

    public SessionsDecoder sessions() {
        this.sessions.wrap(this.buffer);
        return this.sessions;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        AllFixSessionsReplyDecoder decoder = new AllFixSessionsReplyDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[AllFixSessionsReply](sbeTemplateId=");
        builder.append(63);
        builder.append("|sbeSchemaId=");
        builder.append(666);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 20) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(20);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 8) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(8);
        builder.append("):");
        builder.append("correlationId=");
        builder.append(this.correlationId());
        builder.append('|');
        builder.append("sessions=[");
        SessionsDecoder sessions = this.sessions();
        if (sessions.count() > 0) {
            while (sessions.hasNext()) {
                sessions.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        this.limit(originalLimit);
        return builder;
    }

    public static final class SessionsDecoder
    implements Iterable<SessionsDecoder>,
    Iterator<SessionsDecoder> {
        public static final int HEADER_SIZE = 3;
        private final AllFixSessionsReplyDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        SessionsDecoder(AllFixSessionsReplyDecoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(DirectBuffer buffer) {
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            this.blockLength = buffer.getShort(limit + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.count = (short)(buffer.getByte(limit + 2) & 0xFF);
        }

        @Override
        public SessionsDecoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 37;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<SessionsDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        public static int sessionIdId() {
            return 1;
        }

        public static int sessionIdSinceVersion() {
            return 0;
        }

        public static int sessionIdEncodingOffset() {
            return 0;
        }

        public static int sessionIdEncodingLength() {
            return 8;
        }

        public static String sessionIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long sessionIdNullValue() {
            return Long.MIN_VALUE;
        }

        public static long sessionIdMinValue() {
            return -9223372036854775807L;
        }

        public static long sessionIdMaxValue() {
            return Long.MAX_VALUE;
        }

        public long sessionId() {
            return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
        }

        public static int connectionIdId() {
            return 2;
        }

        public static int connectionIdSinceVersion() {
            return 0;
        }

        public static int connectionIdEncodingOffset() {
            return 8;
        }

        public static int connectionIdEncodingLength() {
            return 8;
        }

        public static String connectionIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long connectionIdNullValue() {
            return Long.MIN_VALUE;
        }

        public static long connectionIdMinValue() {
            return -9223372036854775807L;
        }

        public static long connectionIdMaxValue() {
            return Long.MAX_VALUE;
        }

        public long connectionId() {
            return this.buffer.getLong(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
        }

        public static int lastReceivedSequenceNumberId() {
            return 3;
        }

        public static int lastReceivedSequenceNumberSinceVersion() {
            return 0;
        }

        public static int lastReceivedSequenceNumberEncodingOffset() {
            return 16;
        }

        public static int lastReceivedSequenceNumberEncodingLength() {
            return 4;
        }

        public static String lastReceivedSequenceNumberMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int lastReceivedSequenceNumberNullValue() {
            return Integer.MIN_VALUE;
        }

        public static int lastReceivedSequenceNumberMinValue() {
            return -2147483647;
        }

        public static int lastReceivedSequenceNumberMaxValue() {
            return Integer.MAX_VALUE;
        }

        public int lastReceivedSequenceNumber() {
            return this.buffer.getInt(this.offset + 16, ByteOrder.LITTLE_ENDIAN);
        }

        public static int lastSentSequenceNumberId() {
            return 4;
        }

        public static int lastSentSequenceNumberSinceVersion() {
            return 0;
        }

        public static int lastSentSequenceNumberEncodingOffset() {
            return 20;
        }

        public static int lastSentSequenceNumberEncodingLength() {
            return 4;
        }

        public static String lastSentSequenceNumberMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int lastSentSequenceNumberNullValue() {
            return Integer.MIN_VALUE;
        }

        public static int lastSentSequenceNumberMinValue() {
            return -2147483647;
        }

        public static int lastSentSequenceNumberMaxValue() {
            return Integer.MAX_VALUE;
        }

        public int lastSentSequenceNumber() {
            return this.buffer.getInt(this.offset + 20, ByteOrder.LITTLE_ENDIAN);
        }

        public static int lastLogonTimeId() {
            return 5;
        }

        public static int lastLogonTimeSinceVersion() {
            return 0;
        }

        public static int lastLogonTimeEncodingOffset() {
            return 24;
        }

        public static int lastLogonTimeEncodingLength() {
            return 8;
        }

        public static String lastLogonTimeMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long lastLogonTimeNullValue() {
            return Long.MIN_VALUE;
        }

        public static long lastLogonTimeMinValue() {
            return -9223372036854775807L;
        }

        public static long lastLogonTimeMaxValue() {
            return Long.MAX_VALUE;
        }

        public long lastLogonTime() {
            return this.buffer.getLong(this.offset + 24, ByteOrder.LITTLE_ENDIAN);
        }

        public static int sequenceIndexId() {
            return 6;
        }

        public static int sequenceIndexSinceVersion() {
            return 0;
        }

        public static int sequenceIndexEncodingOffset() {
            return 32;
        }

        public static int sequenceIndexEncodingLength() {
            return 4;
        }

        public static String sequenceIndexMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int sequenceIndexNullValue() {
            return Integer.MIN_VALUE;
        }

        public static int sequenceIndexMinValue() {
            return -2147483647;
        }

        public static int sequenceIndexMaxValue() {
            return Integer.MAX_VALUE;
        }

        public int sequenceIndex() {
            return this.buffer.getInt(this.offset + 32, ByteOrder.LITTLE_ENDIAN);
        }

        public static int slowStatusId() {
            return 15;
        }

        public static int slowStatusSinceVersion() {
            return 0;
        }

        public static int slowStatusEncodingOffset() {
            return 36;
        }

        public static int slowStatusEncodingLength() {
            return 1;
        }

        public static String slowStatusMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public short slowStatusRaw() {
            return (short)(this.buffer.getByte(this.offset + 36) & 0xFF);
        }

        public SlowStatus slowStatus() {
            return SlowStatus.get((short)(this.buffer.getByte(this.offset + 36) & 0xFF));
        }

        public static int addressId() {
            return 8;
        }

        public static int addressSinceVersion() {
            return 0;
        }

        public static String addressCharacterEncoding() {
            return "UTF-8";
        }

        public static String addressMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int addressHeaderLength() {
            return 2;
        }

        public int addressLength() {
            int limit = this.parentMessage.limit();
            return this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        }

        public int skipAddress() {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            int dataOffset = limit + 2;
            this.parentMessage.limit(dataOffset + dataLength);
            return dataLength;
        }

        public int getAddress(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 2 + dataLength);
            this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getAddress(byte[] dst, int dstOffset, int length) {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 2 + dataLength);
            this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public void wrapAddress(DirectBuffer wrapBuffer) {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.parentMessage.limit(limit + 2 + dataLength);
            wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
        }

        public String address() {
            String value;
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.parentMessage.limit(limit + 2 + dataLength);
            if (0 == dataLength) {
                return "";
            }
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
            try {
                value = new String(tmp, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            return value;
        }

        public static int localCompIdId() {
            return 9;
        }

        public static int localCompIdSinceVersion() {
            return 0;
        }

        public static String localCompIdCharacterEncoding() {
            return "UTF-8";
        }

        public static String localCompIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int localCompIdHeaderLength() {
            return 2;
        }

        public int localCompIdLength() {
            int limit = this.parentMessage.limit();
            return this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        }

        public int skipLocalCompId() {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            int dataOffset = limit + 2;
            this.parentMessage.limit(dataOffset + dataLength);
            return dataLength;
        }

        public int getLocalCompId(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 2 + dataLength);
            this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getLocalCompId(byte[] dst, int dstOffset, int length) {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 2 + dataLength);
            this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public void wrapLocalCompId(DirectBuffer wrapBuffer) {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.parentMessage.limit(limit + 2 + dataLength);
            wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
        }

        public String localCompId() {
            String value;
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.parentMessage.limit(limit + 2 + dataLength);
            if (0 == dataLength) {
                return "";
            }
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
            try {
                value = new String(tmp, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            return value;
        }

        public static int localSubIdId() {
            return 10;
        }

        public static int localSubIdSinceVersion() {
            return 0;
        }

        public static String localSubIdCharacterEncoding() {
            return "UTF-8";
        }

        public static String localSubIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int localSubIdHeaderLength() {
            return 2;
        }

        public int localSubIdLength() {
            int limit = this.parentMessage.limit();
            return this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        }

        public int skipLocalSubId() {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            int dataOffset = limit + 2;
            this.parentMessage.limit(dataOffset + dataLength);
            return dataLength;
        }

        public int getLocalSubId(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 2 + dataLength);
            this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getLocalSubId(byte[] dst, int dstOffset, int length) {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 2 + dataLength);
            this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public void wrapLocalSubId(DirectBuffer wrapBuffer) {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.parentMessage.limit(limit + 2 + dataLength);
            wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
        }

        public String localSubId() {
            String value;
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.parentMessage.limit(limit + 2 + dataLength);
            if (0 == dataLength) {
                return "";
            }
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
            try {
                value = new String(tmp, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            return value;
        }

        public static int localLocationIdId() {
            return 11;
        }

        public static int localLocationIdSinceVersion() {
            return 0;
        }

        public static String localLocationIdCharacterEncoding() {
            return "UTF-8";
        }

        public static String localLocationIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int localLocationIdHeaderLength() {
            return 2;
        }

        public int localLocationIdLength() {
            int limit = this.parentMessage.limit();
            return this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        }

        public int skipLocalLocationId() {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            int dataOffset = limit + 2;
            this.parentMessage.limit(dataOffset + dataLength);
            return dataLength;
        }

        public int getLocalLocationId(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 2 + dataLength);
            this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getLocalLocationId(byte[] dst, int dstOffset, int length) {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 2 + dataLength);
            this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public void wrapLocalLocationId(DirectBuffer wrapBuffer) {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.parentMessage.limit(limit + 2 + dataLength);
            wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
        }

        public String localLocationId() {
            String value;
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.parentMessage.limit(limit + 2 + dataLength);
            if (0 == dataLength) {
                return "";
            }
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
            try {
                value = new String(tmp, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            return value;
        }

        public static int remoteCompIdId() {
            return 12;
        }

        public static int remoteCompIdSinceVersion() {
            return 0;
        }

        public static String remoteCompIdCharacterEncoding() {
            return "UTF-8";
        }

        public static String remoteCompIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int remoteCompIdHeaderLength() {
            return 2;
        }

        public int remoteCompIdLength() {
            int limit = this.parentMessage.limit();
            return this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        }

        public int skipRemoteCompId() {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            int dataOffset = limit + 2;
            this.parentMessage.limit(dataOffset + dataLength);
            return dataLength;
        }

        public int getRemoteCompId(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 2 + dataLength);
            this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getRemoteCompId(byte[] dst, int dstOffset, int length) {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 2 + dataLength);
            this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public void wrapRemoteCompId(DirectBuffer wrapBuffer) {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.parentMessage.limit(limit + 2 + dataLength);
            wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
        }

        public String remoteCompId() {
            String value;
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.parentMessage.limit(limit + 2 + dataLength);
            if (0 == dataLength) {
                return "";
            }
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
            try {
                value = new String(tmp, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            return value;
        }

        public static int remoteSubIdId() {
            return 13;
        }

        public static int remoteSubIdSinceVersion() {
            return 0;
        }

        public static String remoteSubIdCharacterEncoding() {
            return "UTF-8";
        }

        public static String remoteSubIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int remoteSubIdHeaderLength() {
            return 2;
        }

        public int remoteSubIdLength() {
            int limit = this.parentMessage.limit();
            return this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        }

        public int skipRemoteSubId() {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            int dataOffset = limit + 2;
            this.parentMessage.limit(dataOffset + dataLength);
            return dataLength;
        }

        public int getRemoteSubId(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 2 + dataLength);
            this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getRemoteSubId(byte[] dst, int dstOffset, int length) {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 2 + dataLength);
            this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public void wrapRemoteSubId(DirectBuffer wrapBuffer) {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.parentMessage.limit(limit + 2 + dataLength);
            wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
        }

        public String remoteSubId() {
            String value;
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.parentMessage.limit(limit + 2 + dataLength);
            if (0 == dataLength) {
                return "";
            }
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
            try {
                value = new String(tmp, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            return value;
        }

        public static int remoteLocationIdId() {
            return 14;
        }

        public static int remoteLocationIdSinceVersion() {
            return 0;
        }

        public static String remoteLocationIdCharacterEncoding() {
            return "UTF-8";
        }

        public static String remoteLocationIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int remoteLocationIdHeaderLength() {
            return 2;
        }

        public int remoteLocationIdLength() {
            int limit = this.parentMessage.limit();
            return this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        }

        public int skipRemoteLocationId() {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            int dataOffset = limit + 2;
            this.parentMessage.limit(dataOffset + dataLength);
            return dataLength;
        }

        public int getRemoteLocationId(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 2 + dataLength);
            this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getRemoteLocationId(byte[] dst, int dstOffset, int length) {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 2 + dataLength);
            this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public void wrapRemoteLocationId(DirectBuffer wrapBuffer) {
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.parentMessage.limit(limit + 2 + dataLength);
            wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
        }

        public String remoteLocationId() {
            String value;
            int headerLength = 2;
            int limit = this.parentMessage.limit();
            int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.parentMessage.limit(limit + 2 + dataLength);
            if (0 == dataLength) {
                return "";
            }
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
            try {
                value = new String(tmp, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            return value;
        }

        public StringBuilder appendTo(StringBuilder builder) {
            if (null == this.buffer) {
                return builder;
            }
            builder.append('(');
            builder.append("sessionId=");
            builder.append(this.sessionId());
            builder.append('|');
            builder.append("connectionId=");
            builder.append(this.connectionId());
            builder.append('|');
            builder.append("lastReceivedSequenceNumber=");
            builder.append(this.lastReceivedSequenceNumber());
            builder.append('|');
            builder.append("lastSentSequenceNumber=");
            builder.append(this.lastSentSequenceNumber());
            builder.append('|');
            builder.append("lastLogonTime=");
            builder.append(this.lastLogonTime());
            builder.append('|');
            builder.append("sequenceIndex=");
            builder.append(this.sequenceIndex());
            builder.append('|');
            builder.append("slowStatus=");
            builder.append((Object)this.slowStatus());
            builder.append('|');
            builder.append("address=");
            builder.append('\'').append(this.address()).append('\'');
            builder.append('|');
            builder.append("localCompId=");
            builder.append('\'').append(this.localCompId()).append('\'');
            builder.append('|');
            builder.append("localSubId=");
            builder.append('\'').append(this.localSubId()).append('\'');
            builder.append('|');
            builder.append("localLocationId=");
            builder.append('\'').append(this.localLocationId()).append('\'');
            builder.append('|');
            builder.append("remoteCompId=");
            builder.append('\'').append(this.remoteCompId()).append('\'');
            builder.append('|');
            builder.append("remoteSubId=");
            builder.append('\'').append(this.remoteSubId()).append('\'');
            builder.append('|');
            builder.append("remoteLocationId=");
            builder.append('\'').append(this.remoteLocationId()).append('\'');
            builder.append(')');
            return builder;
        }
    }
}

