/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.builder;

import uk.co.real_logic.artio.fields.DecimalFloat;
import uk.co.real_logic.artio.util.AsciiBuffer;

public abstract class CommonDecoderImpl {
    public static final int INCORRECT_DATA_FORMAT_FOR_VALUE = 6;
    protected int invalidTagId = -1;
    protected int rejectReason = -1;
    protected AsciiBuffer buffer;

    public int invalidTagId() {
        return this.invalidTagId;
    }

    public int rejectReason() {
        return this.rejectReason;
    }

    public int getInt(AsciiBuffer buffer, int startInclusive, int endExclusive, int tag, boolean validation) {
        try {
            return buffer.getInt(startInclusive, endExclusive);
        }
        catch (NumberFormatException e) {
            if (validation) {
                this.invalidTagId = tag;
                this.rejectReason = 6;
            }
            return Integer.MIN_VALUE;
        }
    }

    public DecimalFloat getFloat(AsciiBuffer buffer, DecimalFloat number, int offset, int length, int tag, boolean validation) {
        try {
            return buffer.getFloat(number, offset, length);
        }
        catch (NumberFormatException e) {
            if (validation) {
                this.invalidTagId = tag;
                this.rejectReason = 6;
                return number;
            }
            return DecimalFloat.MISSING_FLOAT;
        }
    }

    public int getIntFlyweight(AsciiBuffer buffer, int offset, int length, int tag, boolean validation) {
        try {
            return buffer.parseIntAscii(offset, length);
        }
        catch (NumberFormatException e) {
            if (validation) {
                throw new NumberFormatException(e.getMessage() + " tag=" + tag);
            }
            return Integer.MIN_VALUE;
        }
    }

    public int groupNoField(AsciiBuffer buffer, int oldValue, boolean hasField, int offset, int length, int tag, boolean validation) {
        if (!hasField || buffer == null) {
            return 0;
        }
        if (oldValue != Integer.MIN_VALUE) {
            return oldValue;
        }
        return this.getIntFlyweight(buffer, offset, length, tag, validation);
    }

    public DecimalFloat getFloatFlyweight(AsciiBuffer buffer, DecimalFloat number, int offset, int length, int tag, boolean codecValidationEnabled) {
        try {
            return buffer.getFloat(number, offset, length);
        }
        catch (NumberFormatException e) {
            if (codecValidationEnabled) {
                throw new NumberFormatException(e.getMessage() + " tag=" + tag);
            }
            return DecimalFloat.MISSING_FLOAT;
        }
    }
}

