/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.fixp;

import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import org.agrona.DirectBuffer;
import org.agrona.LangUtil;
import org.agrona.MutableDirectBuffer;
import uk.co.real_logic.sbe.ir.Ir;
import uk.co.real_logic.sbe.ir.IrDecoder;
import uk.co.real_logic.sbe.ir.Token;

public abstract class AbstractFixPOffsets {
    public static final int MISSING_OFFSET = -1;
    public static final int NORMAL_CLIENT_MSG_SEQ_NUM_OFFSET = 17;
    public static final int PARTY_DETAILS_LIST_REQUEST_SEQ_NUM_OFFSET = 16;
    public static final int EXCHANGE_MSG_SEQ_NUM_OFFSET = 0;
    public static final int MINIMUM_BUSINESS_MSG_TEMPLATE_ID = 514;
    public static final int PARTY_DETAILS_LIST_REQUEST_ID = 537;
    public static final int TEMPLATE_ID_OFFSET = 2;

    public static long clientSeqNum(DirectBuffer buffer, int sbeHeaderOffset) {
        int templateId = buffer.getShort(sbeHeaderOffset + 2, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        if (templateId < 514) {
            return -1L;
        }
        int messageOffset = sbeHeaderOffset + 8;
        int fieldOffset = AbstractFixPOffsets.clientSeqNumOffset(templateId);
        return AbstractFixPOffsets.seqNum(buffer, messageOffset + fieldOffset);
    }

    public static void clientSeqNum(int templateId, MutableDirectBuffer buffer, int messageOffset, long seqNum) {
        int fieldOffset = AbstractFixPOffsets.clientSeqNumOffset(templateId);
        AbstractFixPOffsets.seqNum(buffer, messageOffset + fieldOffset, seqNum);
    }

    private static int clientSeqNumOffset(int templateId) {
        return templateId == 537 ? 16 : 17;
    }

    public static long exchangeSeqNum(DirectBuffer buffer, int messageOffset) {
        return AbstractFixPOffsets.seqNum(buffer, messageOffset + 0);
    }

    private static long seqNum(DirectBuffer buffer, int index) {
        return (long)buffer.getInt(index, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
    }

    private static void seqNum(MutableDirectBuffer buffer, int index, long seqNum) {
        buffer.putInt(index, (int)seqNum, ByteOrder.LITTLE_ENDIAN);
    }

    public abstract int seqNumOffset(int var1);

    public abstract int seqNum(int var1, DirectBuffer var2, int var3);

    public abstract int possRetransOffset(int var1);

    public abstract int possRetrans(int var1, DirectBuffer var2, int var3);

    public abstract int sendingTimeEpochOffset(int var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Ir loadSbeIr(Class<?> encoder, String fileName) {
        try {
            InputStream stream = encoder.getResourceAsStream(fileName);
            if (stream == null) {
                URL resource = encoder.getResource(".");
                String encoderDir = resource == null ? "unknown" : resource.toURI().getPath();
                throw new IllegalStateException("Unable to find SBE IR: " + fileName + " associated with resource: " + encoder + " @ " + encoderDir);
            }
            int length = stream.available();
            byte[] bytes = new byte[length];
            for (int remaining = length; remaining > 0; remaining -= stream.read(bytes, length - remaining, remaining)) {
            }
            try (IrDecoder irDecoder = new IrDecoder(ByteBuffer.wrap(bytes));){
                Ir ir = irDecoder.decode();
                return ir;
            }
        }
        catch (Exception e) {
            LangUtil.rethrowUnchecked((Throwable)e);
            return null;
        }
    }

    public static int templateId(List<Token> messageTokens) {
        Token beginMessage = messageTokens.get(0);
        return beginMessage.id();
    }
}

