/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.binary_entrypoint;

import b3.entrypoint.fixp.sbe.CancelOnDisconnectType;
import b3.entrypoint.fixp.sbe.TerminationCode;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.EpochNanoClock;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.binary_entrypoint.BinaryEntryPointProxy;
import uk.co.real_logic.artio.binary_entrypoint.BinaryEntrypointConnection;
import uk.co.real_logic.artio.fixp.AbstractFixPProxy;
import uk.co.real_logic.artio.fixp.FixPConnection;
import uk.co.real_logic.artio.library.FixPSessionOwner;
import uk.co.real_logic.artio.library.InternalFixPConnection;
import uk.co.real_logic.artio.protocol.GatewayPublication;

class InternalBinaryEntrypointConnection
extends InternalFixPConnection
implements BinaryEntrypointConnection {
    private final BinaryEntryPointProxy proxy;
    private TerminationCode resendTerminationCode;
    private long sessionId;
    private long sessionVerId;
    private CancelOnDisconnectType cancelOnDisconnectType;
    private long codTimeoutWindow;

    InternalBinaryEntrypointConnection(long connectionId, GatewayPublication outboundPublication, GatewayPublication inboundPublication, int libraryId, FixPSessionOwner owner, long lastReceivedSequenceNumber, long lastSentSequenceNumber, long lastConnectPayload, EpochNanoClock clock) {
        super(connectionId, outboundPublication, inboundPublication, libraryId, clock, owner, (AbstractFixPProxy)new BinaryEntryPointProxy(connectionId, outboundPublication.dataPublication()));
        this.proxy = (BinaryEntryPointProxy)((InternalFixPConnection)this).proxy;
        this.state(FixPConnection.State.ACCEPTED);
    }

    @Override
    public long sessionId() {
        return this.sessionId;
    }

    @Override
    public long sessionVerId() {
        return this.sessionVerId;
    }

    @Override
    public long terminate(TerminationCode terminationCode) {
        this.validateCanSend();
        return this.sendTerminate(terminationCode, FixPConnection.State.UNBINDING, FixPConnection.State.RESEND_TERMINATE);
    }

    public long trySendSequence() {
        return 0L;
    }

    public long tryRetransmitRequest(long uuid, long fromSeqNo, int msgCount) {
        return 0L;
    }

    public long nextSentSeqNo() {
        return 0L;
    }

    public void nextSentSeqNo(long nextSentSeqNo) {
    }

    public long nextRecvSeqNo() {
        return 0L;
    }

    public void nextRecvSeqNo(long nextRecvSeqNo) {
    }

    public long retransmitFillSeqNo() {
        return 0L;
    }

    public long nextRetransmitSeqNo() {
        return 0L;
    }

    protected int poll(long timeInMs) {
        return 0;
    }

    protected void onReplayComplete() {
    }

    public long onNegotiate(long sessionId, long sessionVerID, long timestamp, long enteringFirm, long onbehalfFirm, String senderLocation) {
        FixPConnection.State state = this.state();
        if (state == FixPConnection.State.ACCEPTED || state != FixPConnection.State.SENT_NEGOTIATE_RESPONSE) {
            // empty if block
        }
        this.sessionId = sessionId;
        this.sessionVerId = sessionVerID;
        long position = this.proxy.sendNegotiateResponse(sessionId, sessionVerID, timestamp, enteringFirm);
        return this.checkState(position, FixPConnection.State.SENT_NEGOTIATE_RESPONSE, FixPConnection.State.RETRY_NEGOTIATE_RESPONSE);
    }

    private long checkState(long position, FixPConnection.State success, FixPConnection.State backPressured) {
        if (position > 0L) {
            this.state(success);
        } else {
            this.state(backPressured);
        }
        return position;
    }

    public long onEstablish(long sessionID, long sessionVerID, long timestamp, long keepAliveInterval, long nextSeqNo, CancelOnDisconnectType cancelOnDisconnectType, long codTimeoutWindow) {
        this.checkSession(sessionID, sessionVerID);
        FixPConnection.State state = this.state();
        if (state != FixPConnection.State.SENT_NEGOTIATE_RESPONSE) {
            // empty if block
        }
        this.cancelOnDisconnectType = cancelOnDisconnectType;
        this.codTimeoutWindow = codTimeoutWindow;
        long position = this.proxy.sendEstablishAck(sessionID, sessionVerID, timestamp, keepAliveInterval, 1L, 0L);
        return this.checkState(position, FixPConnection.State.ESTABLISHED, FixPConnection.State.RETRY_ESTABLISH_ACK);
    }

    public long onTerminate(long sessionID, long sessionVerID, TerminationCode terminationCode) {
        if (this.state == FixPConnection.State.UNBINDING) {
            this.fullyUnbind();
        } else {
            DebugLogger.log((LogTag)LogTag.FIXP_SESSION, (String)"Terminated: ", (String)terminationCode.name());
            this.sendTerminateAck(terminationCode);
        }
        this.checkSession(sessionID, sessionVerID);
        return 1L;
    }

    private void checkSession(long sessionID, long sessionVerID) {
    }

    private void sendTerminateAck(TerminationCode terminationCode) {
        long position = this.sendTerminate(terminationCode, FixPConnection.State.UNBOUND, FixPConnection.State.RESEND_TERMINATE_ACK);
        if (position > 0L) {
            this.fullyUnbind();
        }
    }

    private long sendTerminate(TerminationCode terminationCode, FixPConnection.State finalState, FixPConnection.State resendState) {
        long position = this.proxy.sendTerminate(this.sessionId, this.sessionVerId, terminationCode, this.requestTimestampInNs());
        if (position > 0L) {
            this.state = finalState;
            this.resendTerminationCode = null;
        } else {
            this.state = resendState;
            this.resendTerminationCode = terminationCode;
        }
        return position;
    }

    public long onSequence(long nextSeqNo) {
        return 0L;
    }

    public long onMessage(DirectBuffer buffer, int offset, int templateId, int blockLength, int version, int sofhMessageSize) {
        this.handler.onBusinessMessage((FixPConnection)this, templateId, buffer, offset, blockLength, version, false);
        return 1L;
    }
}

