/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.binary_entrypoint;

import b3.entrypoint.fixp.sbe.EstablishAckEncoder;
import b3.entrypoint.fixp.sbe.EstablishRejectCode;
import b3.entrypoint.fixp.sbe.EstablishRejectEncoder;
import b3.entrypoint.fixp.sbe.MessageHeaderEncoder;
import b3.entrypoint.fixp.sbe.NegotiateRejectEncoder;
import b3.entrypoint.fixp.sbe.NegotiateResponseEncoder;
import b3.entrypoint.fixp.sbe.NegotiationRejectCode;
import b3.entrypoint.fixp.sbe.SequenceEncoder;
import b3.entrypoint.fixp.sbe.TerminateEncoder;
import b3.entrypoint.fixp.sbe.TerminationCode;
import io.aeron.ExclusivePublication;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageEncoderFlyweight;
import uk.co.real_logic.artio.fixp.AbstractFixPProxy;

public class BinaryEntryPointProxy
extends AbstractFixPProxy {
    public static final int BINARY_ENTRYPOINT_HEADER_LENGTH = 12;
    private static final int BINARY_ENTRYPOINT_MESSAGE_HEADER = 36;
    private final MessageHeaderEncoder beMessageHeader = new MessageHeaderEncoder();
    private final NegotiateResponseEncoder negotiateResponse = new NegotiateResponseEncoder();
    private final NegotiateRejectEncoder negotiateReject = new NegotiateRejectEncoder();
    private final EstablishAckEncoder establishAck = new EstablishAckEncoder();
    private final EstablishRejectEncoder establishReject = new EstablishRejectEncoder();
    private final SequenceEncoder sequence = new SequenceEncoder();
    private final TerminateEncoder terminate = new TerminateEncoder();

    public BinaryEntryPointProxy(long connectionId, ExclusivePublication publication) {
        super(connectionId, publication);
    }

    public long sendSequence(long uuid, long nextSentSeqNo) {
        return 0L;
    }

    public long sendNegotiateResponse(long sessionID, long sessionVerID, long requestTimestamp, long enteringFirm) {
        NegotiateResponseEncoder negotiateResponse = this.negotiateResponse;
        long position = this.claimMessage(24, (MessageEncoderFlyweight)negotiateResponse, requestTimestamp);
        if (position < 0L) {
            return position;
        }
        negotiateResponse.sessionID(sessionID).sessionVerID(sessionVerID).requestTimestamp().time(requestTimestamp);
        negotiateResponse.enteringFirm(enteringFirm);
        this.commit();
        return position;
    }

    public long sendNegotiateReject(long sessionID, long sessionVerID, long requestTimestamp, long enteringFirm, NegotiationRejectCode negotiationRejectCode) {
        NegotiateRejectEncoder negotiateReject = this.negotiateReject;
        long position = this.claimMessage(25, (MessageEncoderFlyweight)negotiateReject, requestTimestamp);
        if (position < 0L) {
            return position;
        }
        negotiateReject.sessionID(sessionID).sessionVerID(sessionVerID).requestTimestamp().time(requestTimestamp);
        negotiateReject.enteringFirm(enteringFirm).negotiationRejectCode(negotiationRejectCode);
        this.commit();
        return position;
    }

    public long sendEstablishAck(long sessionID, long sessionVerID, long requestTimestamp, long keepAliveInterval, long nextSeqNo, long lastIncomingSeqNo) {
        EstablishAckEncoder establishAck = this.establishAck;
        long position = this.claimMessage(36, (MessageEncoderFlyweight)establishAck, requestTimestamp);
        if (position < 0L) {
            return position;
        }
        establishAck.sessionID(sessionID).sessionVerID(sessionVerID).requestTimestamp().time(requestTimestamp);
        establishAck.keepAliveInterval().time(keepAliveInterval);
        establishAck.nextSeqNo(nextSeqNo).lastIncomingSeqNo(lastIncomingSeqNo);
        this.commit();
        return position;
    }

    public long sendEstablishReject(long sessionID, long sessionVerID, long requestTimestamp, EstablishRejectCode establishmentRejectCode) {
        EstablishRejectEncoder establishReject = this.establishReject;
        long position = this.claimMessage(21, (MessageEncoderFlyweight)establishReject, requestTimestamp);
        if (position < 0L) {
            return position;
        }
        establishReject.sessionID(sessionID).sessionVerID(sessionVerID).requestTimestamp().time(requestTimestamp);
        establishReject.establishmentRejectCode(establishmentRejectCode);
        this.commit();
        return position;
    }

    public long claimMessage(int messageLength, MessageEncoderFlyweight message, long timestampInNs) {
        return this.claimMessage(messageLength, message, timestampInNs, 36, 12, (short)-5296);
    }

    protected int applyHeader(MessageEncoderFlyweight message, MutableDirectBuffer buffer, int offset) {
        this.beMessageHeader.wrap(buffer, offset).blockLength(message.sbeBlockLength()).templateId(message.sbeTemplateId()).schemaId(message.sbeSchemaId()).version(message.sbeSchemaVersion());
        return offset + this.beMessageHeader.encodedLength();
    }

    public long sendTerminate(long sessionId, long sessionVerId, TerminationCode terminationCode, long timestampInNs) {
        TerminateEncoder terminate = this.terminate;
        long position = this.claimMessage(13, (MessageEncoderFlyweight)terminate, timestampInNs);
        if (position < 0L) {
            return position;
        }
        terminate.sessionID(sessionId).sessionVerID(sessionVerId).terminationCode(terminationCode);
        this.commit();
        return position;
    }
}

