/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.binary_entrypoint;

import java.nio.ByteOrder;
import org.agrona.concurrent.AtomicBuffer;
import uk.co.real_logic.artio.binary_entrypoint.BinaryEntryPointContext;
import uk.co.real_logic.artio.fixp.AbstractFixPStorage;
import uk.co.real_logic.artio.fixp.FixPContext;
import uk.co.real_logic.artio.fixp.FixPKey;

public class BinaryEntryPointStorage
extends AbstractFixPStorage {
    private static final short SHORT_TRUE = 1;
    private static final short SHORT_FALSE = 0;
    private static final int SESSION_ID_OFFSET = 0;
    private static final int SESSION_ID_LENGTH = 8;
    private static final int SESSION_VER_ID_OFFSET = 8;
    private static final int SESSION_VER_ID_LENGTH = 8;
    private static final int TIMESTAMP_OFFSET = 16;
    private static final int TIMESTAMP_LENGTH = 8;
    private static final int ENTERING_FIRM_OFFSET = 24;
    private static final int ENTERING_FIRM_LENGTH = 8;
    private static final int ENDED_OFFSET = 32;
    private static final int ENDED_LENGTH = 2;
    private static final int FROM_NEGOTIATE_OFFSET = 34;
    private static final int FROM_NEGOTIATE_LENGTH = 2;
    private static final int ENTRY_LENGTH = 36;

    public BinaryEntryPointContext newInitiatorContext(FixPKey key, int offset) {
        throw new UnsupportedOperationException();
    }

    public BinaryEntryPointContext loadContext(AtomicBuffer buffer, int offset, int fileVersion) {
        long sessionId = buffer.getLong(offset + 0);
        long sessionVerId = buffer.getLong(offset + 8);
        long timestamp = buffer.getLong(offset + 16);
        long enteringFirm = buffer.getLong(offset + 24);
        boolean ended = buffer.getShort(offset + 32) == 1;
        boolean fromNegotiate = buffer.getShort(offset + 34) == 1;
        BinaryEntryPointContext context = new BinaryEntryPointContext(sessionId, sessionVerId, timestamp, enteringFirm, fromNegotiate, "");
        context.ended(ended);
        context.offset(offset);
        return context;
    }

    public int saveContext(FixPContext fixPContext, AtomicBuffer buffer, int offset, int fileVersion) {
        BinaryEntryPointContext context = (BinaryEntryPointContext)fixPContext;
        context.offset(offset);
        buffer.putLong(offset + 0, context.sessionID(), ByteOrder.LITTLE_ENDIAN);
        this.putSessionVerId(buffer, context, offset);
        this.putTimestamp(buffer, context, offset);
        buffer.putLong(offset + 24, context.enteringFirm(), ByteOrder.LITTLE_ENDIAN);
        this.putEnded(buffer, context, offset + 32);
        this.putShort(buffer, offset + 34, context.fromNegotiate());
        return 36;
    }

    public void updateContext(FixPContext fixPContext, AtomicBuffer buffer) {
        BinaryEntryPointContext context = (BinaryEntryPointContext)fixPContext;
        int offset = context.offset();
        this.putSessionVerId(buffer, context, offset);
        this.putTimestamp(buffer, context, offset);
        this.putEnded(buffer, context, offset + 32);
    }

    private void putEnded(AtomicBuffer buffer, BinaryEntryPointContext context, int offset) {
        this.putShort(buffer, offset, context.ended());
    }

    private void putShort(AtomicBuffer buffer, int offset, boolean value) {
        buffer.putShort(offset, value ? (short)1 : 0, ByteOrder.LITTLE_ENDIAN);
    }

    private void putTimestamp(AtomicBuffer buffer, BinaryEntryPointContext context, int offset) {
        buffer.putLong(offset + 16, context.requestTimestampInNs(), ByteOrder.LITTLE_ENDIAN);
    }

    private void putSessionVerId(AtomicBuffer buffer, BinaryEntryPointContext context, int offset) {
        buffer.putLong(offset + 8, context.sessionVerID(), ByteOrder.LITTLE_ENDIAN);
    }
}

