/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.binary_entrypoint;

import b3.entrypoint.fixp.sbe.CancelOnDisconnectType;
import b3.entrypoint.fixp.sbe.DeltaInMillisDecoder;
import b3.entrypoint.fixp.sbe.EstablishRejectCode;
import b3.entrypoint.fixp.sbe.MessageType;
import b3.entrypoint.fixp.sbe.RetransmitRejectCode;
import b3.entrypoint.fixp.sbe.TerminationCode;
import io.aeron.logbuffer.ControlledFragmentHandler;
import java.nio.ByteOrder;
import java.util.concurrent.TimeUnit;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.Pressure;
import uk.co.real_logic.artio.Reply;
import uk.co.real_logic.artio.binary_entrypoint.BinaryEntryPointConnection;
import uk.co.real_logic.artio.binary_entrypoint.BinaryEntryPointContext;
import uk.co.real_logic.artio.binary_entrypoint.BinaryEntryPointKey;
import uk.co.real_logic.artio.binary_entrypoint.BinaryEntryPointProtocol;
import uk.co.real_logic.artio.binary_entrypoint.BinaryEntryPointProxy;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.fixp.AbstractFixPProxy;
import uk.co.real_logic.artio.fixp.FixPConnection;
import uk.co.real_logic.artio.fixp.FixPContext;
import uk.co.real_logic.artio.fixp.FixPMessageDissector;
import uk.co.real_logic.artio.library.CancelOnDisconnect;
import uk.co.real_logic.artio.library.FixPSessionOwner;
import uk.co.real_logic.artio.library.InternalFixPConnection;
import uk.co.real_logic.artio.messages.CancelOnDisconnectOption;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.messages.ThrottleConfigurationStatus;
import uk.co.real_logic.artio.protocol.GatewayPublication;

class InternalBinaryEntryPointConnection
extends InternalFixPConnection
implements BinaryEntryPointConnection {
    private static final UnsafeBuffer EMPTY_BUFFER = new UnsafeBuffer(new byte[0]);
    private static final int THROTTLE_REASON = 99;
    private final BinaryEntryPointProxy proxy;
    private final long maxFixPKeepaliveTimeoutInMs;
    private final int maxRetransmissionRange;
    private final CancelOnDisconnect cancelOnDisconnect;
    private TerminationCode resendTerminationCode;
    private long sessionId;
    private long sessionVerId;
    private CancelOnDisconnectType cancelOnDisconnectType;
    private long codTimeoutWindowInMs;
    private boolean suppressRedactResend = false;
    private boolean suppressInboundValidResend = false;
    private boolean suppressRetransmissionResend = false;
    private boolean replaying = false;
    private BinaryEntryPointContext context;
    private boolean retransmitOfflineNextSessionMessages = false;

    InternalBinaryEntryPointConnection(BinaryEntryPointProtocol protocol, long connectionId, GatewayPublication outboundPublication, GatewayPublication inboundPublication, int libraryId, FixPSessionOwner owner, long lastReceivedSequenceNumber, long lastSentSequenceNumber, long lastConnectPayload, CommonConfiguration configuration, BinaryEntryPointContext context, FixPMessageDissector dissector) {
        this(connectionId, outboundPublication, inboundPublication, libraryId, owner, lastReceivedSequenceNumber, lastSentSequenceNumber, lastConnectPayload, configuration, context, new BinaryEntryPointProxy(protocol, dissector, connectionId, outboundPublication.dataPublication(), configuration.epochNanoClock()), dissector);
    }

    InternalBinaryEntryPointConnection(long connectionId, GatewayPublication outboundPublication, GatewayPublication inboundPublication, int libraryId, FixPSessionOwner owner, long lastReceivedSequenceNumber, long lastSentSequenceNumber, long lastConnectPayload, CommonConfiguration configuration, BinaryEntryPointContext context, BinaryEntryPointProxy proxy, FixPMessageDissector dissector) {
        super(connectionId, outboundPublication, inboundPublication, libraryId, configuration.epochNanoClock(), owner, (AbstractFixPProxy)proxy, dissector);
        this.maxFixPKeepaliveTimeoutInMs = configuration.maxFixPKeepaliveTimeoutInMs();
        this.context = context;
        this.proxy = (BinaryEntryPointProxy)((InternalFixPConnection)this).proxy;
        this.initialState(context);
        long timeInMs = System.currentTimeMillis();
        this.nextSendMessageTimeInMs = this.nextReceiveMessageTimeInMs = timeInMs + configuration.noEstablishFixPTimeoutInMs();
        this.requestedKeepAliveIntervalInMs = this.maxFixPKeepaliveTimeoutInMs;
        this.maxRetransmissionRange = configuration.fixPAcceptedSessionMaxRetransmissionRange();
        this.nextRecvSeqNo(this.adjustSeqNo(lastReceivedSequenceNumber));
        this.nextSentSeqNo(this.adjustSeqNo(lastSentSequenceNumber));
        this.retransmitOfflineNextSessionMessages = lastConnectPayload == 1L;
        this.cancelOnDisconnect = new CancelOnDisconnect(configuration.epochNanoClock(), true, deadlineInNs -> !Pressure.isBackPressured((long)outboundPublication.saveCancelOnDisconnectTrigger(context.sessionID(), deadlineInNs)));
        this.cancelOnDisconnect.enqueueTask(arg_0 -> ((FixPSessionOwner)owner).enqueueTask(arg_0));
    }

    private void initialState(BinaryEntryPointContext context) {
        this.state(context.fromNegotiate() ? FixPConnection.State.ACCEPTED : FixPConnection.State.NEGOTIATED_REESTABLISH);
    }

    private long adjustSeqNo(long lastReceivedSequenceNumber) {
        if (lastReceivedSequenceNumber == -1L) {
            return 1L;
        }
        return lastReceivedSequenceNumber + 1L;
    }

    @Override
    public long sessionId() {
        return this.sessionId;
    }

    @Override
    public long sessionVerId() {
        return this.sessionVerId;
    }

    @Override
    public BinaryEntryPointKey key() {
        return this.context.key();
    }

    @Override
    public CancelOnDisconnectType cancelOnDisconnectType() {
        return this.cancelOnDisconnectType;
    }

    @Override
    public long codTimeoutWindow() {
        return this.codTimeoutWindowInMs;
    }

    protected void keepAliveExpiredTerminate() {
        this.terminate(TerminationCode.UNSPECIFIED);
    }

    @Override
    public void terminate(TerminationCode terminationCode) {
        this.validateCanSend();
        this.internalTerminateInclResend(terminationCode);
    }

    private void internalTerminateInclResend(TerminationCode terminationCode) {
        this.sendTerminate(terminationCode, FixPConnection.State.UNBINDING, FixPConnection.State.RESEND_TERMINATE);
    }

    public long trySendSequence() {
        long position = this.proxy.sendSequence(this.sessionId, this.nextSentSeqNo);
        if (position > 0L) {
            this.onAttemptedToSendMessage();
        }
        return position;
    }

    protected int poll(long timeInMs) {
        switch (this.state) {
            case ACCEPTED: 
            case SENT_NEGOTIATE_RESPONSE: 
            case RETRY_NEGOTIATE_RESPONSE: 
            case NEGOTIATED_REESTABLISH: {
                if (timeInMs > this.nextReceiveMessageTimeInMs) {
                    this.fullyUnbind(DisconnectReason.AUTHENTICATION_TIMEOUT);
                }
                return 1;
            }
            case REPLIED_FINISHED_SENDING: 
            case SENT_FINISHED_SENDING: {
                if (timeInMs > this.nextSendMessageTimeInMs) {
                    this.finishSending();
                }
                return 1;
            }
            case RETRY_FINISHED_SENDING: 
            case RETRY_REPLY_FINISHED_SENDING: {
                this.finishSending();
                return 1;
            }
        }
        return this.commonPoll(this.state, timeInMs);
    }

    protected int pollExtraEstablished(long timeInMs) {
        return 0;
    }

    protected long sendSequence(boolean lapsed) {
        return this.trySendSequence();
    }

    protected void onReplayComplete() {
        this.replaying = false;
    }

    @Override
    public boolean isReplaying() {
        return this.replaying;
    }

    protected void onOfflineReconnect(long connectionId, FixPContext fixPContext) {
        BinaryEntryPointContext context = (BinaryEntryPointContext)fixPContext;
        this.retransmitOfflineNextSessionMessages = this.sessionVerId == Long.MIN_VALUE;
        this.context = context;
        this.sessionVerId = context.sessionVerID();
        this.initialState(context);
        this.connectionId = connectionId;
        this.proxy.ids(connectionId, this.sessionId);
    }

    public ControlledFragmentHandler.Action onNegotiate(long sessionId, long sessionVerID, long timestamp, long enteringFirm, long onbehalfFirm, String senderLocation) {
        long inboundPos;
        FixPConnection.State state = this.state();
        if (state == FixPConnection.State.UNBOUND) {
            this.onSessionId(sessionId, sessionVerID);
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        if (state != FixPConnection.State.ACCEPTED && state != FixPConnection.State.SENT_NEGOTIATE_RESPONSE && this.checkFinishedSending(state)) {
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        this.onSessionId(sessionId, sessionVerID);
        this.nextRecvSeqNo = 1L;
        if (!this.retransmitOfflineNextSessionMessages) {
            this.nextSentSeqNo = 1L;
        }
        if ((inboundPos = this.inboundPublication.saveRedactSequenceUpdate(sessionId, 0, -1000L)) < 0L) {
            return ControlledFragmentHandler.Action.ABORT;
        }
        long position = this.proxy.sendNegotiateResponse(sessionId, sessionVerID, timestamp, enteringFirm);
        this.onAttemptedToSendMessage();
        return Pressure.apply((long)this.checkState(position, FixPConnection.State.SENT_NEGOTIATE_RESPONSE, FixPConnection.State.RETRY_NEGOTIATE_RESPONSE));
    }

    private void onSessionId(long sessionId, long sessionVerID) {
        this.sessionId = sessionId;
        this.sessionVerId = sessionVerID;
        this.proxy.ids(this.connectionId, sessionId);
    }

    private long checkState(long position, FixPConnection.State success, FixPConnection.State backPressured) {
        if (position > 0L) {
            this.state(success);
        } else {
            this.state(backPressured);
        }
        return position;
    }

    public ControlledFragmentHandler.Action onEstablish(long sessionID, long sessionVerID, long timestamp, long keepAliveIntervalInMs, long nextSeqNo, CancelOnDisconnectType cancelOnDisconnectType, long codTimeoutWindow) {
        FixPConnection.State state = this.state();
        if (state == FixPConnection.State.NEGOTIATED_REESTABLISH) {
            this.onSessionId(sessionID, sessionVerID);
        } else {
            this.checkSession(sessionID, sessionVerID);
            if (state != FixPConnection.State.SENT_NEGOTIATE_RESPONSE) {
                this.onAttemptedToSendMessage();
                return Pressure.apply((long)this.proxy.sendEstablishReject(sessionID, sessionVerID, timestamp, EstablishRejectCode.ALREADY_ESTABLISHED));
            }
            if (keepAliveIntervalInMs > this.maxFixPKeepaliveTimeoutInMs) {
                this.onAttemptedToSendMessage();
                long position = this.proxy.sendEstablishReject(sessionID, sessionVerID, timestamp, EstablishRejectCode.KEEPALIVE_INTERVAL);
                if (position > 0L) {
                    return this.fullyUnbind();
                }
                return Pressure.apply((long)position);
            }
        }
        if (!this.suppressRedactResend) {
            this.onAttemptedToSendMessage();
            int correctSequenceNumber = (int)nextSeqNo - 1;
            long inboundPos = this.inboundPublication.saveRedactSequenceUpdate(this.sessionId, correctSequenceNumber, -1000L);
            if (inboundPos > 0L) {
                this.suppressRedactResend = true;
            } else {
                return ControlledFragmentHandler.Action.ABORT;
            }
        }
        long position = this.proxy.sendEstablishAck(sessionID, sessionVerID, timestamp, keepAliveIntervalInMs, nextSeqNo, this.nextRecvSeqNo - 1L);
        this.requestedKeepAliveIntervalInMs = keepAliveIntervalInMs;
        this.onAttemptedToSendMessage();
        this.onReceivedMessage();
        if (position > 0L) {
            if (this.retransmitOfflineNextSessionMessages) {
                if (this.nextSentSeqNo > 1L) {
                    if (!this.retransmitOfflineNextSessionMessages(sessionID)) {
                        return ControlledFragmentHandler.Action.ABORT;
                    }
                } else {
                    this.retransmitOfflineNextSessionMessages = false;
                }
            }
            this.setupCancelOnDisconnect(cancelOnDisconnectType, codTimeoutWindow);
            this.nextRecvSeqNo = nextSeqNo;
            this.suppressRedactResend = false;
            this.state(FixPConnection.State.ESTABLISHED);
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        return ControlledFragmentHandler.Action.ABORT;
    }

    private boolean retransmitOfflineNextSessionMessages(long sessionID) {
        long outboundPosition;
        long endSequenceNumber = this.nextSentSeqNo - 1L;
        if (!this.suppressInboundValidResend) {
            long resendRequestPosition = this.saveValidResendRequest(sessionID, 1L, endSequenceNumber, Long.MIN_VALUE, -1);
            if (Pressure.isBackPressured((long)resendRequestPosition)) {
                return false;
            }
            this.suppressInboundValidResend = true;
        }
        if (Pressure.isBackPressured((long)(outboundPosition = this.saveValidResendRequest(this.outboundPublication, sessionID, 1L, endSequenceNumber, Long.MIN_VALUE, -1)))) {
            return false;
        }
        this.replaying = true;
        this.retransmitOfflineNextSessionMessages = false;
        this.suppressInboundValidResend = false;
        return true;
    }

    private void setupCancelOnDisconnect(CancelOnDisconnectType type, long codTimeoutWindow) {
        if (type != CancelOnDisconnectType.DO_NOT_CANCEL_ON_DISCONNECT_OR_TERMINATE && codTimeoutWindow == DeltaInMillisDecoder.timeNullValue()) {
            this.setupCancelOnDisconnect(CancelOnDisconnectType.DO_NOT_CANCEL_ON_DISCONNECT_OR_TERMINATE, DeltaInMillisDecoder.timeNullValue());
        } else {
            CancelOnDisconnectOption option;
            this.cancelOnDisconnectType = type;
            switch (type) {
                case CANCEL_ON_DISCONNECT_ONLY: {
                    option = CancelOnDisconnectOption.CANCEL_ON_DISCONNECT_ONLY;
                    break;
                }
                case CANCEL_ON_TERMINATE_ONLY: {
                    option = CancelOnDisconnectOption.CANCEL_ON_LOGOUT_ONLY;
                    break;
                }
                case CANCEL_ON_DISCONNECT_OR_TERMINATE: {
                    option = CancelOnDisconnectOption.CANCEL_ON_DISCONNECT_OR_LOGOUT;
                    break;
                }
                default: {
                    option = CancelOnDisconnectOption.DO_NOT_CANCEL_ON_DISCONNECT_OR_LOGOUT;
                }
            }
            this.cancelOnDisconnect.cancelOnDisconnectOption(option);
            this.codTimeoutWindowInMs = Math.min(60000L, codTimeoutWindow);
            this.cancelOnDisconnect.cancelOnDisconnectTimeoutWindowInNs(TimeUnit.MILLISECONDS.toNanos(this.codTimeoutWindowInMs));
        }
    }

    public ControlledFragmentHandler.Action onTerminate(long sessionID, long sessionVerID, TerminationCode terminationCode) {
        this.cancelOnDisconnect.checkCancelOnDisconnectLogout(this.clock.nanoTime());
        if (this.state == FixPConnection.State.UNBINDING) {
            this.fullyUnbind();
        } else {
            DebugLogger.log((LogTag)LogTag.FIXP_SESSION, (String)"Terminated: ", (String)terminationCode.name());
            this.sendTerminateAck(terminationCode);
        }
        this.checkSession(sessionID, sessionVerID);
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    protected ControlledFragmentHandler.Action unbindState(DisconnectReason reason) {
        this.cancelOnDisconnect.checkCancelOnDisconnectDisconnect();
        super.unbindState(reason);
        return null;
    }

    private void checkSession(long sessionID, long sessionVerID) {
    }

    private void sendTerminateAck(TerminationCode terminationCode) {
        long position = this.sendTerminate(terminationCode, FixPConnection.State.UNBOUND, FixPConnection.State.RESEND_TERMINATE_ACK);
        if (position > 0L) {
            this.fullyUnbind();
        }
    }

    private long sendTerminate(TerminationCode terminationCode, FixPConnection.State finalState, FixPConnection.State resendState) {
        long position = this.proxy.sendTerminate(this.sessionId, this.sessionVerId, terminationCode, this.requestTimestampInNs());
        if (position > 0L) {
            this.state(finalState);
            this.resendTerminationCode = null;
        } else {
            this.state(resendState);
            this.resendTerminationCode = terminationCode;
        }
        return position;
    }

    public ControlledFragmentHandler.Action onSequence(long nextSeqNo) {
        this.onReceivedMessage();
        if (this.checkFinishedSending(this.state)) {
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        return this.checkSeqNo(nextSeqNo);
    }

    private ControlledFragmentHandler.Action checkSeqNo(long nextSeqNo) {
        long nextRecvSeqNo = this.nextRecvSeqNo;
        if (nextSeqNo > nextRecvSeqNo) {
            long position = this.proxy.sendNotApplied(nextRecvSeqNo, nextSeqNo - nextRecvSeqNo, this.requestTimestampInNs());
            if (position > 0L) {
                this.nextRecvSeqNo = nextSeqNo;
            }
            return Pressure.apply((long)position);
        }
        if (nextSeqNo < nextRecvSeqNo) {
            this.internalTerminateInclResend(TerminationCode.FINISHED);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    public ControlledFragmentHandler.Action onMessage(DirectBuffer buffer, int offset, int templateId, int blockLength, int version, int sofhMessageSize) {
        this.onReceivedMessage();
        FixPConnection.State state = this.state();
        if (this.canReceiveMessage(state)) {
            this.dissector.onBusinessMessage(templateId, buffer, offset, blockLength, version, true);
            ControlledFragmentHandler.Action action = this.handler.onBusinessMessage((FixPConnection)this, templateId, buffer, offset, blockLength, version, false);
            if (action != ControlledFragmentHandler.Action.ABORT) {
                ++this.nextRecvSeqNo;
            }
            return action;
        }
        this.checkFinishedSending(state);
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private boolean canReceiveMessage(FixPConnection.State state) {
        return state == FixPConnection.State.ESTABLISHED || state == FixPConnection.State.RETRANSMITTING || state == FixPConnection.State.AWAITING_KEEPALIVE;
    }

    private boolean checkFinishedSending(FixPConnection.State state) {
        if (state == FixPConnection.State.RECV_FINISHED_SENDING || state == FixPConnection.State.REPLIED_FINISHED_SENDING || state == FixPConnection.State.RETRY_REPLY_FINISHED_SENDING) {
            this.internalTerminateInclResend(TerminationCode.UNSPECIFIED);
            return true;
        }
        return false;
    }

    @Override
    public void finishSending() {
        FixPConnection.State state = this.state();
        boolean weInitiatedFinishedSending = state == FixPConnection.State.ESTABLISHED;
        long position = this.proxy.sendFinishedSending(this.sessionId, this.sessionVerId, this.nextRecvSeqNo - 1L, this.requestTimestampInNs());
        this.onAttemptedToSendMessage();
        if (weInitiatedFinishedSending) {
            this.checkState(position, FixPConnection.State.SENT_FINISHED_SENDING, FixPConnection.State.RETRY_FINISHED_SENDING);
        } else {
            this.checkState(position, FixPConnection.State.REPLIED_FINISHED_SENDING, FixPConnection.State.RETRY_REPLY_FINISHED_SENDING);
        }
    }

    public ControlledFragmentHandler.Action onFinishedSending(long sessionID, long sessionVerID, long lastSeqNo) {
        boolean weInitiatedFinishedSending;
        FixPConnection.State state = this.state;
        boolean bl = weInitiatedFinishedSending = state == FixPConnection.State.RECV_FINISHED_RECEIVING_ONLY;
        if (state == FixPConnection.State.ESTABLISHED || !weInitiatedFinishedSending) {
            // empty if block
        }
        this.checkSession(sessionID, sessionVerID);
        if (state != FixPConnection.State.RECV_FINISHED_SENDING && state != FixPConnection.State.UNBINDING && state != FixPConnection.State.RESEND_TERMINATE) {
            long position = this.proxy.sendFinishedReceiving(sessionID, sessionVerID, this.requestTimestampInNs());
            if (position > 0L) {
                if (weInitiatedFinishedSending) {
                    this.internalTerminateInclResend(TerminationCode.FINISHED);
                } else {
                    this.state(FixPConnection.State.RECV_FINISHED_SENDING);
                }
                return this.handler.onFinishedSending((FixPConnection)this);
            }
            return ControlledFragmentHandler.Action.ABORT;
        }
        return this.handler.onFinishedSending((FixPConnection)this);
    }

    public ControlledFragmentHandler.Action onFinishedReceiving(long sessionID, long sessionVerID) {
        boolean theyInitiatedFinishedSending;
        FixPConnection.State state = this.state;
        boolean weInitiatedFinishedSending = state == FixPConnection.State.SENT_FINISHED_SENDING || state == FixPConnection.State.RETRY_FINISHED_SENDING;
        boolean bl = theyInitiatedFinishedSending = state == FixPConnection.State.REPLIED_FINISHED_SENDING;
        if (weInitiatedFinishedSending || !theyInitiatedFinishedSending) {
            // empty if block
        }
        this.checkSession(sessionID, sessionVerID);
        if (weInitiatedFinishedSending) {
            this.state(FixPConnection.State.RECV_FINISHED_RECEIVING_ONLY);
        } else {
            this.internalTerminateInclResend(TerminationCode.FINISHED);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    public ControlledFragmentHandler.Action onRetransmitRequest(long sessionID, long timestampInNs, long fromSeqNo, long count) {
        long position;
        FixPConnection.State state = this.state;
        if (state == FixPConnection.State.ESTABLISHED || state != FixPConnection.State.AWAITING_KEEPALIVE) {
            // empty if block
        }
        if (this.sessionId != sessionID) {
            return this.sendRetransmitReject(RetransmitRejectCode.INVALID_SESSION, timestampInNs);
        }
        if (this.maxRetransmissionRange != 0 && count > (long)this.maxRetransmissionRange) {
            return this.sendRetransmitReject(RetransmitRejectCode.REQUEST_LIMIT_EXCEEDED, timestampInNs);
        }
        long endSequenceNumber = fromSeqNo + count - 1L;
        if (endSequenceNumber >= this.nextSentSeqNo) {
            return this.sendRetransmitReject(RetransmitRejectCode.OUT_OF_RANGE, timestampInNs);
        }
        if (this.replaying) {
            return this.sendRetransmitReject(RetransmitRejectCode.REQUEST_LIMIT_EXCEEDED, timestampInNs);
        }
        if (!this.suppressRetransmissionResend && (position = this.proxy.sendRetransmissionWithSequence(fromSeqNo, count, this.requestTimestampInNs(), timestampInNs, this.nextSentSeqNo)) < 0L) {
            return ControlledFragmentHandler.Action.ABORT;
        }
        position = this.saveValidResendRequest(sessionID, fromSeqNo, endSequenceNumber, this.sessionVerId, 0);
        if (position < 0L) {
            this.suppressRetransmissionResend = true;
            return ControlledFragmentHandler.Action.ABORT;
        }
        this.replaying = true;
        this.suppressRetransmissionResend = false;
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private long saveValidResendRequest(long sessionID, long fromSeqNo, long endSequenceNumber, long sessionVerId, int correlationId) {
        return this.saveValidResendRequest(this.inboundPublication, sessionID, fromSeqNo, endSequenceNumber, sessionVerId, correlationId);
    }

    private long saveValidResendRequest(GatewayPublication publication, long sessionID, long fromSeqNo, long endSequenceNumber, long sessionVerId, int correlationId) {
        return publication.saveValidResendRequest(sessionID, this.connectionId, fromSeqNo, endSequenceNumber, (int)sessionVerId, (long)correlationId, (DirectBuffer)EMPTY_BUFFER, 0, 0);
    }

    private ControlledFragmentHandler.Action sendRetransmitReject(RetransmitRejectCode rejectCode, long timestampInNs) {
        return Pressure.apply((long)this.proxy.sendRetransmitReject(rejectCode, this.requestTimestampInNs(), timestampInNs));
    }

    @Override
    public Reply<ThrottleConfigurationStatus> throttleMessagesAt(int throttleWindowInMs, int throttleLimitOfMessages) {
        EngineConfiguration.validateMessageThrottleOptions((int)throttleWindowInMs, (int)throttleLimitOfMessages);
        return this.owner.messageThrottle(this.sessionId, throttleWindowInMs, throttleLimitOfMessages);
    }

    protected boolean onThrottleNotification(long refMsgTypeValue, DirectBuffer rejectRefIDBuffer, int rejectRefIDOffset, int rejectRefIDLength) {
        FixPConnection.State state = this.state();
        if (this.canReceiveMessage(state)) {
            long rejectRefID;
            long refSeqNum;
            boolean sent;
            MessageType refMsgType = MessageType.get((short)((short)refMsgTypeValue));
            boolean bl = sent = this.proxy.sendBusinessReject(refSeqNum = this.nextRecvSeqNo++, refMsgType, rejectRefID = rejectRefIDBuffer.getLong(rejectRefIDOffset, ByteOrder.LITTLE_ENDIAN), 99L) > 0L;
            if (sent) {
                ++this.nextSentSeqNo;
                this.onAttemptedToSendMessage();
            }
            return sent;
        }
        return true;
    }

    public long startEndOfDay() {
        FixPConnection.State state = this.state;
        if (state == FixPConnection.State.ESTABLISHED) {
            this.terminate(TerminationCode.FINISHED);
            return 1L;
        }
        return this.requestDisconnect(DisconnectReason.ENGINE_SHUTDOWN);
    }
}

