/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.MessageType;
import b3.entrypoint.fixp.sbe.MetaAttribute;
import b3.entrypoint.fixp.sbe.RatioQtyDecoder;
import b3.entrypoint.fixp.sbe.Side;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class SecurityDefinitionRequestDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 14;
    public static final int TEMPLATE_ID = 300;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final SecurityDefinitionRequestDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;
    private final NoLegsDecoder noLegs = new NoLegsDecoder(this);

    public int sbeBlockLength() {
        return 14;
    }

    public int sbeTemplateId() {
        return 300;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public SecurityDefinitionRequestDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int messageTypeId() {
        return 35;
    }

    public static int messageTypeSinceVersion() {
        return 0;
    }

    public static int messageTypeEncodingOffset() {
        return 0;
    }

    public static int messageTypeEncodingLength() {
        return 1;
    }

    public static String messageTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public short messageTypeRaw() {
        return MessageType.SecurityDefinitionRequest.value();
    }

    public MessageType messageType() {
        return MessageType.SecurityDefinitionRequest;
    }

    public static int securityReqIDId() {
        return 320;
    }

    public static int securityReqIDSinceVersion() {
        return 0;
    }

    public static int securityReqIDEncodingOffset() {
        return 0;
    }

    public static int securityReqIDEncodingLength() {
        return 8;
    }

    public static String securityReqIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long securityReqIDNullValue() {
        return -1L;
    }

    public static long securityReqIDMinValue() {
        return 0L;
    }

    public static long securityReqIDMaxValue() {
        return -2L;
    }

    public long securityReqID() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int enteringTraderId() {
        return 35502;
    }

    public static int enteringTraderSinceVersion() {
        return 0;
    }

    public static int enteringTraderEncodingOffset() {
        return 8;
    }

    public static int enteringTraderEncodingLength() {
        return 5;
    }

    public static String enteringTraderMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static byte enteringTraderNullValue() {
        return 0;
    }

    public static byte enteringTraderMinValue() {
        return 32;
    }

    public static byte enteringTraderMaxValue() {
        return 126;
    }

    public static int enteringTraderLength() {
        return 5;
    }

    public byte enteringTrader(int index) {
        if (index < 0 || index >= 5) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 8 + index * 1;
        return this.buffer.getByte(pos);
    }

    public static String enteringTraderCharacterEncoding() {
        return "ASCII";
    }

    public int getEnteringTrader(byte[] dst, int dstOffset) {
        int length = 5;
        if (dstOffset < 0 || dstOffset > dst.length - 5) {
            throw new IndexOutOfBoundsException("Copy will go out of range: offset=" + dstOffset);
        }
        this.buffer.getBytes(this.offset + 8, dst, dstOffset, 5);
        return 5;
    }

    public String enteringTrader() {
        int end;
        byte[] dst = new byte[5];
        this.buffer.getBytes(this.offset + 8, dst, 0, 5);
        for (end = 0; end < 5 && dst[end] != 0; ++end) {
        }
        return new String(dst, 0, end, StandardCharsets.US_ASCII);
    }

    public int getEnteringTrader(Appendable value) {
        for (int i = 0; i < 5; ++i) {
            int c = this.buffer.getByte(this.offset + 8 + i) & 0xFF;
            if (c == 0) {
                return i;
            }
            try {
                value.append((char)(c > 127 ? 63 : (char)c));
                continue;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        return 5;
    }

    public static int marketSegmentIDId() {
        return 1300;
    }

    public static int marketSegmentIDSinceVersion() {
        return 0;
    }

    public static int marketSegmentIDEncodingOffset() {
        return 13;
    }

    public static int marketSegmentIDEncodingLength() {
        return 1;
    }

    public static String marketSegmentIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static short marketSegmentIDNullValue() {
        return 255;
    }

    public static short marketSegmentIDMinValue() {
        return 0;
    }

    public static short marketSegmentIDMaxValue() {
        return 254;
    }

    public short marketSegmentID() {
        return (short)(this.buffer.getByte(this.offset + 13) & 0xFF);
    }

    public static long noLegsDecoderId() {
        return 5L;
    }

    public static int noLegsDecoderSinceVersion() {
        return 0;
    }

    public NoLegsDecoder noLegs() {
        this.noLegs.wrap(this.buffer);
        return this.noLegs;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        SecurityDefinitionRequestDecoder decoder = new SecurityDefinitionRequestDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[SecurityDefinitionRequest](sbeTemplateId=");
        builder.append(300);
        builder.append("|sbeSchemaId=");
        builder.append(1);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 0) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(0);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 14) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(14);
        builder.append("):");
        builder.append("messageType=");
        builder.append((Object)this.messageType());
        builder.append('|');
        builder.append("securityReqID=");
        builder.append(this.securityReqID());
        builder.append('|');
        builder.append("enteringTrader=");
        for (int i = 0; i < SecurityDefinitionRequestDecoder.enteringTraderLength() && this.enteringTrader(i) > 0; ++i) {
            builder.append((char)this.enteringTrader(i));
        }
        builder.append('|');
        builder.append("marketSegmentID=");
        builder.append(this.marketSegmentID());
        builder.append('|');
        builder.append("noLegs=[");
        NoLegsDecoder noLegs = this.noLegs();
        if (noLegs.count() > 0) {
            while (noLegs.hasNext()) {
                noLegs.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        this.limit(originalLimit);
        return builder;
    }

    public static final class NoLegsDecoder
    implements Iterable<NoLegsDecoder>,
    Iterator<NoLegsDecoder> {
        public static final int HEADER_SIZE = 3;
        private final SecurityDefinitionRequestDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;
        private static final byte[] LEGSECURITYIDSOURCE_VALUE = new byte[]{56};
        private static final byte[] LEGSECURITYEXCHANGE_VALUE = new byte[]{66, 86, 77, 70};
        private final RatioQtyDecoder legRatioQty = new RatioQtyDecoder();

        NoLegsDecoder(SecurityDefinitionRequestDecoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(DirectBuffer buffer) {
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            this.blockLength = buffer.getShort(limit + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.count = (short)(buffer.getByte(limit + 2) & 0xFF);
        }

        @Override
        public NoLegsDecoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 17;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<NoLegsDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        public static int legSecurityIDId() {
            return 602;
        }

        public static int legSecurityIDSinceVersion() {
            return 0;
        }

        public static int legSecurityIDEncodingOffset() {
            return 0;
        }

        public static int legSecurityIDEncodingLength() {
            return 8;
        }

        public static String legSecurityIDMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long legSecurityIDNullValue() {
            return -1L;
        }

        public static long legSecurityIDMinValue() {
            return 0L;
        }

        public static long legSecurityIDMaxValue() {
            return -2L;
        }

        public long legSecurityID() {
            return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
        }

        public static int legSecurityIDSourceId() {
            return 603;
        }

        public static int legSecurityIDSourceSinceVersion() {
            return 0;
        }

        public static int legSecurityIDSourceEncodingOffset() {
            return 8;
        }

        public static int legSecurityIDSourceEncodingLength() {
            return 0;
        }

        public static String legSecurityIDSourceMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "constant";
            }
            return "";
        }

        public static byte legSecurityIDSourceNullValue() {
            return 0;
        }

        public static byte legSecurityIDSourceMinValue() {
            return 32;
        }

        public static byte legSecurityIDSourceMaxValue() {
            return 126;
        }

        public static int legSecurityIDSourceLength() {
            return 1;
        }

        public byte legSecurityIDSource(int index) {
            return LEGSECURITYIDSOURCE_VALUE[index];
        }

        public int getLegSecurityIDSource(byte[] dst, int offset, int length) {
            int bytesCopied = Math.min(length, 1);
            System.arraycopy(LEGSECURITYIDSOURCE_VALUE, 0, dst, offset, bytesCopied);
            return bytesCopied;
        }

        public byte legSecurityIDSource() {
            return 56;
        }

        public static int legSecurityExchangeId() {
            return 616;
        }

        public static int legSecurityExchangeSinceVersion() {
            return 0;
        }

        public static int legSecurityExchangeEncodingOffset() {
            return 8;
        }

        public static int legSecurityExchangeEncodingLength() {
            return 0;
        }

        public static String legSecurityExchangeMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "constant";
            }
            return "";
        }

        public static byte legSecurityExchangeNullValue() {
            return 0;
        }

        public static byte legSecurityExchangeMinValue() {
            return 32;
        }

        public static byte legSecurityExchangeMaxValue() {
            return 126;
        }

        public static int legSecurityExchangeLength() {
            return 4;
        }

        public byte legSecurityExchange(int index) {
            return LEGSECURITYEXCHANGE_VALUE[index];
        }

        public int getLegSecurityExchange(byte[] dst, int offset, int length) {
            int bytesCopied = Math.min(length, 4);
            System.arraycopy(LEGSECURITYEXCHANGE_VALUE, 0, dst, offset, bytesCopied);
            return bytesCopied;
        }

        public String legSecurityExchange() {
            return "BVMF";
        }

        public static int legRatioQtyId() {
            return 623;
        }

        public static int legRatioQtySinceVersion() {
            return 0;
        }

        public static int legRatioQtyEncodingOffset() {
            return 8;
        }

        public static int legRatioQtyEncodingLength() {
            return 8;
        }

        public static String legRatioQtyMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public RatioQtyDecoder legRatioQty() {
            this.legRatioQty.wrap(this.buffer, this.offset + 8);
            return this.legRatioQty;
        }

        public static int legSideId() {
            return 624;
        }

        public static int legSideSinceVersion() {
            return 0;
        }

        public static int legSideEncodingOffset() {
            return 16;
        }

        public static int legSideEncodingLength() {
            return 1;
        }

        public static String legSideMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public byte legSideRaw() {
            return this.buffer.getByte(this.offset + 16);
        }

        public Side legSide() {
            return Side.get(this.buffer.getByte(this.offset + 16));
        }

        public StringBuilder appendTo(StringBuilder builder) {
            if (null == this.buffer) {
                return builder;
            }
            builder.append('(');
            builder.append("legSecurityID=");
            builder.append(this.legSecurityID());
            builder.append('|');
            builder.append("legRatioQty=");
            RatioQtyDecoder legRatioQty = this.legRatioQty();
            if (legRatioQty != null) {
                legRatioQty.appendTo(builder);
            } else {
                builder.append("null");
            }
            builder.append('|');
            builder.append("legSide=");
            builder.append((Object)this.legSide());
            builder.append(')');
            return builder;
        }
    }
}

