/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.MessageHeaderDecoder;
import b3.entrypoint.fixp.sbe.MessageType;
import b3.entrypoint.fixp.sbe.MetaAttribute;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class OrderCancelRequestDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 37;
    public static final int TEMPLATE_ID = 105;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 5;
    public static final String SEMANTIC_VERSION = "5.6";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final OrderCancelRequestDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 37;
    }

    public int sbeTemplateId() {
        return 105;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 5;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public OrderCancelRequestDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public OrderCancelRequestDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (105 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public OrderCancelRequestDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int messageTypeId() {
        return 35;
    }

    public static int messageTypeSinceVersion() {
        return 0;
    }

    public static int messageTypeEncodingOffset() {
        return 0;
    }

    public static int messageTypeEncodingLength() {
        return 1;
    }

    public static String messageTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public short messageTypeRaw() {
        return MessageType.OrderCancelRequest.value();
    }

    public MessageType messageType() {
        return MessageType.OrderCancelRequest;
    }

    public static int origClOrdIDId() {
        return 41;
    }

    public static int origClOrdIDSinceVersion() {
        return 0;
    }

    public static int origClOrdIDEncodingOffset() {
        return 0;
    }

    public static int origClOrdIDEncodingLength() {
        return 8;
    }

    public static String origClOrdIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long origClOrdIDNullValue() {
        return -1L;
    }

    public static long origClOrdIDMinValue() {
        return 0L;
    }

    public static long origClOrdIDMaxValue() {
        return -2L;
    }

    public long origClOrdID() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int clOrdIDId() {
        return 11;
    }

    public static int clOrdIDSinceVersion() {
        return 0;
    }

    public static int clOrdIDEncodingOffset() {
        return 8;
    }

    public static int clOrdIDEncodingLength() {
        return 8;
    }

    public static String clOrdIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long clOrdIDNullValue() {
        return -1L;
    }

    public static long clOrdIDMinValue() {
        return 0L;
    }

    public static long clOrdIDMaxValue() {
        return -2L;
    }

    public long clOrdID() {
        return this.buffer.getLong(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int marketSegmentIDId() {
        return 1300;
    }

    public static int marketSegmentIDSinceVersion() {
        return 0;
    }

    public static int marketSegmentIDEncodingOffset() {
        return 16;
    }

    public static int marketSegmentIDEncodingLength() {
        return 1;
    }

    public static String marketSegmentIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static short marketSegmentIDNullValue() {
        return 255;
    }

    public static short marketSegmentIDMinValue() {
        return 0;
    }

    public static short marketSegmentIDMaxValue() {
        return 254;
    }

    public short marketSegmentID() {
        return (short)(this.buffer.getByte(this.offset + 16) & 0xFF);
    }

    public static int senderLocationId() {
        return 35503;
    }

    public static int senderLocationSinceVersion() {
        return 0;
    }

    public static int senderLocationEncodingOffset() {
        return 17;
    }

    public static int senderLocationEncodingLength() {
        return 10;
    }

    public static String senderLocationMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static byte senderLocationNullValue() {
        return 0;
    }

    public static byte senderLocationMinValue() {
        return 32;
    }

    public static byte senderLocationMaxValue() {
        return 126;
    }

    public static int senderLocationLength() {
        return 10;
    }

    public byte senderLocation(int index) {
        if (index < 0 || index >= 10) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 17 + index * 1;
        return this.buffer.getByte(pos);
    }

    public static String senderLocationCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public int getSenderLocation(byte[] dst, int dstOffset) {
        int length = 10;
        if (dstOffset < 0 || dstOffset > dst.length - 10) {
            throw new IndexOutOfBoundsException("Copy will go out of range: offset=" + dstOffset);
        }
        this.buffer.getBytes(this.offset + 17, dst, dstOffset, 10);
        return 10;
    }

    public String senderLocation() {
        int end;
        byte[] dst = new byte[10];
        this.buffer.getBytes(this.offset + 17, dst, 0, 10);
        for (end = 0; end < 10 && dst[end] != 0; ++end) {
        }
        return new String(dst, 0, end, StandardCharsets.US_ASCII);
    }

    public int getSenderLocation(Appendable value) {
        for (int i = 0; i < 10; ++i) {
            int c = this.buffer.getByte(this.offset + 17 + i) & 0xFF;
            if (c == 0) {
                return i;
            }
            try {
                value.append((char)(c > 127 ? 63 : (char)c));
                continue;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        return 10;
    }

    public static int enteringTraderId() {
        return 35502;
    }

    public static int enteringTraderSinceVersion() {
        return 0;
    }

    public static int enteringTraderEncodingOffset() {
        return 27;
    }

    public static int enteringTraderEncodingLength() {
        return 5;
    }

    public static String enteringTraderMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static byte enteringTraderNullValue() {
        return 0;
    }

    public static byte enteringTraderMinValue() {
        return 32;
    }

    public static byte enteringTraderMaxValue() {
        return 126;
    }

    public static int enteringTraderLength() {
        return 5;
    }

    public byte enteringTrader(int index) {
        if (index < 0 || index >= 5) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 27 + index * 1;
        return this.buffer.getByte(pos);
    }

    public static String enteringTraderCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public int getEnteringTrader(byte[] dst, int dstOffset) {
        int length = 5;
        if (dstOffset < 0 || dstOffset > dst.length - 5) {
            throw new IndexOutOfBoundsException("Copy will go out of range: offset=" + dstOffset);
        }
        this.buffer.getBytes(this.offset + 27, dst, dstOffset, 5);
        return 5;
    }

    public String enteringTrader() {
        int end;
        byte[] dst = new byte[5];
        this.buffer.getBytes(this.offset + 27, dst, 0, 5);
        for (end = 0; end < 5 && dst[end] != 0; ++end) {
        }
        return new String(dst, 0, end, StandardCharsets.US_ASCII);
    }

    public int getEnteringTrader(Appendable value) {
        for (int i = 0; i < 5; ++i) {
            int c = this.buffer.getByte(this.offset + 27 + i) & 0xFF;
            if (c == 0) {
                return i;
            }
            try {
                value.append((char)(c > 127 ? 63 : (char)c));
                continue;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        return 5;
    }

    public static int executingTraderId() {
        return 35506;
    }

    public static int executingTraderSinceVersion() {
        return 0;
    }

    public static int executingTraderEncodingOffset() {
        return 32;
    }

    public static int executingTraderEncodingLength() {
        return 5;
    }

    public static String executingTraderMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static byte executingTraderNullValue() {
        return 0;
    }

    public static byte executingTraderMinValue() {
        return 32;
    }

    public static byte executingTraderMaxValue() {
        return 126;
    }

    public static int executingTraderLength() {
        return 5;
    }

    public byte executingTrader(int index) {
        if (index < 0 || index >= 5) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 32 + index * 1;
        return this.buffer.getByte(pos);
    }

    public static String executingTraderCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public int getExecutingTrader(byte[] dst, int dstOffset) {
        int length = 5;
        if (dstOffset < 0 || dstOffset > dst.length - 5) {
            throw new IndexOutOfBoundsException("Copy will go out of range: offset=" + dstOffset);
        }
        this.buffer.getBytes(this.offset + 32, dst, dstOffset, 5);
        return 5;
    }

    public String executingTrader() {
        int end;
        byte[] dst = new byte[5];
        this.buffer.getBytes(this.offset + 32, dst, 0, 5);
        for (end = 0; end < 5 && dst[end] != 0; ++end) {
        }
        return new String(dst, 0, end, StandardCharsets.US_ASCII);
    }

    public int getExecutingTrader(Appendable value) {
        for (int i = 0; i < 5; ++i) {
            int c = this.buffer.getByte(this.offset + 32 + i) & 0xFF;
            if (c == 0) {
                return i;
            }
            try {
                value.append((char)(c > 127 ? 63 : (char)c));
                continue;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        return 5;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        OrderCancelRequestDecoder decoder = new OrderCancelRequestDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int i;
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[OrderCancelRequest](sbeTemplateId=");
        builder.append(105);
        builder.append("|sbeSchemaId=");
        builder.append(1);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 5) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(5);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 37) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(37);
        builder.append("):");
        builder.append("messageType=");
        builder.append((Object)this.messageType());
        builder.append('|');
        builder.append("origClOrdID=");
        builder.append(this.origClOrdID());
        builder.append('|');
        builder.append("clOrdID=");
        builder.append(this.clOrdID());
        builder.append('|');
        builder.append("marketSegmentID=");
        builder.append(this.marketSegmentID());
        builder.append('|');
        builder.append("senderLocation=");
        for (i = 0; i < OrderCancelRequestDecoder.senderLocationLength() && this.senderLocation(i) > 0; ++i) {
            builder.append((char)this.senderLocation(i));
        }
        builder.append('|');
        builder.append("enteringTrader=");
        for (i = 0; i < OrderCancelRequestDecoder.enteringTraderLength() && this.enteringTrader(i) > 0; ++i) {
            builder.append((char)this.enteringTrader(i));
        }
        builder.append('|');
        builder.append("executingTrader=");
        for (i = 0; i < OrderCancelRequestDecoder.executingTraderLength() && this.executingTrader(i) > 0; ++i) {
            builder.append((char)this.executingTrader(i));
        }
        this.limit(originalLimit);
        return builder;
    }

    public OrderCancelRequestDecoder sbeSkip() {
        this.sbeRewind();
        return this;
    }
}

