/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.FlowType;
import b3.entrypoint.fixp.sbe.MessageHeaderDecoder;
import b3.entrypoint.fixp.sbe.MessageType;
import b3.entrypoint.fixp.sbe.MetaAttribute;
import b3.entrypoint.fixp.sbe.NegotiationRejectCode;
import b3.entrypoint.fixp.sbe.UTCTimestampNanosDecoder;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class NegotiateRejectDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 25;
    public static final int TEMPLATE_ID = 3;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 5;
    public static final String SEMANTIC_VERSION = "5.6";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final NegotiateRejectDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;
    private final UTCTimestampNanosDecoder requestTimestamp = new UTCTimestampNanosDecoder();

    public int sbeBlockLength() {
        return 25;
    }

    public int sbeTemplateId() {
        return 3;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 5;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public NegotiateRejectDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public NegotiateRejectDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (3 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public NegotiateRejectDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int messageTypeId() {
        return 35;
    }

    public static int messageTypeSinceVersion() {
        return 0;
    }

    public static int messageTypeEncodingOffset() {
        return 0;
    }

    public static int messageTypeEncodingLength() {
        return 1;
    }

    public static String messageTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public short messageTypeRaw() {
        return MessageType.NegotiateReject.value();
    }

    public MessageType messageType() {
        return MessageType.NegotiateReject;
    }

    public static int sessionIDId() {
        return 35518;
    }

    public static int sessionIDSinceVersion() {
        return 0;
    }

    public static int sessionIDEncodingOffset() {
        return 0;
    }

    public static int sessionIDEncodingLength() {
        return 4;
    }

    public static String sessionIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long sessionIDNullValue() {
        return 0xFFFFFFFFL;
    }

    public static long sessionIDMinValue() {
        return 0L;
    }

    public static long sessionIDMaxValue() {
        return 0xFFFFFFFEL;
    }

    public long sessionID() {
        return (long)this.buffer.getInt(this.offset + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
    }

    public static int sessionVerIDId() {
        return 35519;
    }

    public static int sessionVerIDSinceVersion() {
        return 0;
    }

    public static int sessionVerIDEncodingOffset() {
        return 4;
    }

    public static int sessionVerIDEncodingLength() {
        return 8;
    }

    public static String sessionVerIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long sessionVerIDNullValue() {
        return -1L;
    }

    public static long sessionVerIDMinValue() {
        return 0L;
    }

    public static long sessionVerIDMaxValue() {
        return -2L;
    }

    public long sessionVerID() {
        return this.buffer.getLong(this.offset + 4, ByteOrder.LITTLE_ENDIAN);
    }

    public static int requestTimestampId() {
        return 35521;
    }

    public static int requestTimestampSinceVersion() {
        return 0;
    }

    public static int requestTimestampEncodingOffset() {
        return 12;
    }

    public static int requestTimestampEncodingLength() {
        return 8;
    }

    public static String requestTimestampMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public UTCTimestampNanosDecoder requestTimestamp() {
        this.requestTimestamp.wrap(this.buffer, this.offset + 12);
        return this.requestTimestamp;
    }

    public static int clientFlowId() {
        return 35516;
    }

    public static int clientFlowSinceVersion() {
        return 0;
    }

    public static int clientFlowEncodingOffset() {
        return 20;
    }

    public static int clientFlowEncodingLength() {
        return 1;
    }

    public static String clientFlowMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public short clientFlowRaw() {
        return FlowType.IDEMPOTENT.value();
    }

    public FlowType clientFlow() {
        return FlowType.IDEMPOTENT;
    }

    public static int enteringFirmId() {
        return 35501;
    }

    public static int enteringFirmSinceVersion() {
        return 0;
    }

    public static int enteringFirmEncodingOffset() {
        return 20;
    }

    public static int enteringFirmEncodingLength() {
        return 4;
    }

    public static String enteringFirmMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static long enteringFirmNullValue() {
        return 0L;
    }

    public static long enteringFirmMinValue() {
        return 0L;
    }

    public static long enteringFirmMaxValue() {
        return 0xFFFFFFFEL;
    }

    public long enteringFirm() {
        return (long)this.buffer.getInt(this.offset + 20, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
    }

    public static int negotiationRejectCodeId() {
        return 35522;
    }

    public static int negotiationRejectCodeSinceVersion() {
        return 0;
    }

    public static int negotiationRejectCodeEncodingOffset() {
        return 24;
    }

    public static int negotiationRejectCodeEncodingLength() {
        return 1;
    }

    public static String negotiationRejectCodeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public short negotiationRejectCodeRaw() {
        return (short)(this.buffer.getByte(this.offset + 24) & 0xFF);
    }

    public NegotiationRejectCode negotiationRejectCode() {
        return NegotiationRejectCode.get((short)(this.buffer.getByte(this.offset + 24) & 0xFF));
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        NegotiateRejectDecoder decoder = new NegotiateRejectDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[NegotiateReject](sbeTemplateId=");
        builder.append(3);
        builder.append("|sbeSchemaId=");
        builder.append(1);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 5) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(5);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 25) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(25);
        builder.append("):");
        builder.append("messageType=");
        builder.append((Object)this.messageType());
        builder.append('|');
        builder.append("sessionID=");
        builder.append(this.sessionID());
        builder.append('|');
        builder.append("sessionVerID=");
        builder.append(this.sessionVerID());
        builder.append('|');
        builder.append("requestTimestamp=");
        UTCTimestampNanosDecoder requestTimestamp = this.requestTimestamp();
        if (requestTimestamp != null) {
            requestTimestamp.appendTo(builder);
        } else {
            builder.append("null");
        }
        builder.append('|');
        builder.append("clientFlow=");
        builder.append((Object)this.clientFlow());
        builder.append('|');
        builder.append("enteringFirm=");
        builder.append(this.enteringFirm());
        builder.append('|');
        builder.append("negotiationRejectCode=");
        builder.append((Object)this.negotiationRejectCode());
        this.limit(originalLimit);
        return builder;
    }

    public NegotiateRejectDecoder sbeSkip() {
        this.sbeRewind();
        return this;
    }
}

