/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.PriceOptionalDecoder;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.CompositeEncoderFlyweight;

public final class PriceOptionalEncoder
implements CompositeEncoderFlyweight {
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 5;
    public static final int ENCODED_LENGTH = 8;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private int offset;
    private MutableDirectBuffer buffer;

    public PriceOptionalEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        return this;
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public int encodedLength() {
        return 8;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 5;
    }

    public static int mantissaEncodingOffset() {
        return 0;
    }

    public static int mantissaEncodingLength() {
        return 8;
    }

    public static long mantissaNullValue() {
        return Long.MIN_VALUE;
    }

    public static long mantissaMinValue() {
        return -9223372036854775807L;
    }

    public static long mantissaMaxValue() {
        return Long.MAX_VALUE;
    }

    public PriceOptionalEncoder mantissa(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int exponentEncodingOffset() {
        return 8;
    }

    public static int exponentEncodingLength() {
        return 0;
    }

    public static byte exponentNullValue() {
        return -128;
    }

    public static byte exponentMinValue() {
        return -127;
    }

    public static byte exponentMaxValue() {
        return 127;
    }

    public byte exponent() {
        return -4;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        PriceOptionalDecoder decoder = new PriceOptionalDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset);
        return decoder.appendTo(builder);
    }
}

