/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.MessageHeaderDecoder;
import b3.entrypoint.fixp.sbe.MessageType;
import b3.entrypoint.fixp.sbe.MetaAttribute;
import b3.entrypoint.fixp.sbe.SecurityResponseType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class SecurityDefinitionResponseDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 53;
    public static final int TEMPLATE_ID = 301;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 5;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final SecurityDefinitionResponseDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;
    private static final byte[] SECURITYIDSOURCE_VALUE = new byte[]{56};
    private static final byte[] SECURITYEXCHANGE_VALUE = new byte[]{66, 86, 77, 70};

    public int sbeBlockLength() {
        return 53;
    }

    public int sbeTemplateId() {
        return 301;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 5;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public SecurityDefinitionResponseDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public SecurityDefinitionResponseDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (301 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public SecurityDefinitionResponseDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int messageTypeId() {
        return 35;
    }

    public static int messageTypeSinceVersion() {
        return 0;
    }

    public static int messageTypeEncodingOffset() {
        return 0;
    }

    public static int messageTypeEncodingLength() {
        return 1;
    }

    public static String messageTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public short messageTypeRaw() {
        return MessageType.SecurityDefinitionResponse.value();
    }

    public MessageType messageType() {
        return MessageType.SecurityDefinitionResponse;
    }

    public static int securityReqIDId() {
        return 320;
    }

    public static int securityReqIDSinceVersion() {
        return 0;
    }

    public static int securityReqIDEncodingOffset() {
        return 0;
    }

    public static int securityReqIDEncodingLength() {
        return 8;
    }

    public static String securityReqIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long securityReqIDNullValue() {
        return -1L;
    }

    public static long securityReqIDMinValue() {
        return 0L;
    }

    public static long securityReqIDMaxValue() {
        return -2L;
    }

    public long securityReqID() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int securityResponseIDId() {
        return 322;
    }

    public static int securityResponseIDSinceVersion() {
        return 0;
    }

    public static int securityResponseIDEncodingOffset() {
        return 8;
    }

    public static int securityResponseIDEncodingLength() {
        return 8;
    }

    public static String securityResponseIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long securityResponseIDNullValue() {
        return -1L;
    }

    public static long securityResponseIDMinValue() {
        return 0L;
    }

    public static long securityResponseIDMaxValue() {
        return -2L;
    }

    public long securityResponseID() {
        return this.buffer.getLong(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int securityResponseTypeId() {
        return 323;
    }

    public static int securityResponseTypeSinceVersion() {
        return 0;
    }

    public static int securityResponseTypeEncodingOffset() {
        return 16;
    }

    public static int securityResponseTypeEncodingLength() {
        return 1;
    }

    public static String securityResponseTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public short securityResponseTypeRaw() {
        return (short)(this.buffer.getByte(this.offset + 16) & 0xFF);
    }

    public SecurityResponseType securityResponseType() {
        return SecurityResponseType.get((short)(this.buffer.getByte(this.offset + 16) & 0xFF));
    }

    public static int enteringTraderId() {
        return 35502;
    }

    public static int enteringTraderSinceVersion() {
        return 0;
    }

    public static int enteringTraderEncodingOffset() {
        return 17;
    }

    public static int enteringTraderEncodingLength() {
        return 5;
    }

    public static String enteringTraderMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static byte enteringTraderNullValue() {
        return 0;
    }

    public static byte enteringTraderMinValue() {
        return 32;
    }

    public static byte enteringTraderMaxValue() {
        return 126;
    }

    public static int enteringTraderLength() {
        return 5;
    }

    public byte enteringTrader(int index) {
        if (index < 0 || index >= 5) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 17 + index * 1;
        return this.buffer.getByte(pos);
    }

    public static String enteringTraderCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public int getEnteringTrader(byte[] dst, int dstOffset) {
        int length = 5;
        if (dstOffset < 0 || dstOffset > dst.length - 5) {
            throw new IndexOutOfBoundsException("Copy will go out of range: offset=" + dstOffset);
        }
        this.buffer.getBytes(this.offset + 17, dst, dstOffset, 5);
        return 5;
    }

    public String enteringTrader() {
        int end;
        byte[] dst = new byte[5];
        this.buffer.getBytes(this.offset + 17, dst, 0, 5);
        for (end = 0; end < 5 && dst[end] != 0; ++end) {
        }
        return new String(dst, 0, end, StandardCharsets.US_ASCII);
    }

    public int getEnteringTrader(Appendable value) {
        for (int i = 0; i < 5; ++i) {
            int c = this.buffer.getByte(this.offset + 17 + i) & 0xFF;
            if (c == 0) {
                return i;
            }
            try {
                value.append((char)(c > 127 ? 63 : (char)c));
                continue;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        return 5;
    }

    public static int securityIDId() {
        return 48;
    }

    public static int securityIDSinceVersion() {
        return 0;
    }

    public static int securityIDEncodingOffset() {
        return 22;
    }

    public static int securityIDEncodingLength() {
        return 8;
    }

    public static String securityIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long securityIDNullValue() {
        return -1L;
    }

    public static long securityIDMinValue() {
        return 0L;
    }

    public static long securityIDMaxValue() {
        return -2L;
    }

    public long securityID() {
        return this.buffer.getLong(this.offset + 22, ByteOrder.LITTLE_ENDIAN);
    }

    public static int securityIDSourceId() {
        return 22;
    }

    public static int securityIDSourceSinceVersion() {
        return 0;
    }

    public static int securityIDSourceEncodingOffset() {
        return 30;
    }

    public static int securityIDSourceEncodingLength() {
        return 0;
    }

    public static String securityIDSourceMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static byte securityIDSourceNullValue() {
        return 0;
    }

    public static byte securityIDSourceMinValue() {
        return 32;
    }

    public static byte securityIDSourceMaxValue() {
        return 126;
    }

    public static int securityIDSourceLength() {
        return 1;
    }

    public byte securityIDSource(int index) {
        return SECURITYIDSOURCE_VALUE[index];
    }

    public int getSecurityIDSource(byte[] dst, int offset, int length) {
        int bytesCopied = Math.min(length, 1);
        System.arraycopy(SECURITYIDSOURCE_VALUE, 0, dst, offset, bytesCopied);
        return bytesCopied;
    }

    public byte securityIDSource() {
        return 56;
    }

    public static int securityExchangeId() {
        return 207;
    }

    public static int securityExchangeSinceVersion() {
        return 0;
    }

    public static int securityExchangeEncodingOffset() {
        return 30;
    }

    public static int securityExchangeEncodingLength() {
        return 0;
    }

    public static String securityExchangeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static byte securityExchangeNullValue() {
        return 0;
    }

    public static byte securityExchangeMinValue() {
        return 32;
    }

    public static byte securityExchangeMaxValue() {
        return 126;
    }

    public static int securityExchangeLength() {
        return 4;
    }

    public byte securityExchange(int index) {
        return SECURITYEXCHANGE_VALUE[index];
    }

    public int getSecurityExchange(byte[] dst, int offset, int length) {
        int bytesCopied = Math.min(length, 4);
        System.arraycopy(SECURITYEXCHANGE_VALUE, 0, dst, offset, bytesCopied);
        return bytesCopied;
    }

    public String securityExchange() {
        return "BVMF";
    }

    public static int symbolId() {
        return 55;
    }

    public static int symbolSinceVersion() {
        return 0;
    }

    public static int symbolEncodingOffset() {
        return 30;
    }

    public static int symbolEncodingLength() {
        return 20;
    }

    public static String symbolMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static byte symbolNullValue() {
        return 0;
    }

    public static byte symbolMinValue() {
        return 32;
    }

    public static byte symbolMaxValue() {
        return 126;
    }

    public static int symbolLength() {
        return 20;
    }

    public byte symbol(int index) {
        if (index < 0 || index >= 20) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 30 + index * 1;
        return this.buffer.getByte(pos);
    }

    public static String symbolCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public int getSymbol(byte[] dst, int dstOffset) {
        int length = 20;
        if (dstOffset < 0 || dstOffset > dst.length - 20) {
            throw new IndexOutOfBoundsException("Copy will go out of range: offset=" + dstOffset);
        }
        this.buffer.getBytes(this.offset + 30, dst, dstOffset, 20);
        return 20;
    }

    public String symbol() {
        int end;
        byte[] dst = new byte[20];
        this.buffer.getBytes(this.offset + 30, dst, 0, 20);
        for (end = 0; end < 20 && dst[end] != 0; ++end) {
        }
        return new String(dst, 0, end, StandardCharsets.US_ASCII);
    }

    public int getSymbol(Appendable value) {
        for (int i = 0; i < 20; ++i) {
            int c = this.buffer.getByte(this.offset + 30 + i) & 0xFF;
            if (c == 0) {
                return i;
            }
            try {
                value.append((char)(c > 127 ? 63 : (char)c));
                continue;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        return 20;
    }

    public static int securityStrategyTypeId() {
        return 7534;
    }

    public static int securityStrategyTypeSinceVersion() {
        return 0;
    }

    public static int securityStrategyTypeEncodingOffset() {
        return 50;
    }

    public static int securityStrategyTypeEncodingLength() {
        return 3;
    }

    public static String securityStrategyTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static byte securityStrategyTypeNullValue() {
        return 0;
    }

    public static byte securityStrategyTypeMinValue() {
        return 32;
    }

    public static byte securityStrategyTypeMaxValue() {
        return 126;
    }

    public static int securityStrategyTypeLength() {
        return 3;
    }

    public byte securityStrategyType(int index) {
        if (index < 0 || index >= 3) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 50 + index * 1;
        return this.buffer.getByte(pos);
    }

    public static String securityStrategyTypeCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public int getSecurityStrategyType(byte[] dst, int dstOffset) {
        int length = 3;
        if (dstOffset < 0 || dstOffset > dst.length - 3) {
            throw new IndexOutOfBoundsException("Copy will go out of range: offset=" + dstOffset);
        }
        this.buffer.getBytes(this.offset + 50, dst, dstOffset, 3);
        return 3;
    }

    public String securityStrategyType() {
        int end;
        byte[] dst = new byte[3];
        this.buffer.getBytes(this.offset + 50, dst, 0, 3);
        for (end = 0; end < 3 && dst[end] != 0; ++end) {
        }
        return new String(dst, 0, end, StandardCharsets.US_ASCII);
    }

    public int getSecurityStrategyType(Appendable value) {
        for (int i = 0; i < 3; ++i) {
            int c = this.buffer.getByte(this.offset + 50 + i) & 0xFF;
            if (c == 0) {
                return i;
            }
            try {
                value.append((char)(c > 127 ? 63 : (char)c));
                continue;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        return 3;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        SecurityDefinitionResponseDecoder decoder = new SecurityDefinitionResponseDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int i;
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[SecurityDefinitionResponse](sbeTemplateId=");
        builder.append(301);
        builder.append("|sbeSchemaId=");
        builder.append(1);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 5) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(5);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 53) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(53);
        builder.append("):");
        builder.append("messageType=");
        builder.append((Object)this.messageType());
        builder.append('|');
        builder.append("securityReqID=");
        builder.append(this.securityReqID());
        builder.append('|');
        builder.append("securityResponseID=");
        builder.append(this.securityResponseID());
        builder.append('|');
        builder.append("securityResponseType=");
        builder.append((Object)this.securityResponseType());
        builder.append('|');
        builder.append("enteringTrader=");
        for (i = 0; i < SecurityDefinitionResponseDecoder.enteringTraderLength() && this.enteringTrader(i) > 0; ++i) {
            builder.append((char)this.enteringTrader(i));
        }
        builder.append('|');
        builder.append("securityID=");
        builder.append(this.securityID());
        builder.append('|');
        builder.append("symbol=");
        for (i = 0; i < SecurityDefinitionResponseDecoder.symbolLength() && this.symbol(i) > 0; ++i) {
            builder.append((char)this.symbol(i));
        }
        builder.append('|');
        builder.append("securityStrategyType=");
        for (i = 0; i < SecurityDefinitionResponseDecoder.securityStrategyTypeLength() && this.securityStrategyType(i) > 0; ++i) {
            builder.append((char)this.securityStrategyType(i));
        }
        this.limit(originalLimit);
        return builder;
    }

    public SecurityDefinitionResponseDecoder sbeSkip() {
        this.sbeRewind();
        return this;
    }
}

