/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.MessageHeaderDecoder;
import b3.entrypoint.fixp.sbe.MessageType;
import b3.entrypoint.fixp.sbe.MetaAttribute;
import b3.entrypoint.fixp.sbe.PriceOptionalDecoder;
import b3.entrypoint.fixp.sbe.QuoteStatus;
import b3.entrypoint.fixp.sbe.UTCTimestampNanosDecoder;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class QuoteStatusReportDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 45;
    public static final int TEMPLATE_ID = 402;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 5;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final QuoteStatusReportDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;
    private static final byte[] SECURITYIDSOURCE_VALUE = new byte[]{56};
    private static final byte[] SECURITYEXCHANGE_VALUE = new byte[]{66, 86, 77, 70};
    private final PriceOptionalDecoder price = new PriceOptionalDecoder();
    private final UTCTimestampNanosDecoder transactTime = new UTCTimestampNanosDecoder();

    public int sbeBlockLength() {
        return 45;
    }

    public int sbeTemplateId() {
        return 402;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 5;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public QuoteStatusReportDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public QuoteStatusReportDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (402 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public QuoteStatusReportDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int messageTypeId() {
        return 35;
    }

    public static int messageTypeSinceVersion() {
        return 0;
    }

    public static int messageTypeEncodingOffset() {
        return 0;
    }

    public static int messageTypeEncodingLength() {
        return 1;
    }

    public static String messageTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public short messageTypeRaw() {
        return MessageType.QuoteStatusReport.value();
    }

    public MessageType messageType() {
        return MessageType.QuoteStatusReport;
    }

    public static int quoteReqIDId() {
        return 131;
    }

    public static int quoteReqIDSinceVersion() {
        return 0;
    }

    public static int quoteReqIDEncodingOffset() {
        return 0;
    }

    public static int quoteReqIDEncodingLength() {
        return 8;
    }

    public static String quoteReqIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long quoteReqIDNullValue() {
        return -1L;
    }

    public static long quoteReqIDMinValue() {
        return 0L;
    }

    public static long quoteReqIDMaxValue() {
        return -2L;
    }

    public long quoteReqID() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int quoteIDId() {
        return 117;
    }

    public static int quoteIDSinceVersion() {
        return 0;
    }

    public static int quoteIDEncodingOffset() {
        return 8;
    }

    public static int quoteIDEncodingLength() {
        return 8;
    }

    public static String quoteIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long quoteIDNullValue() {
        return -1L;
    }

    public static long quoteIDMinValue() {
        return 0L;
    }

    public static long quoteIDMaxValue() {
        return -2L;
    }

    public long quoteID() {
        return this.buffer.getLong(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int securityIDId() {
        return 48;
    }

    public static int securityIDSinceVersion() {
        return 0;
    }

    public static int securityIDEncodingOffset() {
        return 16;
    }

    public static int securityIDEncodingLength() {
        return 8;
    }

    public static String securityIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long securityIDNullValue() {
        return -1L;
    }

    public static long securityIDMinValue() {
        return 0L;
    }

    public static long securityIDMaxValue() {
        return -2L;
    }

    public long securityID() {
        return this.buffer.getLong(this.offset + 16, ByteOrder.LITTLE_ENDIAN);
    }

    public static int securityIDSourceId() {
        return 22;
    }

    public static int securityIDSourceSinceVersion() {
        return 0;
    }

    public static int securityIDSourceEncodingOffset() {
        return 24;
    }

    public static int securityIDSourceEncodingLength() {
        return 0;
    }

    public static String securityIDSourceMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static byte securityIDSourceNullValue() {
        return 0;
    }

    public static byte securityIDSourceMinValue() {
        return 32;
    }

    public static byte securityIDSourceMaxValue() {
        return 126;
    }

    public static int securityIDSourceLength() {
        return 1;
    }

    public byte securityIDSource(int index) {
        return SECURITYIDSOURCE_VALUE[index];
    }

    public int getSecurityIDSource(byte[] dst, int offset, int length) {
        int bytesCopied = Math.min(length, 1);
        System.arraycopy(SECURITYIDSOURCE_VALUE, 0, dst, offset, bytesCopied);
        return bytesCopied;
    }

    public byte securityIDSource() {
        return 56;
    }

    public static int securityExchangeId() {
        return 207;
    }

    public static int securityExchangeSinceVersion() {
        return 0;
    }

    public static int securityExchangeEncodingOffset() {
        return 24;
    }

    public static int securityExchangeEncodingLength() {
        return 0;
    }

    public static String securityExchangeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static byte securityExchangeNullValue() {
        return 0;
    }

    public static byte securityExchangeMinValue() {
        return 32;
    }

    public static byte securityExchangeMaxValue() {
        return 126;
    }

    public static int securityExchangeLength() {
        return 4;
    }

    public byte securityExchange(int index) {
        return SECURITYEXCHANGE_VALUE[index];
    }

    public int getSecurityExchange(byte[] dst, int offset, int length) {
        int bytesCopied = Math.min(length, 4);
        System.arraycopy(SECURITYEXCHANGE_VALUE, 0, dst, offset, bytesCopied);
        return bytesCopied;
    }

    public String securityExchange() {
        return "BVMF";
    }

    public static int priceId() {
        return 44;
    }

    public static int priceSinceVersion() {
        return 0;
    }

    public static int priceEncodingOffset() {
        return 24;
    }

    public static int priceEncodingLength() {
        return 8;
    }

    public static String priceMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public PriceOptionalDecoder price() {
        this.price.wrap(this.buffer, this.offset + 24);
        return this.price;
    }

    public static int transactTimeId() {
        return 60;
    }

    public static int transactTimeSinceVersion() {
        return 0;
    }

    public static int transactTimeEncodingOffset() {
        return 32;
    }

    public static int transactTimeEncodingLength() {
        return 8;
    }

    public static String transactTimeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public UTCTimestampNanosDecoder transactTime() {
        this.transactTime.wrap(this.buffer, this.offset + 32);
        return this.transactTime;
    }

    public static int quoteRejectReasonId() {
        return 300;
    }

    public static int quoteRejectReasonSinceVersion() {
        return 0;
    }

    public static int quoteRejectReasonEncodingOffset() {
        return 40;
    }

    public static int quoteRejectReasonEncodingLength() {
        return 4;
    }

    public static String quoteRejectReasonMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static long quoteRejectReasonNullValue() {
        return 0L;
    }

    public static long quoteRejectReasonMinValue() {
        return 0L;
    }

    public static long quoteRejectReasonMaxValue() {
        return 0xFFFFFFFEL;
    }

    public long quoteRejectReason() {
        return (long)this.buffer.getInt(this.offset + 40, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL;
    }

    public static int quoteStatusId() {
        return 297;
    }

    public static int quoteStatusSinceVersion() {
        return 0;
    }

    public static int quoteStatusEncodingOffset() {
        return 44;
    }

    public static int quoteStatusEncodingLength() {
        return 1;
    }

    public static String quoteStatusMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public short quoteStatusRaw() {
        return (short)(this.buffer.getByte(this.offset + 44) & 0xFF);
    }

    public QuoteStatus quoteStatus() {
        return QuoteStatus.get((short)(this.buffer.getByte(this.offset + 44) & 0xFF));
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        QuoteStatusReportDecoder decoder = new QuoteStatusReportDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[QuoteStatusReport](sbeTemplateId=");
        builder.append(402);
        builder.append("|sbeSchemaId=");
        builder.append(1);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 5) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(5);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 45) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(45);
        builder.append("):");
        builder.append("messageType=");
        builder.append((Object)this.messageType());
        builder.append('|');
        builder.append("quoteReqID=");
        builder.append(this.quoteReqID());
        builder.append('|');
        builder.append("quoteID=");
        builder.append(this.quoteID());
        builder.append('|');
        builder.append("securityID=");
        builder.append(this.securityID());
        builder.append('|');
        builder.append("price=");
        PriceOptionalDecoder price = this.price();
        if (price != null) {
            price.appendTo(builder);
        } else {
            builder.append("null");
        }
        builder.append('|');
        builder.append("transactTime=");
        UTCTimestampNanosDecoder transactTime = this.transactTime();
        if (transactTime != null) {
            transactTime.appendTo(builder);
        } else {
            builder.append("null");
        }
        builder.append('|');
        builder.append("quoteRejectReason=");
        builder.append(this.quoteRejectReason());
        builder.append('|');
        builder.append("quoteStatus=");
        builder.append((Object)this.quoteStatus());
        this.limit(originalLimit);
        return builder;
    }

    public QuoteStatusReportDecoder sbeSkip() {
        this.sbeRewind();
        return this;
    }
}

