/*
 * Decompiled with CFR 0.152.
 */
package uk.co.markormesher.android_fab;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.DrawableRes;
import android.support.v7.widget.CardView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.util.ArrayList;
import uk.co.markormesher.android_fab.FloatingActionButton$$Lambda$1;
import uk.co.markormesher.android_fab.FloatingActionButton$$Lambda$4;
import uk.co.markormesher.android_fab.FloatingActionButton$$Lambda$5;
import uk.co.markormesher.android_fab.SpeedDialMenuAdapter;
import uk.co.markormesher.android_fab.fab.R;

public class FloatingActionButton
extends RelativeLayout {
    private static final long SPEED_DIAL_ANIMATION_DURATION = 200L;
    private static final long HIDE_SHOW_ANIMATION_DURATION = 100L;
    private RelativeLayout fabContainer;
    private ViewGroup button;
    private ViewGroup iconContainer;
    private View coverView;
    private boolean shown = true;
    private View.OnClickListener clickListener;
    private OnSpeedDialOpenListener speedDialOpenListener;
    private OnSpeedDialCloseListener speedDialCloseListener;
    private boolean speedDialMenuOpen = false;
    private boolean speedDialInternallyDisabled = false;
    private boolean busyAnimatingFabIcon = false;
    private boolean busyAnimatingSpeedDialCover = false;
    private boolean busyAnimatingSpeedDialMenu = false;
    private SpeedDialMenuAdapter menuAdapter;
    private ArrayList<View> speedDialMenuItems;
    private int savedIconResId = -1;
    private int savedBgColour = 4149685;

    public FloatingActionButton(Context context) {
        super(context);
        this.initView();
    }

    public FloatingActionButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public FloatingActionButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    private void initView() {
        FloatingActionButton.inflate((Context)this.getContext(), (int)R.layout.floating_action_button, (ViewGroup)this);
        this.fabContainer = (RelativeLayout)this.findViewById(R.id.fab_container);
        this.button = (ViewGroup)this.findViewById(R.id.card);
        this.iconContainer = (ViewGroup)this.findViewById(R.id.icon_container);
        this.coverView = this.findViewById(R.id.cover);
        this.coverView.setAlpha(0.0f);
        this.button.setClickable(true);
        this.button.setFocusable(true);
        this.button.setOnClickListener(FloatingActionButton$$Lambda$1.lambdaFactory$(this));
        this.setSaveEnabled(true);
    }

    public void setIcon(View icon) {
        this.resetIcon();
        if (icon != null) {
            if (icon.getParent() != null) {
                ((ViewGroup)icon.getParent()).removeView(icon);
            }
            this.iconContainer.addView(icon);
        }
    }

    public void setIcon(Drawable icon) {
        this.resetIcon();
        if (icon != null) {
            if (Build.VERSION.SDK_INT >= 16) {
                this.iconContainer.setBackground(icon);
            } else {
                this.iconContainer.setBackgroundDrawable(icon);
            }
        }
    }

    public void setIcon(@DrawableRes int icon) {
        this.resetIcon();
        this.savedIconResId = icon;
        this.iconContainer.setBackgroundResource(icon);
    }

    private void resetIcon() {
        this.savedIconResId = -1;
        this.iconContainer.removeAllViews();
        this.iconContainer.setBackgroundResource(0);
        if (Build.VERSION.SDK_INT >= 16) {
            this.iconContainer.setBackground(null);
        } else {
            this.iconContainer.setBackgroundDrawable(null);
        }
    }

    public void setBackgroundColour(int colour) {
        this.savedBgColour = colour;
        if (Build.VERSION.SDK_INT >= 21) {
            ((CardView)this.button).setCardBackgroundColor(colour);
        } else {
            ((GradientDrawable)this.button.getBackground()).setColor(colour);
        }
    }

    public void hide() {
        this.hide(false);
    }

    private void hide(boolean fast) {
        if (!this.shown && !fast) {
            return;
        }
        this.closeSpeedDialMenu();
        this.button.clearAnimation();
        this.button.animate().scaleX(0.0f).scaleY(0.0f).setDuration(fast ? 0L : 100L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                FloatingActionButton.this.button.setVisibility(8);
                FloatingActionButton.this.shown = false;
            }
        });
    }

    public void show() {
        if (this.shown) {
            return;
        }
        this.button.setVisibility(0);
        this.button.clearAnimation();
        this.button.animate().scaleX(1.0f).scaleY(1.0f).setDuration(100L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                FloatingActionButton.this.shown = true;
            }
        });
    }

    public boolean isShown() {
        return this.shown;
    }

    public RelativeLayout getFabContainer() {
        return this.fabContainer;
    }

    public ViewGroup getCardView() {
        return this.getButton();
    }

    public ViewGroup getButton() {
        return this.button;
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.clickListener = listener;
    }

    public void setOnSpeedDialOpenListener(OnSpeedDialOpenListener listener) {
        this.speedDialOpenListener = listener;
    }

    public void setOnSpeedDialCloseListener(OnSpeedDialCloseListener listener) {
        this.speedDialCloseListener = listener;
    }

    private void onClick() {
        if (!this.speedDialInternallyDisabled && this.menuAdapter != null && this.menuAdapter.isEnabled()) {
            this.toggleSpeedDialMenu();
        } else if (this.clickListener != null) {
            this.clickListener.onClick((View)this);
        }
    }

    public void setMenuAdapter(SpeedDialMenuAdapter menuAdapter) {
        this.menuAdapter = menuAdapter;
        if (menuAdapter != null) {
            this.rebuildSpeedDialMenu();
        }
    }

    @SuppressLint(value={"InlinedApi"})
    public void rebuildSpeedDialMenu() {
        if (this.menuAdapter.getCount() == 0) {
            Log.w((String)"ANDROID_FAB", (String)"SpeedDialMenuAdapter contained zero items; speed-dial functionality was disabled.");
            this.speedDialInternallyDisabled = true;
            return;
        }
        this.speedDialInternallyDisabled = false;
        this.speedDialMenuItems = new ArrayList(this.menuAdapter.getCount());
        for (int i = this.menuAdapter.getCount() - 1; i >= 0; --i) {
            TextView tv;
            View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.speed_dial_icon, null);
            this.fabContainer.addView(view, 1);
            this.speedDialMenuItems.add(view);
            if (Build.VERSION.SDK_INT >= 21) {
                ((CardView)view.findViewById(R.id.card)).setCardBackgroundColor(this.menuAdapter.getBackgroundColour(i));
            } else {
                ((GradientDrawable)view.findViewById(R.id.card).getBackground()).setColor(this.menuAdapter.getBackgroundColour(i));
            }
            SpeedDialMenuAdapter.MenuItem itemViews = this.menuAdapter.getViews(this.getContext(), i);
            ViewGroup iconContainer = (ViewGroup)view.findViewById(R.id.icon_container);
            if (itemViews.iconView != null) {
                iconContainer.addView(itemViews.iconView, 0);
            } else if (itemViews.iconDrawable != null) {
                if (Build.VERSION.SDK_INT >= 16) {
                    iconContainer.setBackground(itemViews.iconDrawable);
                } else {
                    iconContainer.setBackgroundDrawable(itemViews.iconDrawable);
                }
            } else if (itemViews.iconDrawableId > 0) {
                iconContainer.setBackgroundResource(itemViews.iconDrawableId);
            }
            ViewGroup itemContainer = (ViewGroup)view.findViewById(R.id.speed_dial_item_container);
            if (itemViews.labelView != null) {
                itemContainer.addView(itemViews.labelView, 0);
            } else if (itemViews.labelString != null) {
                tv = new TextView(this.getContext());
                tv.setText((CharSequence)itemViews.labelString);
                itemContainer.addView((View)tv, 0);
            } else if (itemViews.labelStringId > 0) {
                tv = new TextView(this.getContext());
                tv.setText(itemViews.labelStringId);
                itemContainer.addView((View)tv, 0);
            }
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)view.getLayoutParams();
            params.addRule(11);
            if (Build.VERSION.SDK_INT >= 17) {
                params.addRule(21);
            }
            params.addRule(12);
            view.setLayoutParams((ViewGroup.LayoutParams)params);
            view.setAlpha(0.0f);
            view.setVisibility(8);
            view.setTag((Object)i);
            view.setOnClickListener(FloatingActionButton$$Lambda$4.lambdaFactory$(this));
        }
    }

    public void closeSpeedDialMenu() {
        if (this.speedDialMenuOpen) {
            this.toggleSpeedDialMenu();
        }
    }

    public void openSpeedDialMenu() {
        if (!this.speedDialMenuOpen && this.shown) {
            this.toggleSpeedDialMenu();
        }
    }

    private void toggleSpeedDialMenu() {
        if (this.busyAnimatingFabIcon || this.busyAnimatingSpeedDialCover || this.busyAnimatingSpeedDialMenu) {
            return;
        }
        boolean bl = this.speedDialMenuOpen = !this.speedDialMenuOpen;
        if (this.speedDialMenuOpen && this.speedDialOpenListener != null) {
            this.speedDialOpenListener.onOpen(this);
        }
        if (!this.speedDialMenuOpen && this.speedDialCloseListener != null) {
            this.speedDialCloseListener.onClose(this);
        }
        if (this.menuAdapter.rotateFab()) {
            this.toggleFabIconForSpeedDialMenu(this.speedDialMenuOpen);
        }
        this.setSpeedDialCoverVisible(this.speedDialMenuOpen);
        this.setSpeedDialMenuVisible(this.speedDialMenuOpen);
        this.coverView.setClickable(this.speedDialMenuOpen);
        this.coverView.setFocusable(this.speedDialMenuOpen);
        if (this.speedDialMenuOpen) {
            this.coverView.setOnClickListener(FloatingActionButton$$Lambda$5.lambdaFactory$(this));
        } else {
            this.coverView.setOnClickListener(null);
        }
    }

    private void toggleFabIconForSpeedDialMenu(boolean visible) {
        if (this.busyAnimatingFabIcon) {
            return;
        }
        this.busyAnimatingFabIcon = true;
        this.iconContainer.animate().rotation(visible ? 45.0f : 0.0f).setDuration(200L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                FloatingActionButton.this.busyAnimatingFabIcon = false;
            }
        });
    }

    private void setSpeedDialCoverVisible(final boolean visible) {
        if (this.busyAnimatingSpeedDialCover) {
            return;
        }
        this.busyAnimatingSpeedDialCover = true;
        this.coverView.setVisibility(0);
        this.coverView.animate().scaleX(visible ? 50.0f : 0.0f).scaleY(visible ? 50.0f : 0.0f).alpha(visible ? 1.0f : 0.0f).setDuration(200L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                FloatingActionButton.this.busyAnimatingSpeedDialCover = false;
                if (!visible) {
                    FloatingActionButton.this.coverView.setVisibility(8);
                }
            }
        });
    }

    private void setSpeedDialMenuVisible(final boolean visible) {
        if (this.busyAnimatingSpeedDialMenu) {
            return;
        }
        this.busyAnimatingSpeedDialMenu = true;
        int distance = this.button.getHeight();
        int n = this.speedDialMenuItems.size();
        for (int i = 0; i < n; ++i) {
            final View v = this.speedDialMenuItems.get(i);
            if (visible) {
                v.setVisibility(0);
            }
            v.animate().translationY(visible ? (float)((i + 1) * distance * -1 - distance / 8) : 0.0f).alpha(visible ? 1.0f : 0.0f).setDuration(200L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    FloatingActionButton.this.busyAnimatingSpeedDialMenu = false;
                    if (!visible) {
                        v.setVisibility(8);
                    }
                }
            });
        }
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putBoolean("shown", this.shown);
        bundle.putInt("savedIconResId", this.savedIconResId);
        bundle.putInt("savedBgColour", this.savedBgColour);
        bundle.putParcelable("SUPER", super.onSaveInstanceState());
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state != null && state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            if (bundle.containsKey("shown") && !bundle.getBoolean("shown")) {
                this.hide(true);
            }
            if (bundle.containsKey("savedIconResId")) {
                this.savedIconResId = bundle.getInt("savedIconResId");
                if (this.savedIconResId > -1) {
                    this.setIcon(this.savedIconResId);
                }
            }
            if (bundle.containsKey("savedBgColour")) {
                this.savedBgColour = bundle.getInt("savedBgColour");
                Log.d((String)"ANDROID_FAB", (String)("" + this.savedBgColour));
                this.setBackgroundColour(this.savedBgColour);
            }
            state = bundle.getParcelable("SUPER");
        }
        super.onRestoreInstanceState(state);
    }

    private /* synthetic */ void lambda$toggleSpeedDialMenu$2(View v) {
        this.toggleSpeedDialMenu();
    }

    private /* synthetic */ void lambda$rebuildSpeedDialMenu$1(View v) {
        if (this.menuAdapter.onMenuItemClick((Integer)v.getTag())) {
            this.closeSpeedDialMenu();
        }
    }

    private /* synthetic */ void lambda$initView$0(View v) {
        this.onClick();
    }

    static /* synthetic */ void access$lambda$0(FloatingActionButton floatingActionButton, View view) {
        floatingActionButton.lambda$initView$0(view);
    }

    static /* synthetic */ void access$lambda$1(FloatingActionButton floatingActionButton, View view) {
        floatingActionButton.lambda$rebuildSpeedDialMenu$1(view);
    }

    static /* synthetic */ void access$lambda$2(FloatingActionButton floatingActionButton, View view) {
        floatingActionButton.lambda$toggleSpeedDialMenu$2(view);
    }

    public static interface OnSpeedDialCloseListener {
        public void onClose(FloatingActionButton var1);
    }

    public static interface OnSpeedDialOpenListener {
        public void onOpen(FloatingActionButton var1);
    }
}

