/*
 * Decompiled with CFR 0.152.
 */
package uk.co.chrisjenx.calligraphy;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Typeface;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import java.lang.reflect.Method;
import uk.co.chrisjenx.calligraphy.CalligraphyConfig;
import uk.co.chrisjenx.calligraphy.CalligraphyUtils;
import uk.co.chrisjenx.calligraphy.HasTypeface;
import uk.co.chrisjenx.calligraphy.R;
import uk.co.chrisjenx.calligraphy.ReflectionUtils;
import uk.co.chrisjenx.calligraphy.TypefaceUtils;

class CalligraphyFactory {
    private static final String ACTION_BAR_TITLE = "action_bar_title";
    private static final String ACTION_BAR_SUBTITLE = "action_bar_subtitle";
    private final int[] mAttributeId;

    protected static int[] getStyleForTextView(TextView view) {
        int[] styleIds = new int[]{-1, -1};
        if (CalligraphyFactory.isActionBarTitle(view)) {
            styleIds[0] = 16843470;
            styleIds[1] = 16843512;
        } else if (CalligraphyFactory.isActionBarSubTitle(view)) {
            styleIds[0] = 16843470;
            styleIds[1] = 16843513;
        }
        if (styleIds[0] == -1) {
            styleIds[0] = CalligraphyConfig.get().getClassStyles().containsKey(view.getClass()) ? CalligraphyConfig.get().getClassStyles().get(view.getClass()) : 16842804;
        }
        return styleIds;
    }

    @SuppressLint(value={"NewApi"})
    protected static boolean isActionBarTitle(TextView view) {
        if (CalligraphyFactory.matchesResourceIdName((View)view, ACTION_BAR_TITLE)) {
            return true;
        }
        if (CalligraphyFactory.parentIsToolbarV7((View)view)) {
            Toolbar parent = (Toolbar)view.getParent();
            return TextUtils.equals((CharSequence)parent.getTitle(), (CharSequence)view.getText());
        }
        return false;
    }

    @SuppressLint(value={"NewApi"})
    protected static boolean isActionBarSubTitle(TextView view) {
        if (CalligraphyFactory.matchesResourceIdName((View)view, ACTION_BAR_SUBTITLE)) {
            return true;
        }
        if (CalligraphyFactory.parentIsToolbarV7((View)view)) {
            Toolbar parent = (Toolbar)view.getParent();
            return TextUtils.equals((CharSequence)parent.getSubtitle(), (CharSequence)view.getText());
        }
        return false;
    }

    protected static boolean parentIsToolbarV7(View view) {
        return CalligraphyUtils.canCheckForV7Toolbar() && view.getParent() != null && view.getParent() instanceof Toolbar;
    }

    protected static boolean matchesResourceIdName(View view, String matches) {
        if (view.getId() == -1) {
            return false;
        }
        String resourceEntryName = view.getResources().getResourceEntryName(view.getId());
        return resourceEntryName.equalsIgnoreCase(matches);
    }

    public CalligraphyFactory(int attributeId) {
        this.mAttributeId = new int[]{attributeId};
    }

    public View onViewCreated(View view, Context context, AttributeSet attrs) {
        if (view != null && view.getTag(R.id.calligraphy_tag_id) != Boolean.TRUE) {
            this.onViewCreatedInternal(view, context, attrs);
            view.setTag(R.id.calligraphy_tag_id, (Object)Boolean.TRUE);
        }
        return view;
    }

    void onViewCreatedInternal(View view, Context context, AttributeSet attrs) {
        if (view instanceof TextView) {
            if (TypefaceUtils.isLoaded(((TextView)view).getTypeface())) {
                return;
            }
            String textViewFont = this.resolveFontPath(context, attrs);
            if (TextUtils.isEmpty((CharSequence)textViewFont)) {
                int[] styleForTextView = CalligraphyFactory.getStyleForTextView((TextView)view);
                textViewFont = styleForTextView[1] != -1 ? CalligraphyUtils.pullFontPathFromTheme(context, styleForTextView[0], styleForTextView[1], this.mAttributeId) : CalligraphyUtils.pullFontPathFromTheme(context, styleForTextView[0], this.mAttributeId);
            }
            boolean deferred = CalligraphyFactory.matchesResourceIdName(view, ACTION_BAR_TITLE) || CalligraphyFactory.matchesResourceIdName(view, ACTION_BAR_SUBTITLE);
            CalligraphyUtils.applyFontToTextView(context, (TextView)view, CalligraphyConfig.get(), textViewFont, deferred);
        }
        if (CalligraphyUtils.canCheckForV7Toolbar() && view instanceof Toolbar) {
            this.applyFontToToolbar((Toolbar)view);
        }
        if (view instanceof HasTypeface) {
            Typeface typeface = this.getDefaultTypeface(context, this.resolveFontPath(context, attrs));
            if (typeface != null) {
                ((HasTypeface)view).setTypeface(typeface);
            }
        } else if (CalligraphyConfig.get().isCustomViewTypefaceSupport() && CalligraphyConfig.get().isCustomViewHasTypeface(view)) {
            Method setTypeface = ReflectionUtils.getMethod(view.getClass(), "setTypeface");
            String fontPath = this.resolveFontPath(context, attrs);
            Typeface typeface = this.getDefaultTypeface(context, fontPath);
            if (setTypeface != null && typeface != null) {
                ReflectionUtils.invokeMethod(view, setTypeface, typeface);
            }
        }
    }

    private Typeface getDefaultTypeface(Context context, String fontPath) {
        if (TextUtils.isEmpty((CharSequence)fontPath)) {
            fontPath = CalligraphyConfig.get().getFontPath();
        }
        if (!TextUtils.isEmpty((CharSequence)fontPath)) {
            return TypefaceUtils.load(context.getAssets(), fontPath);
        }
        return null;
    }

    private String resolveFontPath(Context context, AttributeSet attrs) {
        String textViewFont = CalligraphyUtils.pullFontPathFromView(context, attrs, this.mAttributeId);
        if (TextUtils.isEmpty((CharSequence)textViewFont)) {
            textViewFont = CalligraphyUtils.pullFontPathFromStyle(context, attrs, this.mAttributeId);
        }
        if (TextUtils.isEmpty((CharSequence)textViewFont)) {
            textViewFont = CalligraphyUtils.pullFontPathFromTextAppearance(context, attrs, this.mAttributeId);
        }
        return textViewFont;
    }

    private void applyFontToToolbar(Toolbar view) {
        CharSequence previousTitle = view.getTitle();
        CharSequence previousSubtitle = view.getSubtitle();
        view.setTitle((CharSequence)" ");
        view.setSubtitle((CharSequence)" ");
        int childCount = view.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            this.onViewCreated(view.getChildAt(i), view.getContext(), null);
        }
        view.setTitle(previousTitle);
        view.setSubtitle(previousSubtitle);
    }
}

