/*
 * Decompiled with CFR 0.152.
 */
package uk.co.chrisjenx.calligraphy;

import android.os.Build;
import android.text.TextUtils;
import uk.co.chrisjenx.calligraphy.R;

public class CalligraphyConfig {
    private static CalligraphyConfig sInstance;
    private final boolean mIsFontSet;
    private final String mFontPath;
    private final int mAttrId;
    private final boolean mReflection;
    private final boolean mCustomViewCreation;

    public static void initDefault(CalligraphyConfig calligraphyConfig) {
        sInstance = calligraphyConfig;
    }

    public static CalligraphyConfig get() {
        if (sInstance == null) {
            sInstance = new CalligraphyConfig(new Builder());
        }
        return sInstance;
    }

    protected CalligraphyConfig(Builder builder) {
        this.mIsFontSet = builder.isFontSet;
        this.mFontPath = builder.fontAssetPath;
        this.mAttrId = builder.attrId;
        this.mReflection = builder.reflection;
        this.mCustomViewCreation = builder.customViewCreation;
    }

    public String getFontPath() {
        return this.mFontPath;
    }

    boolean isFontSet() {
        return this.mIsFontSet;
    }

    public boolean isReflection() {
        return this.mReflection;
    }

    public boolean isCustomViewCreation() {
        return this.mCustomViewCreation;
    }

    public int getAttrId() {
        return this.mAttrId;
    }

    public static class Builder {
        public static final int INVALID_ATTR_ID = -1;
        private boolean reflection = Build.VERSION.SDK_INT >= 11;
        private boolean customViewCreation = true;
        private int attrId = R.attr.fontPath;
        private boolean isFontSet = false;
        private String fontAssetPath = null;

        public Builder setFontAttrId(int fontAssetAttrId) {
            this.attrId = fontAssetAttrId != -1 ? fontAssetAttrId : -1;
            return this;
        }

        public Builder setDefaultFontPath(String defaultFontAssetPath) {
            this.isFontSet = !TextUtils.isEmpty((CharSequence)defaultFontAssetPath);
            this.fontAssetPath = defaultFontAssetPath;
            return this;
        }

        public void disablePrivateFactoryInjection() {
            this.reflection = false;
        }

        public void disableCustomViewInflation() {
            this.customViewCreation = false;
        }

        public CalligraphyConfig build() {
            this.isFontSet = !TextUtils.isEmpty((CharSequence)this.fontAssetPath);
            return new CalligraphyConfig(this);
        }
    }
}

