/*
 * Decompiled with CFR 0.152.
 */
package uk.co.chrisjenx.calligraphy;

import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.util.Log;
import java.util.HashMap;

public final class TypefaceUtils {
    private static final HashMap<String, Typeface> sCachedFonts = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Typeface load(AssetManager assetManager, String filePath) {
        HashMap<String, Typeface> hashMap = sCachedFonts;
        synchronized (hashMap) {
            try {
                if (!sCachedFonts.containsKey(filePath)) {
                    Typeface typeface = Typeface.createFromAsset((AssetManager)assetManager, (String)filePath);
                    sCachedFonts.put(filePath, typeface);
                    return typeface;
                }
            }
            catch (Exception e) {
                Log.w((String)"Calligraphy", (String)("Can't create asset from " + filePath + ". Make sure you have passed in the correct path and file name."), (Throwable)e);
                sCachedFonts.put(filePath, null);
                return null;
            }
            return sCachedFonts.get(filePath);
        }
    }

    private TypefaceUtils() {
    }
}

