/*
 * Decompiled with CFR 0.152.
 */
package uk.co.chrisjenx.calligraphy;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.widget.TextView;
import uk.co.chrisjenx.calligraphy.CalligraphyConfig;
import uk.co.chrisjenx.calligraphy.TypefaceUtils;

public final class CalligraphyUtils {
    public static final boolean applyFontToTextView(TextView textView, Typeface typeface) {
        if (textView == null || typeface == null) {
            return false;
        }
        textView.setTypeface(typeface);
        textView.setPaintFlags(textView.getPaintFlags() | 0x80);
        return true;
    }

    public static final boolean applyFontToTextView(Context context, TextView textView, String filePath) {
        if (textView == null || context == null) {
            return false;
        }
        AssetManager assetManager = context.getAssets();
        Typeface typeface = TypefaceUtils.load(assetManager, filePath);
        return CalligraphyUtils.applyFontToTextView(textView, typeface);
    }

    public static final void applyFontToTextView(Context context, TextView textView, CalligraphyConfig config) {
        if (context == null || textView == null || config == null) {
            return;
        }
        if (!config.isFontSet()) {
            return;
        }
        CalligraphyUtils.applyFontToTextView(context, textView, config.getFontPath());
    }

    public static void applyFontToTextView(Context context, TextView textView, CalligraphyConfig config, String textViewFont) {
        if (context == null || textView == null || config == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)textViewFont) && CalligraphyUtils.applyFontToTextView(context, textView, textViewFont)) {
            return;
        }
        CalligraphyUtils.applyFontToTextView(context, textView, config);
    }

    static final String pullFontPath(Context context, AttributeSet attrs, int attributeId) {
        String attributeName;
        try {
            attributeName = context.getResources().getResourceEntryName(attributeId);
        }
        catch (Resources.NotFoundException e) {
            return null;
        }
        int stringResourceId = attrs.getAttributeResourceValue(null, attributeName, -1);
        return stringResourceId > 0 ? context.getString(stringResourceId) : attrs.getAttributeValue(null, attributeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final String pullFontPathFromStyle(Context context, AttributeSet attrs, int attributeId) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, new int[]{attributeId});
        try {
            String string = typedArray.getString(0);
            return string;
        }
        catch (Exception ignore) {
            String string = null;
            return string;
        }
        finally {
            typedArray.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final String pullFontPathFromTheme(Context context, int styleId, int attributeId) {
        Resources.Theme theme = context.getTheme();
        TypedValue value = new TypedValue();
        theme.resolveAttribute(styleId, value, true);
        TypedArray typedArray = theme.obtainStyledAttributes(value.resourceId, new int[]{attributeId});
        try {
            String string = typedArray.getString(0);
            return string;
        }
        catch (Exception ignore) {
            String string = null;
            return string;
        }
        finally {
            typedArray.recycle();
        }
    }

    private CalligraphyUtils() {
    }
}

