/*
 * Decompiled with CFR 0.152.
 */
package uk.co.baconi.secure.api.password;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import uk.co.baconi.secure.base.pagination.PaginatedResult;
import uk.co.baconi.secure.base.password.Password;
import uk.co.baconi.secure.base.password.PasswordGraphRepository;

@Validated
@RestController
@RequestMapping(value={"/passwords"}, produces={"application/json; charset=UTF-8"})
public class PasswordEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(PasswordEndpoint.class);
    @Autowired
    private PasswordGraphRepository passwordGraphRepository;

    @RequestMapping(method={RequestMethod.GET})
    public ResponseEntity<PaginatedResult<Password>> get(@Min(value=0L, message="{uk.co.baconi.secure.api.Page.min}") @RequestParam(required=false, defaultValue="0") Integer page, @Min(value=1L, message="{uk.co.baconi.secure.api.PerPage.min}") @Max(value=20L, message="{uk.co.baconi.secure.api.PerPage.max}") @RequestParam(required=false, defaultValue="5") Integer perPage) {
        Page paged = this.passwordGraphRepository.findAll((Pageable)new PageRequest(page.intValue(), perPage.intValue()));
        LOG.trace("paged: {}", (Object)paged);
        PaginatedResult paginatedResult = new PaginatedResult(paged);
        LOG.trace("paginatedResult: {}", (Object)paginatedResult);
        return ResponseEntity.ok((Object)paginatedResult);
    }
}

