/*
 * Decompiled with CFR 0.152.
 */
package uk.co.baconi.secure.api.exceptions;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import uk.co.baconi.secure.api.exceptions.BaseErrorResponse;

public class ValidationResponse
implements BaseErrorResponse {
    private final UUID uuid = UUID.randomUUID();
    private final List<String> errors;

    private ValidationResponse(List<String> errors) {
        this.errors = errors;
    }

    public ValidationResponse(ConstraintViolationException exception) {
        this(exception.getConstraintViolations().stream().map(ConstraintViolation::getMessage).collect(Collectors.toList()));
    }

    public ValidationResponse(MethodArgumentTypeMismatchException exception) {
        this(Collections.singletonList(String.format("Param '%s' requires type '%s' but was provided '%s'", exception.getName(), exception.getRequiredType().getName(), exception.getValue())));
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public String toString() {
        return "ValidationResponse{uuid=" + this.uuid + ", errors='" + this.errors + '\'' + '}';
    }
}

