/*
 * Decompiled with CFR 0.152.
 */
package uk.co.autotrader.traverson.link.hal;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import uk.co.autotrader.traverson.link.hal.HalEntityResolver;

class EmbeddedResolver
implements HalEntityResolver {
    EmbeddedResolver() {
    }

    @Override
    public JSONArray findJSONArrayRelation(JSONObject halResource, String relationType) {
        JSONObject embeddedResources = this.getEmbeddedSection(halResource);
        if (embeddedResources == null) {
            return new JSONArray();
        }
        Object maybeJsonArray = embeddedResources.get(relationType);
        if (!(maybeJsonArray instanceof JSONArray)) {
            return new JSONArray();
        }
        return (JSONArray)maybeJsonArray;
    }

    @Override
    public String resolveLink(JSONObject jsonObject) {
        return jsonObject.getJSONObject("_links").getJSONObject("self").getString("href");
    }

    @Override
    public Map<String, SortedSet<String>> describeRelations(JSONObject resource) {
        JSONObject embeddedResources = this.getEmbeddedSection(resource);
        HashMap<String, SortedSet<String>> relations = new HashMap<String, SortedSet<String>>();
        if (embeddedResources != null) {
            TreeSet sortedRels = new TreeSet();
            sortedRels.addAll(embeddedResources.keySet());
            relations.put("'_embedded'", sortedRels);
        }
        return relations;
    }

    private JSONObject getEmbeddedSection(JSONObject halResource) {
        return halResource.getJSONObject("_embedded");
    }
}

