/*
 * Decompiled with CFR 0.152.
 */
package uk.co.autotrader.traverson.conversion;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import uk.co.autotrader.traverson.conversion.ResourceConverter;
import uk.co.autotrader.traverson.exception.ConversionException;

class StringResourceConverter
implements ResourceConverter<String> {
    StringResourceConverter() {
    }

    @Override
    public Class<String> getDestinationType() {
        return String.class;
    }

    @Override
    public String convert(InputStream resource, Class<? extends String> returnType) {
        String string;
        block8: {
            InputStream streamToProcess = resource;
            try {
                string = new String(streamToProcess.readAllBytes(), StandardCharsets.UTF_8);
                if (streamToProcess == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (streamToProcess != null) {
                        try {
                            streamToProcess.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ConversionException("Failed to convert the input stream to a string", null, e);
                }
            }
            streamToProcess.close();
        }
        return string;
    }
}

