/*
 * Decompiled with CFR 0.152.
 */
package uk.co.autotrader.traverson.http;

import java.util.Arrays;
import uk.co.autotrader.traverson.http.Body;

public class SimpleMultipartBody
implements Body<BodyPart[]> {
    private final BodyPart[] bodyParts;

    public SimpleMultipartBody(BodyPart ... bodyParts) {
        this.bodyParts = Arrays.copyOf(bodyParts, bodyParts.length);
    }

    @Override
    public BodyPart[] getContent() {
        return Arrays.copyOf(this.bodyParts, this.bodyParts.length);
    }

    @Override
    public String getContentType() {
        return null;
    }

    public static class BodyPart {
        private final String name;
        private final byte[] data;
        private final String contentType;
        private final String filename;

        public BodyPart(String name, byte[] data, String contentType, String filename) {
            this.name = name;
            this.data = Arrays.copyOf(data, data.length);
            this.contentType = contentType;
            this.filename = filename;
        }

        public String getName() {
            return this.name;
        }

        public byte[] getData() {
            return Arrays.copyOf(this.data, this.data.length);
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getFilename() {
            return this.filename;
        }
    }
}

