/*
 * Decompiled with CFR 0.152.
 */
package uk.co.autotrader.traverson;

import com.alibaba.fastjson2.JSONObject;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import uk.co.autotrader.traverson.exception.IllegalHttpStatusException;
import uk.co.autotrader.traverson.http.AuthCredential;
import uk.co.autotrader.traverson.http.Body;
import uk.co.autotrader.traverson.http.Method;
import uk.co.autotrader.traverson.http.Request;
import uk.co.autotrader.traverson.http.Response;
import uk.co.autotrader.traverson.http.TraversonClient;
import uk.co.autotrader.traverson.link.BasicLinkDiscoverer;
import uk.co.autotrader.traverson.link.LinkDiscoverer;
import uk.co.autotrader.traverson.link.hal.HalLinkDiscoverer;

public class TraversonBuilder {
    private TraversonClient traversonClient;
    private LinkDiscoverer linkDiscoverer;
    private Deque<String> relsToFollow;
    private Request request;

    TraversonBuilder(TraversonClient traversonClient) {
        this.traversonClient = traversonClient;
        this.relsToFollow = new LinkedList<String>();
        this.request = new Request();
    }

    public TraversonBuilder from(String startingUrl) {
        this.request.setUrl(startingUrl);
        return this;
    }

    public TraversonBuilder json() {
        this.request.setAcceptMimeType("application/json");
        this.linkDiscoverer = new BasicLinkDiscoverer();
        return this;
    }

    public TraversonBuilder jsonHal() {
        this.request.setAcceptMimeType("application/hal+json");
        this.linkDiscoverer = new HalLinkDiscoverer();
        return this;
    }

    public TraversonBuilder follow(String ... rels) {
        this.relsToFollow.clear();
        this.relsToFollow.addAll(Arrays.asList(rels));
        return this;
    }

    public TraversonBuilder withQueryParam(String name, String ... values) {
        this.request.addQueryParam(name, values);
        return this;
    }

    public TraversonBuilder withTemplateParam(String name, String ... values) {
        this.request.addTemplateParam(name, values);
        return this;
    }

    public TraversonBuilder withHeader(String name, String value) {
        this.request.addHeader(name, value);
        return this;
    }

    public TraversonBuilder withAuth(String username, String password) {
        return this.withAuth(username, password, null);
    }

    public TraversonBuilder withAuth(String username, String password, String hostname) {
        return this.withAuth(username, password, hostname, false);
    }

    public TraversonBuilder withAuth(String username, String password, String hostname, boolean preemptiveAuthentication) {
        this.request.addAuthCredential(new AuthCredential(username, password, hostname, preemptiveAuthentication));
        return this;
    }

    public Response<JSONObject> get() {
        return this.get(JSONObject.class);
    }

    public <T> Response<T> get(Class<T> returnType) {
        return this.traverseAndPerform(Method.GET, null, returnType);
    }

    public Response<JSONObject> delete() {
        return this.traverseAndPerform(Method.DELETE, null, JSONObject.class);
    }

    public <T> Response<T> delete(Class<T> returnType) {
        return this.traverseAndPerform(Method.DELETE, null, returnType);
    }

    public Response<JSONObject> post(Body body) {
        return this.traverseAndPerform(Method.POST, body, JSONObject.class);
    }

    public <T> Response<T> post(Body body, Class<T> returnType) {
        return this.traverseAndPerform(Method.POST, body, returnType);
    }

    public Response<JSONObject> put(Body body) {
        return this.traverseAndPerform(Method.PUT, body, JSONObject.class);
    }

    public <T> Response<T> put(Body body, Class<T> returnType) {
        return this.traverseAndPerform(Method.PUT, body, returnType);
    }

    public Response<JSONObject> patch(Body body) {
        return this.traverseAndPerform(Method.PATCH, body, JSONObject.class);
    }

    public <T> Response<T> patch(Body body, Class<T> returnType) {
        return this.traverseAndPerform(Method.PATCH, body, returnType);
    }

    private <T> Response<T> traverseAndPerform(Method terminalMethod, Body terminalBody, Class<T> returnType) {
        while (!this.relsToFollow.isEmpty()) {
            this.request.setMethod(Method.GET);
            Response<JSONObject> response = this.traversonClient.execute(this.request, JSONObject.class);
            if (response.isSuccessful()) {
                this.request.setUrl(this.linkDiscoverer.findHref(response.getResource(), this.relsToFollow.removeFirst()));
                continue;
            }
            throw new IllegalHttpStatusException(response.getStatusCode(), response.getUri());
        }
        this.request.setBody(terminalBody);
        this.request.setMethod(terminalMethod);
        return this.traversonClient.execute(this.request, returnType);
    }
}

