/*
 * Decompiled with CFR 0.152.
 */
package uk.co.alt236.resourcemirror.reflectors.base;

import android.content.res.Resources;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import uk.co.alt236.resourcemirror.containers.LruLinkedHashMap;
import uk.co.alt236.resourcemirror.reflectors.base.ResourceKeyFormatter;
import uk.co.alt236.resourcemirror.reflectors.base.ResourceReflector;
import uk.co.alt236.resourcemirror.util.ReflectionUtils;

public abstract class AbstractResourceReflector
implements ResourceReflector {
    protected static final String THE_DEFAULT_CONSTRUCTOR_WAS_CALLED = "The default Constructor was called! This should never happen...";
    private static final boolean TIME_LOGGING_ENABLED = false;
    private static final int CACHE_SIZE = 100;
    protected final ResourceKeyFormatter mKeyFormatter;
    private final AtomicBoolean mLogErrors;
    private final ReflectionUtils mReflectionUtils;
    private final Map<String, Integer> mCache;
    private final Map<String, Object> mCacheMisses;

    protected AbstractResourceReflector(String packageName) {
        this.mReflectionUtils = packageName == null ? null : new ReflectionUtils(packageName);
        this.mKeyFormatter = new ResourceKeyFormatter();
        this.mCache = new LruLinkedHashMap<String, Integer>(100, 0.75f);
        this.mCacheMisses = new LruLinkedHashMap<String, Object>(100, 0.75f);
        this.mLogErrors = new AtomicBoolean(false);
    }

    private void addToCache(String key, Integer value) {
        this.mCache.put(key, value);
    }

    private void addToMissCache(String key, Integer value) {
        this.mCacheMisses.put(key, value);
    }

    private synchronized int fetchResourceId(String resourceName, int fallbackResourceId) {
        Integer result;
        if (this.isKeyInMisses(resourceName)) {
            result = fallbackResourceId;
        } else {
            result = this.getFromCache(resourceName);
            if (result == null) {
                result = this.getReflectionUtils().reflectResource(this.getResourceType(), resourceName, fallbackResourceId, this.isErrorLoggingEnabled());
                if (result != null && result != fallbackResourceId) {
                    this.addToCache(resourceName, result);
                } else {
                    this.addToMissCache(resourceName, null);
                }
            }
        }
        return result;
    }

    public List<String> getAllResourceTypes() {
        return this.mReflectionUtils.getResourceTypes();
    }

    protected Integer getFromCache(String key) {
        return this.mCache.get(key);
    }

    protected abstract String getLogTag();

    protected ReflectionUtils getReflectionUtils() {
        return this.mReflectionUtils;
    }

    @Override
    public int getResourceId(String resourceName) {
        return this.getResourceId(resourceName, null);
    }

    @Override
    public int getResourceId(String resourceName, String family) {
        int resourceId = this.optResourceId(resourceName, family, -1);
        if (resourceId == -1) {
            throw new Resources.NotFoundException(this.mKeyFormatter.formatKey(resourceName, family));
        }
        return resourceId;
    }

    @Override
    public List<String> getResourceList() {
        return this.mReflectionUtils.getResourceList(this.getResourceType());
    }

    public boolean isErrorLoggingEnabled() {
        return this.mLogErrors.get();
    }

    private boolean isKeyInMisses(String key) {
        return this.mCacheMisses.containsKey(key);
    }

    @Override
    public int optResourceId(String resourceName, int fallbackResourceId) {
        return this.optResourceId(resourceName, null, fallbackResourceId);
    }

    @Override
    public int optResourceId(String resourceName, String family, int fallbackResourceId) {
        return this.fetchResourceId(this.mKeyFormatter.formatKey(resourceName, family), fallbackResourceId);
    }

    public void printResourcesToLogCat() {
        this.getReflectionUtils().logFields(this.getResourceType());
    }

    public void setLogErrors(boolean enable) {
        this.mLogErrors.set(enable);
    }
}

