/*
 * Decompiled with CFR 0.152.
 */
package uk.co.alt236.resourcemirror.reflectors;

import android.graphics.Color;
import android.util.Log;
import java.util.concurrent.atomic.AtomicBoolean;
import uk.co.alt236.resourcemirror.containers.DrawableResourceContainer;
import uk.co.alt236.resourcemirror.reflectors.base.AbstractResourceReflector;
import uk.co.alt236.resourcemirror.util.ResourceType;

public final class DrawableReflector
extends AbstractResourceReflector {
    public static final String ICON_PREFIX_BASE = "ic_";
    public static final String ICON_PREFIX_LAUNCHER = "ic_launcher_";
    public static final String ICON_PREFIX_MENU = "ic_menu_";
    public static final String ICON_PREFIX_STATUS_BAR = "ic_stat_notify_";
    public static final String ICON_PREFIX_TAB = "ic_tab_";
    public static final String ICON_PREFIX_DIALOG = "ic_dialog_";
    public static final String ICON_PREFIX_LIST = "ic_list_";
    private static final ResourceType RESOURCE_TYPE = ResourceType.DRAWABLE;
    private final String TAG = this.getClass().getName();
    private final AtomicBoolean mAddDrawableNameToContainer;

    private DrawableReflector() {
        super(null);
        Log.e((String)this.TAG, (String)"The default Constructor was called! This should never happen...");
        throw new IllegalStateException("The default Constructor was called! This should never happen...");
    }

    protected DrawableReflector(String packageName) {
        super(packageName);
        this.mAddDrawableNameToContainer = new AtomicBoolean(false);
    }

    private DrawableResourceContainer fetchDrawableContainer(String drawableName, String color, int fallbackDrawableId) {
        int res = this.optResourceId(drawableName, fallbackDrawableId);
        return new DrawableResourceContainer(this.mAddDrawableNameToContainer.get() ? drawableName : null, res, this.tryColor(color));
    }

    @Override
    protected String getLogTag() {
        return this.TAG;
    }

    @Override
    public ResourceType getResourceType() {
        return RESOURCE_TYPE;
    }

    public int optDialogDrawable(String drawableName, String family, int fallbackDrawableId) {
        return this.optResourceId(this.mKeyFormatter.formatKey(ICON_PREFIX_DIALOG, drawableName, family), fallbackDrawableId);
    }

    public DrawableResourceContainer optDialogDrawableContainer(String drawableName, String family, String colorString, int fallbackDrawableId) {
        return this.fetchDrawableContainer(this.mKeyFormatter.formatKey(ICON_PREFIX_DIALOG, drawableName, family), colorString, fallbackDrawableId);
    }

    public DrawableResourceContainer optDrawableContainer(String drawableName, String colorString, int fallbackDrawableId) {
        return this.optDrawableContainer(drawableName, null, colorString, fallbackDrawableId);
    }

    public DrawableResourceContainer optDrawableContainer(String drawableName, String family, String colorString, int fallbackDrawableId) {
        return this.fetchDrawableContainer(this.mKeyFormatter.formatKey(drawableName, family), colorString, fallbackDrawableId);
    }

    public DrawableResourceContainer optLauncherDrawableContainer(String drawableName, String family, String colorString, int fallbackDrawableId) {
        return this.fetchDrawableContainer(this.mKeyFormatter.formatKey(ICON_PREFIX_LAUNCHER, drawableName, family), colorString, fallbackDrawableId);
    }

    public int optLauncherDrawableId(String drawableName, String family, int fallbackDrawableId) {
        return this.optResourceId(this.mKeyFormatter.formatKey(ICON_PREFIX_LAUNCHER, drawableName, family), fallbackDrawableId);
    }

    public DrawableResourceContainer optListDrawableContainer(String drawableName, String family, String colorString, int fallbackDrawableId) {
        return this.fetchDrawableContainer(this.mKeyFormatter.formatKey(ICON_PREFIX_LIST, drawableName, family), colorString, fallbackDrawableId);
    }

    public int optListDrawableId(String drawableName, String family, int fallbackDrawableId) {
        return this.optResourceId(this.mKeyFormatter.formatKey(ICON_PREFIX_LIST, drawableName, family), fallbackDrawableId);
    }

    public DrawableResourceContainer optMenuDrawableContainer(String drawableName, String family, String colorString, int fallbackDrawableId) {
        return this.fetchDrawableContainer(this.mKeyFormatter.formatKey(ICON_PREFIX_MENU, drawableName, family), colorString, fallbackDrawableId);
    }

    public int optMenuDrawableId(String drawableName, String family, int fallbackDrawableId) {
        return this.optResourceId(this.mKeyFormatter.formatKey(ICON_PREFIX_MENU, drawableName, family), fallbackDrawableId);
    }

    public DrawableResourceContainer optStatusBarDrawableContainer(String drawableName, String family, String colorString, int fallbackDrawableId) {
        return this.fetchDrawableContainer(this.mKeyFormatter.formatKey(ICON_PREFIX_STATUS_BAR, drawableName, family), colorString, fallbackDrawableId);
    }

    public int optStatusBarDrawableId(String drawableName, String family, int fallbackDrawableId) {
        return this.optResourceId(this.mKeyFormatter.formatKey(ICON_PREFIX_STATUS_BAR, drawableName, family), fallbackDrawableId);
    }

    public DrawableResourceContainer optTabDrawableContainer(String drawableName, String family, String colorString, int fallbackDrawableId) {
        return this.fetchDrawableContainer(this.mKeyFormatter.formatKey(ICON_PREFIX_TAB, drawableName, family), colorString, fallbackDrawableId);
    }

    public int optTabDrawableId(String drawableName, String family, int fallbackDrawableId) {
        return this.optResourceId(this.mKeyFormatter.formatKey(ICON_PREFIX_TAB, drawableName, family), fallbackDrawableId);
    }

    public synchronized void setAddDrawableNameToContainer(boolean enable) {
        this.mAddDrawableNameToContainer.set(enable);
    }

    private Integer tryColor(String colorString) {
        if (colorString == null || colorString.length() < 1) {
            return null;
        }
        try {
            return Color.parseColor((String)colorString);
        }
        catch (IllegalArgumentException e) {
            if (this.isErrorLoggingEnabled()) {
                Log.w((String)this.TAG, (String)("tryColor() - IllegalArgumentException while trying to parse color '" + colorString + "'"));
            }
            return null;
        }
    }
}

