/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.horizon.artcodes.scanner;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.util.List;
import uk.ac.horizon.artcodes.animator.TextAnimator;
import uk.ac.horizon.artcodes.animator.VisibilityAnimator;
import uk.ac.horizon.artcodes.camera.CameraView;
import uk.ac.horizon.artcodes.detect.ArtcodeDetector;
import uk.ac.horizon.artcodes.detect.DetectorCallback;
import uk.ac.horizon.artcodes.detect.DetectorSetting;
import uk.ac.horizon.artcodes.detect.handler.CodeDetectionHandler;
import uk.ac.horizon.artcodes.detect.handler.MarkerCodeDetectionHandler;
import uk.ac.horizon.artcodes.model.Experience;
import uk.ac.horizon.artcodes.scanner.R;

public class ScannerActivity
extends AppCompatActivity {
    private static final int CAMERA_PERMISSION_REQUEST = 47;
    private LinearLayout settingIcons;
    protected ProgressBar progressBar;
    private ArtcodeDetector detector;
    private Experience experience;
    private VisibilityAnimator menuAnimator;
    private TextAnimator textAnimator;
    private CameraView cameraView;
    private boolean focusTextAlreadyShown = false;

    public void hideMenu(View view) {
        this.menuAnimator.hideView();
    }

    @TargetApi(value=16)
    private void hideSystemUI() {
        if (Build.VERSION.SDK_INT >= 16) {
            this.getWindow().getDecorView().setSystemUiVisibility(768);
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().addFlags(128);
        this.getWindow().addFlags(1024);
        this.hideSystemUI();
        this.setContentView(R.layout.scanner);
        this.settingIcons = (LinearLayout)this.findViewById(R.id.settingsSwitches);
        this.progressBar = (ProgressBar)this.findViewById(R.id.progressBar);
        this.cameraView = (CameraView)this.findViewById(R.id.cameraView);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(toolbar);
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().setDisplayShowTitleEnabled(false);
        }
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.CAMERA") != 0) {
            ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.CAMERA"}, (int)47);
        }
        this.menuAnimator = new VisibilityAnimator(this.findViewById(R.id.settingsMenu), this.findViewById(R.id.settingsMenuButton));
        TextView settingsFeedback = (TextView)this.findViewById(R.id.settingsFeedback);
        this.textAnimator = new TextAnimator(settingsFeedback);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        switch (requestCode) {
            case 47: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    this.startScanning();
                    break;
                }
                Log.i((String)"a", (String)"Permission not granted");
            }
        }
    }

    public void loaded(Experience experience) {
        this.experience = experience;
        this.startScanning();
    }

    public void showMenu(View view) {
        this.createSettingsUI(this.detector.getSettings());
        this.menuAnimator.showView();
    }

    protected Experience getExperience() {
        return this.experience;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332 && this.getCallingActivity() != null) {
            this.setResult(0);
            this.finish();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void startScanning() {
        if (this.experience != null) {
            Log.i((String)"a", (String)"Start Scanning");
            this.detector = this.getNewDetector(this.experience);
            this.detector.setCallback(new DetectorCallback(){

                @Override
                public void detectionStart(final int margin) {
                    ScannerActivity.this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            View errorView = ScannerActivity.this.findViewById(R.id.cameraError);
                            if (errorView != null) {
                                errorView.setVisibility(8);
                            }
                            ScannerActivity.this.progressBar.setVisibility(0);
                            if (ScannerActivity.this.getResources().getConfiguration().orientation == 1) {
                                View bottomView;
                                View topView = ScannerActivity.this.findViewById(R.id.topView);
                                if (topView != null) {
                                    topView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, margin));
                                }
                                if ((bottomView = ScannerActivity.this.findViewById(R.id.bottomView)) != null) {
                                    bottomView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, margin));
                                }
                            } else {
                                View bottomView;
                                View topView = ScannerActivity.this.findViewById(R.id.topView);
                                if (topView != null) {
                                    topView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(margin, -1));
                                }
                                if ((bottomView = ScannerActivity.this.findViewById(R.id.bottomView)) != null) {
                                    bottomView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(margin, -1));
                                }
                            }
                        }
                    });
                }
            });
            this.detector.setOverlay((ImageView)this.findViewById(R.id.overlay));
            if (this.getSupportActionBar() != null) {
                this.getSupportActionBar().setDisplayShowTitleEnabled(true);
                this.getSupportActionBar().setTitle((CharSequence)this.experience.getName());
            }
            this.cameraView.setDetector(this.detector, this.experience);
            if (this.cameraView.deviceNeedsTapToFocus()) {
                View v = this.findViewById(R.id.thumbnailImageLayout);
                if (v != null) {
                    v.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            ScannerActivity.this.setFocusTextVisible(false);
                            ScannerActivity.this.cameraView.focus(new Runnable(){

                                @Override
                                public void run() {
                                    ScannerActivity.this.setFocusTextVisible(true);
                                }
                            });
                        }
                    });
                }
                this.setFocusTextVisible(true);
            }
        } else {
            this.cameraView.setDetector(null, null);
        }
    }

    private void setFocusTextVisible(final boolean visible) {
        final TextView focusTextView = (TextView)this.findViewById(R.id.focusText);
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (focusTextView != null) {
                    if (ScannerActivity.this.focusTextAlreadyShown) {
                        focusTextView.setText(R.string.tap_to_refocus);
                        focusTextView.setTextSize(1, 18.0f);
                        focusTextView.setGravity(49);
                    }
                    if (visible) {
                        focusTextView.setVisibility(0);
                    } else {
                        focusTextView.setVisibility(4);
                        ScannerActivity.this.focusTextAlreadyShown = true;
                    }
                }
            }
        });
    }

    private void onCodeDetected(String markerCode) {
        Log.i((String)"Marker", (String)("MarkerDisplay Detected: " + markerCode));
        if (markerCode != null) {
            if (this.experience.getCallback() != null) {
                this.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)this.experience.getCallback().replace("{code}", markerCode))));
            } else {
                Intent intent = this.getIntent();
                intent.putExtra("marker", markerCode);
                this.setResult(-1, intent);
                this.finish();
            }
        }
    }

    protected void loadExperience(Bundle savedInstanceState) {
        if (savedInstanceState != null && savedInstanceState.containsKey("experience")) {
            this.loaded((Experience)new Gson().fromJson(savedInstanceState.getString("experience"), Experience.class));
        } else {
            Intent intent = this.getIntent();
            if (intent.hasExtra("experience")) {
                this.loaded((Experience)new Gson().fromJson(intent.getStringExtra("experience"), Experience.class));
            }
        }
    }

    protected void onPostCreate(Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        this.loadExperience(savedInstanceState);
    }

    private Drawable getTintedDrawable(@DrawableRes int drawable2, @ColorInt int color) {
        Drawable original = ContextCompat.getDrawable((Context)this, (int)drawable2);
        if (original != null) {
            Drawable wrapDrawable = DrawableCompat.wrap((Drawable)original);
            DrawableCompat.setTint((Drawable)wrapDrawable, (int)color);
            return wrapDrawable;
        }
        return null;
    }

    private void createSettingsUI(List<DetectorSetting> settings) {
        this.settingIcons.removeAllViews();
        if (settings != null && !settings.isEmpty()) {
            int padding = this.getResources().getDimensionPixelSize(R.dimen.setting_padding);
            List settingList = settings;
            if (this.getResources().getConfiguration().orientation == 2) {
                settingList = Lists.reverse(settings);
            }
            for (final DetectorSetting setting : settingList) {
                final ImageView button = new ImageView((Context)this);
                button.setContentDescription((CharSequence)this.getString(setting.getText()));
                int[] attrs = new int[]{16843534};
                TypedArray ta = this.obtainStyledAttributes(attrs);
                Drawable drawableFromTheme = ta.getDrawable(0);
                ta.recycle();
                if (Build.VERSION.SDK_INT >= 21) {
                    button.setImageResource(setting.getIcon());
                    button.setImageTintList(ColorStateList.valueOf((int)-1));
                    button.setBackground(drawableFromTheme);
                } else {
                    button.setImageDrawable(this.getTintedDrawable(setting.getIcon(), -1));
                    button.setBackgroundDrawable(drawableFromTheme);
                }
                button.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        setting.nextValue();
                        if (Build.VERSION.SDK_INT >= 21) {
                            button.setImageResource(setting.getIcon());
                        } else {
                            button.setImageDrawable(ScannerActivity.this.getTintedDrawable(setting.getIcon(), -1));
                        }
                        button.setContentDescription((CharSequence)ScannerActivity.this.getString(setting.getText()));
                        ScannerActivity.this.textAnimator.setText(setting.getText());
                    }
                });
                LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2, 1.0f);
                params.weight = 1.0f;
                button.setLayoutParams((ViewGroup.LayoutParams)params);
                this.settingIcons.addView((View)button);
                button.setPadding(padding, padding, padding, padding);
            }
        }
        this.menuAnimator.setViewVisible(this.settingIcons.getChildCount() > 0);
    }

    protected ArtcodeDetector getNewDetector(Experience experience) {
        return new ArtcodeDetector((Context)this, experience, new MarkerCodeDetectionHandler(this.experience, new CodeDetectionHandler(){

            @Override
            public void onMarkerCodeDetected(String code) {
                ScannerActivity.this.onCodeDetected(code);
            }
        }));
    }
}

